/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.adapter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.StringUtils;

public class DateTimeOrDateAdapter
extends XmlAdapter<String, Date> {
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_DATE_TIME_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        }
    };
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd.MM.yyyy");
        }
    };

    @Override
    public String marshal(Date value) throws Exception {
        return value != null ? THREAD_LOCAL_DATE_TIME_FORMATTER.get().format(value) : null;
    }

    @Override
    public Date unmarshal(String value) throws Exception {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        Date result = null;
        try {
            result = THREAD_LOCAL_DATE_TIME_FORMATTER.get().parse(value);
        }
        catch (ParseException parseException) {
            result = THREAD_LOCAL_DATE_FORMATTER.get().parse(value);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        DateTimeOrDateAdapter dateTimeMillisAdapter = new DateTimeOrDateAdapter();
        System.out.println(dateTimeMillisAdapter.unmarshal("17.06.2023 12:21:21"));
    }
}

