/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.model;

import java.util.Arrays;
import ru.uss.core.model.Error;
import ru.uss.core.model.ErrorCode;

public class ErrorBuilder {
    private Error error;

    public static ErrorBuilder getErrorBuilder() {
        ErrorBuilder builder = new ErrorBuilder();
        builder.error = new Error();
        return builder;
    }

    public ErrorBuilder text(String text) {
        this.error.setText(text);
        return this;
    }

    public ErrorBuilder stackTraceAsText(StackTraceElement[] stackTraceElements) {
        this.error.setText(Arrays.toString(stackTraceElements));
        return this;
    }

    public ErrorBuilder errorCode(ErrorCode errorCode) {
        this.error.setErrorCode(errorCode);
        return this;
    }

    public ErrorBuilder property(String property) {
        this.error.setProperty(property);
        return this;
    }

    public ErrorBuilder documentId(Long documentId) {
        this.error.setDocumentId(documentId);
        return this;
    }

    public Error getError() {
        return this.error;
    }
}

