/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Years;

public class DateTimeUtils {
    public static final String MONTH_PATTERN = "MM.yyyy";
    private static final ThreadLocal<SimpleDateFormat> MONTH_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(MONTH_PATTERN));
    public static final String DATE_PATTERN = "dd.MM.yyyy";
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_PATTERN));
    public static final String DATE_TIME_PATTERN = "dd.MM.yyyy HH:mm:ss";
    private static final ThreadLocal<SimpleDateFormat> DATE_TIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_PATTERN));
    public static final String DATE_TIME_MILLS_PATTERN = "dd.MM.yyyy HH:mm:ss.SSS";
    private static final ThreadLocal<SimpleDateFormat> DATE_TIME_MILLS_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_MILLS_PATTERN));
    public static final String DATE_TIME_MINUTES_PATTERN = "dd.MM.yyyy HH:mm";
    public static Date ESF_START_DATE;
    public static final int QUARTER_SIZE_IN_DAYS = 93;
    public static final int DAY_SIZE_IN_MINUTES = 1440;
    public static final Map<Integer, String> MONTH_NAMES_MAP;

    public static String getMonthName(int month) {
        return MONTH_NAMES_MAP.get(month);
    }

    public static boolean lessOrEquals(Date date, Date when) {
        return date.getTime() <= when.getTime();
    }

    public static boolean lessThan(Date date, Date when) {
        return date.getTime() < when.getTime();
    }

    public static boolean greaterThan(Date date, Date when) {
        return date.getTime() > when.getTime();
    }

    public static boolean greaterOrEquals(Date date, Date when) {
        return date.getTime() >= when.getTime();
    }

    public static Date startOfTheDay(String source) {
        return DateTimeUtils.startOfTheDay(DateTimeUtils.getDate(source, DATE_PATTERN));
    }

    public static Date startOfTheDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date endOfTheDay(String source) {
        return DateTimeUtils.endOfTheDay(DateTimeUtils.getDate(source, DATE_PATTERN));
    }

    public static Date endOfTheDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date zeroMillis(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date copyTime(Date sourceDate, Date targetDate) {
        Calendar sourceCalendar = Calendar.getInstance();
        Calendar targetCalendar = Calendar.getInstance();
        sourceCalendar.setTime(sourceDate);
        targetCalendar.setTime(targetDate);
        targetCalendar.set(11, sourceCalendar.get(11));
        targetCalendar.set(12, sourceCalendar.get(12));
        targetCalendar.set(13, sourceCalendar.get(13));
        targetCalendar.set(14, sourceCalendar.get(14));
        return targetCalendar.getTime();
    }

    public static Date getRandomDateOfCurrentYear() {
        int year = Calendar.getInstance().get(1);
        Random rand = new Random();
        return DateTimeUtils.getDateByDayAndYear(rand.nextInt() % 365 + 1, year);
    }

    public static Date getDateByDayAndYear(int day, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, day);
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static Date getDateByMonthAndYear(int month, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(2, month - 1);
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static Date getDateByQuarterAndYear(int quarter, int year) {
        int month = (quarter - 1) * 3;
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(2, month);
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static Date plusDays(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(6, days);
        return c.getTime();
    }

    public static Date minusDays(Date date, int days) {
        return DateTimeUtils.plusDays(date, -days);
    }

    public static Date minusMonth(Date date, int months) {
        return DateTimeUtils.plusMonths(date, -months);
    }

    public static Long hoursBetweenDates(Date from, Date to) {
        long secs = (to.getTime() - from.getTime()) / 1000L;
        return secs / 3600L;
    }

    public static Date plusMonths(Date date, int months) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, months);
        return c.getTime();
    }

    public static Date plusYears(Date date, int years) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, years);
        return c.getTime();
    }

    public static Date plusMinutes(Date date, int minutes) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, minutes);
        return c.getTime();
    }

    public static Date plusHours(Date date, int hours) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(10, hours);
        return c.getTime();
    }

    public static Date plusSeconds(Date date, int seconds) {
        return DateTimeUtils.plusMilliseconds(date, seconds * 1000);
    }

    public static Date plusMilliseconds(Date date, int milliseconds) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(14, milliseconds);
        return c.getTime();
    }

    private static boolean isNotMoreThanSomeMonthsPeriod(Date fromDate, Date toDate, int months) {
        if (fromDate == null || toDate == null) {
            return false;
        }
        return DateTimeUtils.plusMonths(fromDate, months).getTime() >= toDate.getTime();
    }

    public static boolean isNotMoreThanOneMonthPeriod(Date fromDate, Date toDate) {
        return DateTimeUtils.isNotMoreThanSomeMonthsPeriod(fromDate, toDate, 1);
    }

    public static boolean isNotMoreThanThreeMonthsPeriod(Date fromDate, Date toDate) {
        return DateTimeUtils.isNotMoreThanSomeMonthsPeriod(fromDate, toDate, 3);
    }

    public static boolean isNotMoreThanOneDayPeriod(Date fromDate, Date toDate) {
        if (fromDate == null || toDate == null) {
            return false;
        }
        return DateTimeUtils.plusDays(fromDate, 1).getTime() >= toDate.getTime();
    }

    public static Date getDate(String source) {
        return DateTimeUtils.getDate(source, DATE_PATTERN);
    }

    public static boolean isCanBeParsed(String date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        boolean returnFlag = true;
        try {
            dateFormat.parse(date);
        }
        catch (ParseException e) {
            returnFlag = false;
        }
        return returnFlag;
    }

    public static Date getNullableDate(String source, String format) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        return DateTimeUtils.getDate(source, format);
    }

    public static Date getDate(String source, String format) {
        try {
            return new SimpleDateFormat(format).parse(source);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Wrong source date '" + source + "'");
        }
    }

    public static String getStringDate(Date source) {
        if (source == null) {
            return null;
        }
        return DATE_FORMAT.get().format(source);
    }

    public static String getStringDate(Date source, String format) {
        return new SimpleDateFormat(format).format(source);
    }

    public static Date parseDate(String source) {
        return DateTimeUtils.parseDate(source, DATE_PATTERN);
    }

    public static Date parseDate(String source, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(source);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toMonthFormat(Date date) {
        if (date == null) {
            return null;
        }
        return MONTH_FORMAT.get().format(date);
    }

    public static String toDateFormat(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMAT.get().format(date);
    }

    public static String toDateTimeWithMillsFormat(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_TIME_MILLS_FORMAT.get().format(date);
    }

    public static String toDateFormat(Date date, String pattern) {
        if (date == null || pattern == null || pattern.isEmpty()) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static String toDateFormat(Long millis) {
        if (millis == null) {
            return null;
        }
        return DateTimeUtils.toDateFormat(new Date(millis));
    }

    public static String toDateTimeFormat(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_TIME_FORMAT.get().format(date);
    }

    public static Date getMinimalDate(Date ... dates) {
        if (dates == null || dates.length == 0) {
            return null;
        }
        Date result = null;
        for (Date date : dates) {
            if (date == null) continue;
            if (result == null) {
                result = date;
                continue;
            }
            if (date.getTime() >= result.getTime()) continue;
            result = date;
        }
        return result;
    }

    public static boolean sameDay(long dateInMillis1, long dateInMillis2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dateInMillis1);
        int year1 = calendar.get(1);
        int day1 = calendar.get(6);
        calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dateInMillis2);
        int year2 = calendar.get(1);
        int day2 = calendar.get(6);
        return year1 == year2 && day1 == day2;
    }

    public static int getDaysBetweenDates(Date from, Date to) {
        DateTime jFrom = new DateTime(from);
        DateTime jTo = new DateTime(to);
        return Days.daysBetween(jFrom, jTo).getDays();
    }

    public static long getHoursBetweenDates(Date from, Date to) {
        long fromMinutes = TimeUnit.MILLISECONDS.toHours(from.getTime());
        long toMinutes = TimeUnit.MILLISECONDS.toHours(to.getTime());
        return toMinutes - fromMinutes;
    }

    public static long getMinutesBetweenDates(Date from, Date to) {
        long fromMinutes = TimeUnit.MILLISECONDS.toMinutes(from.getTime());
        long toMinutes = TimeUnit.MILLISECONDS.toMinutes(to.getTime());
        return toMinutes - fromMinutes;
    }

    public static double getSecondsBetweenDates(long startTimeMilis, long endTimeMilis) {
        return (endTimeMilis - startTimeMilis) / 1000L;
    }

    public static long minus(Date from, Date to) {
        LocalDate d1 = from.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate d2 = to.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Duration diff = Duration.between(d1.atStartOfDay(), d2.atStartOfDay());
        return diff.toDays();
    }

    public static Date max(Date date1, Date date2) {
        long date2Mls;
        long date1Mls = date1.getTime();
        if (date1Mls > (date2Mls = date2.getTime())) {
            return date1;
        }
        return date2;
    }

    public static Date min(Date date1, Date date2) {
        long date2Mls;
        long date1Mls = date1.getTime();
        if (date1Mls < (date2Mls = date2.getTime())) {
            return date1;
        }
        return date2;
    }

    public static boolean isFutureDate(Date date) {
        return DateTimeUtils.max(date, new Date()).equals(date);
    }

    public static boolean isPastDate(Date date) {
        return !DateTimeUtils.isFutureDate(date);
    }

    public static int getYearsBetweenDates(Date from, Date to) {
        DateTime jFrom = new DateTime(from);
        DateTime jTo = new DateTime(to);
        return Years.yearsBetween(jFrom, jTo).getYears();
    }

    public static Date now() {
        return new Date();
    }

    public static Date clone(Date date) {
        return date != null ? new Date(date.getTime()) : null;
    }

    public static Date today() {
        return DateUtils.truncate(new Date(), 5);
    }

    public static int getDateWeekDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        return calendar.get(7);
    }

    public static boolean isDateValid(String value, String format) {
        if (value == null) {
            return false;
        }
        try {
            SimpleDateFormat f = new SimpleDateFormat(format);
            f.setLenient(false);
            f.parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isIntersect(Date dateFromPeriod1, Date dateToPeriod1, Date dateFromPeriod2, Date dateToPeriod2) {
        return DateTimeUtils.isBetween(dateFromPeriod1, dateToPeriod1, dateFromPeriod2) || DateTimeUtils.isBetween(dateFromPeriod1, dateToPeriod1, dateToPeriod2);
    }

    public static boolean isBetween(Date rangeFrom, Date rangeTo, Date searchDate) {
        return rangeFrom.compareTo(searchDate) * searchDate.compareTo(rangeTo) >= 0;
    }

    public static XMLGregorianCalendar dateAsXMLGregorianCalendar(Date source) {
        if (source == null) {
            return null;
        }
        GregorianCalendar result = new GregorianCalendar();
        result.setTime(source);
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(result);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date convertFromXmlGregorianCalendar(XMLGregorianCalendar date) {
        return date == null ? null : date.toGregorianCalendar().getTime();
    }

    public static List<Date> generateDateRangeList(Date startDate, Date endDate, boolean includeStartDate, boolean includeEndDate, boolean includeWeekends) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        Calendar calendarStart = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarStart.setTime(startDate);
        calendarStart.set(11, 0);
        calendarStart.set(12, 0);
        calendarStart.set(13, 0);
        calendarStart.set(14, 0);
        calendarEnd.setTime(endDate);
        calendarEnd.set(11, 0);
        calendarEnd.set(12, 0);
        calendarEnd.set(13, 0);
        calendarEnd.set(14, 0);
        if (!includeStartDate) {
            calendarStart.add(5, 1);
        }
        if (!includeEndDate) {
            calendarEnd.add(5, -1);
        }
        while (calendarEnd.equals(calendarStart) || calendarEnd.after(calendarStart)) {
            if (includeWeekends || DateTimeUtils.isNotWeekend(calendarStart)) {
                dateList.add(calendarStart.getTime());
            }
            calendarStart.add(5, 1);
        }
        return dateList;
    }

    public static boolean isNotWeekend(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateTimeUtils.isNotWeekend(calendar);
    }

    public static boolean isNotWeekend(Calendar calendar) {
        boolean result = false;
        switch (calendar.get(7)) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                result = true;
                break;
            }
            case 1: 
            case 7: {
                result = false;
            }
        }
        return result;
    }

    public static Integer getDateAsNumber(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
    }

    public static Integer getDateMonthAsNumber(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1) * 100 + (calendar.get(2) + 1);
    }

    public static boolean isLastDayOfMonth(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5) == calendar.getActualMaximum(5);
    }

    public static int getYearFromDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonthFromDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    static {
        MONTH_NAMES_MAP = new HashMap<Integer, String>();
        try {
            ESF_START_DATE = DATE_TIME_FORMAT.get().parse("30.06.2014 23:59:59");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MONTH_NAMES_MAP.put(0, "\u042f\u043d\u0432\u0430\u0440\u044c");
        MONTH_NAMES_MAP.put(1, "\u0424\u0435\u0432\u0440\u0430\u043b\u044c");
        MONTH_NAMES_MAP.put(2, "\u041c\u0430\u0440\u0442");
        MONTH_NAMES_MAP.put(3, "\u0410\u043f\u0440\u0435\u043b\u044c");
        MONTH_NAMES_MAP.put(4, "\u041c\u0430\u0439");
        MONTH_NAMES_MAP.put(5, "\u0418\u044e\u043d\u044c");
        MONTH_NAMES_MAP.put(6, "\u0418\u044e\u043b\u044c");
        MONTH_NAMES_MAP.put(7, "\u0410\u0432\u0433\u0443\u0441\u0442");
        MONTH_NAMES_MAP.put(8, "\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c");
        MONTH_NAMES_MAP.put(9, "\u041e\u043a\u0442\u044f\u0431\u0440\u044c");
        MONTH_NAMES_MAP.put(10, "\u041d\u043e\u044f\u0431\u0440\u044c");
        MONTH_NAMES_MAP.put(11, "\u0414\u0435\u043a\u0430\u0431\u0440\u044c");
    }
}

