/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.exception.JsonParseException;
import ru.uss.core.utils.BigDecimalUtils;

public class DefaultBigDecimalDeserializer
extends JsonDeserializer<BigDecimal> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBigDecimalDeserializer.class);

    @Override
    public BigDecimal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        try {
            String numberString = jsonParser.getText();
            if (NumberUtils.isCreatable(numberString)) {
                return BigDecimalUtils.stripTrailingZeros(BigDecimal.valueOf(Double.parseDouble(numberString)));
            }
            throw new JsonParseException("message_decimal_number_format");
        }
        catch (Exception ex) {
            try {
                logger.warn(ex.getMessage() + " {'" + jsonParser.getCurrentName() + "':'" + jsonParser.getText() + "'}");
            }
            catch (IOException ie) {
                ie.initCause(ex);
                logger.warn(ie.getMessage(), ie);
            }
            throw new JsonParseException("message_decimal_number_format");
        }
    }
}

