/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;
import ru.uss.core.exception.XmlParseException;
import ru.uss.core.utils.JsonHelper;
import ru.uss.core.utils.ValidatorErrorHandler;
import ru.uss.core.xsd.UssSchemaOutputResolver;

public class JAXBUtils {
    private static final ConcurrentMap<Class<?>, JAXBContext> CONTEXTS = new ConcurrentHashMap();

    public static JAXBContext context(Class<?> requiredClass) {
        return CONTEXTS.computeIfAbsent(requiredClass, JAXBUtils::createContext);
    }

    public static Schema scheme(Class<?> requiredClass) {
        return JAXBUtils.scheme(requiredClass, sources -> {
            Collections.reverse(sources);
            return (Source[])sources.stream().toArray(Source[]::new);
        });
    }

    public static Schema scheme(Class<?> requiredClass, Function<List<Source>, Source[]> mapper) {
        try {
            UssSchemaOutputResolver resolver2 = JAXBUtils.resolver(requiredClass);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            return schemaFactory.newSchema(mapper.apply(resolver2.getSources()));
        }
        catch (Exception e) {
            throw new RuntimeException("Can`t create schema", e);
        }
    }

    public static boolean isValid(String source, Schema schema) {
        return CollectionUtils.isEmpty(JAXBUtils.getXmlSchemaErrors(source, schema));
    }

    public static Set<String> getXmlSchemaErrors(String source, Schema schema) {
        Set<String> schemaErrors = Collections.emptySet();
        try {
            ValidatorErrorHandler handler = new ValidatorErrorHandler();
            Validator validator = schema.newValidator();
            validator.setErrorHandler(handler);
            validator.validate(new StreamSource(new StringReader(source)));
            if (handler.hasErrors()) {
                schemaErrors = handler.getErrors().stream().map(Throwable::getMessage).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can`t validate:\n" + source, e);
        }
        return schemaErrors;
    }

    public static String getValidationErrors(String source, Schema schema) {
        String validationErrorMessage = null;
        try {
            ValidatorErrorHandler handler = new ValidatorErrorHandler();
            Validator validator = schema.newValidator();
            validator.setErrorHandler(handler);
            validator.validate(new StreamSource(new StringReader(source)));
            validationErrorMessage = handler.getErrors().stream().map(Throwable::getMessage).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            throw new RuntimeException("Can`t validate:\n" + source, e);
        }
        return validationErrorMessage;
    }

    public static <T> T toObject(String source, Class<T> requiredClass) {
        try {
            return JAXBUtils.toObjectWithException(source, requiredClass);
        }
        catch (JAXBException e) {
            String message = "Can`t transform XML to object \r\nCause exception: " + ExceptionUtils.getMessage(e) + " \r\nSource xml: " + source + " \r\nRequired class to transform: " + (requiredClass == null ? null : requiredClass.getName());
            throw new XmlParseException(message, e);
        }
    }

    public static <T> T toObjectWithException(String source, Class<T> requiredClass) throws JAXBException {
        JAXBContext context = JAXBUtils.context(requiredClass);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        StringReader reader = new StringReader(source.trim());
        return (T)unmarshaller.unmarshal(reader);
    }

    public static <T> T toObjectWithSchemeValidation(String source, Unmarshaller unmarshaller) {
        try {
            StringReader reader = new StringReader(source.trim());
            return (T)unmarshaller.unmarshal(reader);
        }
        catch (JAXBException e) {
            Throwable firstCause;
            for (firstCause = e; firstCause != null && !(firstCause instanceof SAXParseException) && !(firstCause instanceof ParseException); firstCause = ((Throwable)firstCause).getCause()) {
            }
            String message = "Can`t transform XML to object \r\nCause exception: " + ExceptionUtils.getMessage(firstCause) + " \r\nSource xml: " + source;
            throw new XmlParseException(message, e);
        }
    }

    public static String toFormattedNonFragmentXml(Object source) {
        return JAXBUtils.toXml(source, null, false, true);
    }

    public static String toXml(Object source, Schema schema, boolean fragment, boolean formatted) {
        try {
            JAXBContext context = JAXBUtils.context(source.getClass());
            Marshaller marshaller = context.createMarshaller();
            if (schema != null) {
                marshaller.setSchema(schema);
            }
            if (fragment) {
                marshaller.setProperty("jaxb.fragment", true);
            }
            if (formatted) {
                marshaller.setProperty("jaxb.formatted.output", true);
            }
            StringWriter writer = new StringWriter();
            marshaller.marshal(source, writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Can`t transform object to XML:\n" + JsonHelper.writeValueAsString(source), e);
        }
    }

    public static UssSchemaOutputResolver resolver(Class ... requiredClasses) {
        try {
            UssSchemaOutputResolver resolver2 = new UssSchemaOutputResolver();
            JAXBContext context = JAXBContext.newInstance(requiredClasses);
            context.generateSchema(resolver2);
            return resolver2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JAXBContext createContext(Class<?> requiredClass) {
        try {
            return JAXBContext.newInstance(requiredClass);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Can`t create JAXB context", e);
        }
    }

    public static <T> byte[] marshalWithCDATA(T object, Class<T> requiredClass, String ... cdataFields) throws JAXBException, ParserConfigurationException, TransformerException {
        return JAXBUtils.marshalWithCDATA(JAXBUtils.marshalToDocument(object, requiredClass), cdataFields);
    }

    public static <T> byte[] marshal(T object, Class<T> requiredClass) throws JAXBException, ParserConfigurationException, TransformerException {
        return JAXBUtils.marshalWithCDATA(JAXBUtils.marshalToDocument(object, requiredClass), new String[0]);
    }

    private static Document marshalToDocument(Object object, Class<?> requiredClass) throws ParserConfigurationException, JAXBException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = docBuilderFactory.newDocumentBuilder().newDocument();
        JAXBContext context = JAXBContext.newInstance(requiredClass);
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal(object, document);
        return document;
    }

    private static byte[] marshalWithCDATA(Document document, String ... cdataFields) throws TransformerException {
        String cdataFieldsString = String.join((CharSequence)" ", cdataFields);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("cdata-section-elements", cdataFieldsString);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(document), new StreamResult(result));
        return result.toByteArray();
    }

    private static byte[] marshal(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(document), new StreamResult(result));
        return result.toByteArray();
    }
}

