/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public interface LocaleUtils {
    public static final String LANGUAGE_RU = "ru";
    public static final String LANGUAGE_KK = "kk";
    public static final String COUNTRY_RU = "RU";
    public static final String COUNTRY_KZ = "KZ";
    public static final Locale RU = new Locale("ru", "RU");
    public static final Locale KZ = new Locale("kk", "KZ");

    public static boolean isLocaleRU(Locale locale) {
        return locale != null && LocaleUtils.getLocaleByLang(locale.getLanguage()) == RU;
    }

    public static boolean isLocaleKZ(Locale locale) {
        return locale != null && LocaleUtils.getLocaleByLang(locale.getLanguage()) == KZ;
    }

    public static Locale getLocaleByLang(String lang) {
        if (!StringUtils.isEmpty(lang)) {
            switch (lang.toLowerCase()) {
                case "ru": {
                    return RU;
                }
                case "kk": {
                    return KZ;
                }
                case "kz": {
                    return KZ;
                }
            }
            return RU;
        }
        return RU;
    }

    public static String getPreferable(Locale locale, String valueRu, String valueKz) {
        if (LocaleUtils.isLocaleRU(locale)) {
            return LocaleUtils.notBlank(valueRu, valueKz);
        }
        if (LocaleUtils.isLocaleKZ(locale)) {
            return LocaleUtils.notBlank(valueKz, valueRu);
        }
        throw new IllegalArgumentException("Invalid locale");
    }

    public static String notBlank(String preferable, String optional) {
        if (!StringUtils.isBlank(preferable)) {
            return preferable;
        }
        if (!StringUtils.isBlank(optional)) {
            return optional;
        }
        return "";
    }
}

