/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.model.DocumentType;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.vstore.model.doc.ERemainderType;
import ru.uss.vstore.model.doc.EUFormType;

public class RegistrationNumberUtils {
    public static final String ESF_REG_NUMBER_PREFIX = "ESF";
    public static final String SNT_REG_NUMBER_PREFIX = "KZ-SNT";
    public static final Pattern FNO_PATTERN = Pattern.compile("^[0-9]{12}[NI][0-9]{5}$");
    public static final Pattern DT_PATTERN = Pattern.compile("^[0-9]{5}/[0-9]{6}/[0-9]{7}$");
    public static final Pattern ZVT_PATTERN = Pattern.compile("^[0-9]{5}/[0-9]{6}/B[0-9]{6}$");
    public static final Pattern ESF_PATTERN = Pattern.compile("^ESF-[0-9]{12}-[0-9]{8}-[0-9]{8}$");
    public static final Pattern MANUFACTURE_PATTERN = Pattern.compile("^[0-9]{12}/\u041f/[0-9]{6}/[0-9]{8}$");
    public static final Pattern BALANCE_PATTERN = Pattern.compile("^[0-9]{12}/\u041e/[0-9]{6}/[0-9]{8}$");
    public static final Pattern BALANCE_CORRECTION_PATTERN = Pattern.compile("^[0-9]{12}/\u041e/[0-9]{6}/[0-9]{8}$");
    public static final Pattern MOVEMENT_PATTERN = Pattern.compile("^[0-9]{12}/\u0412\u041f/[0-9]{6}/[0-9]{8}$");
    public static final Pattern CONVERSION_PATTERN = Pattern.compile("^[0-9]{12}/\u0414/[0-9]{6}/[0-9]{8}$");
    public static final Pattern EDITING_PATTERN = Pattern.compile("^[0-9]{12}/\u0420/[0-9]{6}/[0-9]{8}$");
    public static final Pattern PACKING_PATTERN = Pattern.compile("^[0-9]{12}/\u0414/[0-9]{6}/[0-9]{8}$");
    public static final Pattern UNPACKING_PATTERN = Pattern.compile("^[0-9]{12}/\u0414/[0-9]{6}/[0-9]{8}$");
    public static final Pattern PHYSICAL_LABEL_PATTERN = Pattern.compile("^[0-9]{12}/\u0424\u041c/[0-9]{6}/[0-9]{8}$");
    public static final Pattern UFORM_PATTERN = Pattern.compile("^[0-9]{12}/(\u041e|\u041a\u041e|\u041f|\u0412\u041f|\u0414|\u0424\u041c|\u0421|\u0420|\u0414\u0418\u0422)/[0-9]{6}/[0-9]{8}$");
    public static final Pattern UFORM_BALANCE_PATTERN = Pattern.compile("^[0-9]{12}/(\u041e)/[0-9]{6}/[0-9]{8}$");
    public static final Pattern UFORM_RECEIPT_PATTERN = Pattern.compile("^[0-9]{12}/(\u041e|\u041f)/[0-9]{6}/[0-9]{8}$");
    public static final Pattern UFORM_DETAILING_PATTERN = Pattern.compile("^[0-9]{12}/(\u0414)/[0-9]{6}/[0-9]{8}$");
    public static final Pattern SNT_PATTERN = Pattern.compile("KZ-SNT-[0-9]{4}-[0-9]{12}-[0-9]{8}-[0-9]{8}");
    public static final Pattern PATTERN_FOR_CERT_11_LENGTH = Pattern.compile("^KZ[0-9]{9}$");
    public static final Pattern PATTERN_FOR_CERT_13_LENGTH = Pattern.compile("^KZ.{2}[0-9]{9}$");
    public static final Pattern EGP_AWP_PATTERN = Pattern.compile("^[0-9]{6}/[0-9]{2}/[0-9]{1,2}$");
    public static final Pattern UUID_PATTERN = Pattern.compile("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}");
    private static final String fnoDateFormat = "ddMMyyyy";
    private static final String dtDateFormat = "ddMMyy";
    private static final String zvtDateFormat = "ddMMyy";
    private static final String invoiceDateFormat = "yyyyMMdd";
    private static final String sntDateFormat = "yyyyMMdd";
    private static final Map<String, EUFormType> UFORM_TYPE_CODE_MAP = Arrays.stream(EUFormType.values()).collect(Collectors.toMap(EUFormType::getCode, Function.identity()));

    public static boolean isFno(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() == 18 && FNO_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isDt(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() == 20 && DT_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isZvt(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() == 20 && ZVT_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isUForm(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() >= 30 && registrationNumber.length() <= 32 && UFORM_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isBalanceUForm(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() >= 30 && registrationNumber.length() <= 32 && BALANCE_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isReceiptUForm(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() >= 30 && registrationNumber.length() <= 32 && UFORM_RECEIPT_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isManufactureUForm(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() >= 30 && registrationNumber.length() <= 32 && MANUFACTURE_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isBalanceCorrectionUForm(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() >= 30 && registrationNumber.length() <= 32 && BALANCE_CORRECTION_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isPackingUForm(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() >= 30 && registrationNumber.length() <= 32 && PACKING_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isUnpackingUForm(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() >= 30 && registrationNumber.length() <= 32 && UNPACKING_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isDetailingUForm(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() >= 30 && registrationNumber.length() <= 32 && UFORM_DETAILING_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isInvoice(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() == 34 && ESF_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isSnt(String registrationNumber) {
        return StringUtils.isNotEmpty(registrationNumber) && registrationNumber.length() == 42 && SNT_PATTERN.matcher(registrationNumber).find();
    }

    public static boolean isCertCt(String registrationNumber) {
        return !(!StringUtils.isNotEmpty(registrationNumber) || registrationNumber.length() != 11 && registrationNumber.length() != 13 || !PATTERN_FOR_CERT_11_LENGTH.matcher(registrationNumber).find() && !PATTERN_FOR_CERT_13_LENGTH.matcher(registrationNumber).find());
    }

    public static boolean isEgpAwp(String number) {
        return StringUtils.isNoneBlank(number) && EGP_AWP_PATTERN.matcher(number).find();
    }

    public static boolean isUUID(String uuidValue) {
        return StringUtils.isNoneEmpty(uuidValue) && UUID_PATTERN.matcher(uuidValue).find();
    }

    public static Date parseDate(String registrationNumber) {
        if (RegistrationNumberUtils.isFno(registrationNumber)) {
            return DateTimeUtils.getDate(registrationNumber.substring(4, 12), fnoDateFormat);
        }
        if (RegistrationNumberUtils.isDt(registrationNumber)) {
            return DateTimeUtils.getDate(registrationNumber.split("/")[1], "ddMMyy");
        }
        if (RegistrationNumberUtils.isInvoice(registrationNumber)) {
            return DateTimeUtils.getDate(registrationNumber.split("-")[2], "yyyyMMdd");
        }
        if (RegistrationNumberUtils.isUForm(registrationNumber)) {
            return DateTimeUtils.getDate(registrationNumber.split("/")[2], "ddMMyy");
        }
        if (RegistrationNumberUtils.isSnt(registrationNumber)) {
            return DateTimeUtils.getDate(registrationNumber.split("-")[4], "yyyyMMdd");
        }
        if (RegistrationNumberUtils.isZvt(registrationNumber)) {
            return DateTimeUtils.getDate(registrationNumber.split("/")[1], "ddMMyy");
        }
        return null;
    }

    public static EUFormType determineUFormType(String registrationNumber) {
        if (RegistrationNumberUtils.isUForm(registrationNumber)) {
            String[] splitResult = registrationNumber.split("/");
            String uformCode = splitResult[1];
            return UFORM_TYPE_CODE_MAP.get(uformCode);
        }
        return null;
    }

    public static DocumentType determinateDocumentType(String docNum) {
        if (RegistrationNumberUtils.isSnt(docNum)) {
            return DocumentType.SNT;
        }
        if (RegistrationNumberUtils.isInvoice(docNum)) {
            return DocumentType.INVOICE;
        }
        if (RegistrationNumberUtils.isUForm(docNum)) {
            return DocumentType.UFORM;
        }
        if (RegistrationNumberUtils.isDt(docNum)) {
            return DocumentType.DOCUMENT_GTD;
        }
        if (RegistrationNumberUtils.isFno(docNum)) {
            return DocumentType.DOCUMENT_FNO;
        }
        if (RegistrationNumberUtils.isCertCt(docNum)) {
            return DocumentType.CERTIFICATE_CT;
        }
        if (RegistrationNumberUtils.isZvt(docNum)) {
            return DocumentType.DOCUMENT_ZVT;
        }
        return null;
    }

    public static void main(String[] args) {
        String certNum = "KZ010500897";
        boolean certCt = RegistrationNumberUtils.isCertCt(certNum);
        System.out.println(certCt);
    }

    public static ERemainderType getDocumentType(String docNumber) {
        ERemainderType documentType = null;
        if (RegistrationNumberUtils.isDt(docNumber)) {
            documentType = ERemainderType.DOCUMENT_GTD;
        } else if (RegistrationNumberUtils.isFno(docNumber)) {
            documentType = ERemainderType.DOCUMENT_FNO;
        } else if (RegistrationNumberUtils.isZvt(docNumber)) {
            documentType = ERemainderType.DOCUMENT_ZVT;
        } else if (RegistrationNumberUtils.isSnt(docNumber)) {
            documentType = ERemainderType.PRIMARY_SNT;
        } else if (RegistrationNumberUtils.isCertCt(docNumber)) {
            documentType = ERemainderType.CERTIFICATE_CT;
        } else if (RegistrationNumberUtils.isDetailingUForm(docNumber)) {
            documentType = ERemainderType.DETAILING;
        } else if (RegistrationNumberUtils.isBalanceUForm(docNumber)) {
            documentType = ERemainderType.BALANCE;
        } else if (RegistrationNumberUtils.isBalanceCorrectionUForm(docNumber)) {
            documentType = ERemainderType.BALANCE_CORRECTION;
        } else if (RegistrationNumberUtils.isManufactureUForm(docNumber)) {
            documentType = ERemainderType.MANUFACTURE;
        } else if (RegistrationNumberUtils.isPackingUForm(docNumber)) {
            documentType = ERemainderType.PACKING;
        } else if (RegistrationNumberUtils.isUnpackingUForm(docNumber)) {
            documentType = ERemainderType.UNPACKING;
        }
        return documentType;
    }
}

