/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.exception.CertificateIsNotForSigningException;
import ru.uss.core.exception.CertificateSignatureException;
import ru.uss.core.exception.NucCertificateRevokedException;
import ru.ussgroup.security.trusty.TrustyCertValidationCode;
import ru.ussgroup.security.trusty.TrustyCertificateValidator;
import ru.ussgroup.security.trusty.TrustyKeyUsage;
import ru.ussgroup.security.trusty.TrustyKeyUsageChecker;
import ru.ussgroup.security.trusty.TrustySignatureVerifier;
import ru.ussgroup.security.trusty.TrustyUtils;
import ru.ussgroup.security.trusty.certpath.TrustyAsyncCertPathValidatorImpl;
import ru.ussgroup.security.trusty.certpath.TrustyCertPathValidator;
import ru.ussgroup.security.trusty.certpath.TrustyCertPathValidatorImpl;
import ru.ussgroup.security.trusty.exception.TrustyOCSPCertificateException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPNonceException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPNotAvailableException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPUnknownProblemException;
import ru.ussgroup.security.trusty.ocsp.TrustyCachedOCSPValidator;
import ru.ussgroup.security.trusty.ocsp.kalkan.KalkanOCSPValidator;
import ru.ussgroup.security.trusty.repository.TrustyKeyStoreRepository;
import ru.ussgroup.security.trusty.utils.SignedData;
import ru.ussgroup.security.trusty.utils.VerifiedData;

public class SignatureHelper {
    private static final Logger log = LoggerFactory.getLogger(SignatureHelper.class);
    private static SignatureHelper instance;
    private TrustySignatureVerifier signatureVerifier;
    private TrustyCertPathValidator certPathValidator;
    private TrustyCertificateValidator certificateValidator;

    protected SignatureHelper() {
    }

    public SignatureHelper(String keyStoreRepository, String nucIp, String nucUrl) {
        try {
            if (StringUtils.isEmpty(keyStoreRepository)) {
                keyStoreRepository = "/ca/kalkan_repository.jks";
            }
            TrustyKeyStoreRepository repository = new TrustyKeyStoreRepository(keyStoreRepository);
            this.certPathValidator = new TrustyCertPathValidatorImpl(repository);
            String NUC_IP = StringUtils.isNotEmpty(nucIp) ? nucIp : "195.12.113.112";
            String NUC_URL = StringUtils.isNotEmpty(nucUrl) ? nucUrl : "http://ocsp.pki.gov.kz/ocsp/";
            KalkanOCSPValidator kalkanOCSPValidator = new KalkanOCSPValidator(NUC_URL, NUC_IP, repository);
            TrustyCachedOCSPValidator cachedOCSPValidator = new TrustyCachedOCSPValidator(kalkanOCSPValidator, repository, 5, 60);
            this.certificateValidator = new TrustyCertificateValidator(new TrustyAsyncCertPathValidatorImpl(this.certPathValidator), cachedOCSPValidator);
            this.signatureVerifier = new TrustySignatureVerifier(this.certificateValidator);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticInstance(SignatureHelper instance) {
        SignatureHelper.instance = instance;
    }

    public static String sign(String data, X500PrivateCredential certificate) throws SignatureException {
        return TrustyUtils.sign(data, certificate);
    }

    public static List<VerifiedData> verify(List<SignedData> list, Date date) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException {
        return instance.verifyInner(list, date);
    }

    private List<VerifiedData> verifyInner(List<SignedData> list, Date date) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException {
        return this.signatureVerifier.verify(list, date);
    }

    public static VerifiedData verify(SignedData signedData, Date date) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException, CertPathValidatorException, SignatureException, CertificateExpiredException, CertificateNotYetValidException, CertificateSignatureException {
        return instance.verifyInner(signedData, date);
    }

    private VerifiedData verifyInner(SignedData signedData, Date date) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException, CertPathValidatorException, SignatureException, CertificateExpiredException, CertificateNotYetValidException, CertificateSignatureException {
        try {
            VerifiedData vd = this.signatureVerifier.verify(Arrays.asList(signedData), date).get(0);
            if (!(vd.isValid() || vd.getCertStatus() != null && vd.getCertStatus() != TrustyCertValidationCode.SUCCESS)) {
                return SignatureHelper.verifyWithCertificateAlgorithm(vd.getSignedData());
            }
            return vd;
        }
        catch (Exception e) {
            log.warn("invoice with id " + signedData.getId() + " signature verify exception : " + e.getMessage());
            return null;
        }
    }

    public static CompletableFuture<List<VerifiedData>> verifyAsync(List<SignedData> list) {
        return instance.verifyAsyncInner(list);
    }

    private CompletableFuture<List<VerifiedData>> verifyAsyncInner(List<SignedData> list) {
        return this.signatureVerifier.verifyAsync(list);
    }

    public static void verify(String data, String signature, X509Certificate cert) throws CertPathValidatorException, TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException, CertificateIsNotForSigningException, NucCertificateRevokedException, SignatureException, CertificateExpiredException, CertificateNotYetValidException, CertificateSignatureException {
        SignatureHelper.verify(data.getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(TrustyUtils.removeNewLines(signature)), cert);
    }

    public static void verify(byte[] data, byte[] signature, X509Certificate cert) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException, CertPathValidatorException, CertificateIsNotForSigningException, NucCertificateRevokedException, SignatureException, CertificateExpiredException, CertificateNotYetValidException, CertificateSignatureException {
        instance.verifyInner(data, signature, cert);
    }

    private void verifyInner(byte[] data, byte[] signature, X509Certificate cert) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException, CertPathValidatorException, CertificateIsNotForSigningException, NucCertificateRevokedException, SignatureException, CertificateExpiredException, CertificateNotYetValidException, CertificateSignatureException {
        VerifiedData verifiedData = this.signatureVerifier.verify(Collections.singletonList(new SignedData(data, signature, cert)), new Date()).get(0);
        if (!verifiedData.isValid()) {
            TrustyCertValidationCode result = verifiedData.getCertStatus();
            if (result == TrustyCertValidationCode.CERT_PATH_FAILED) {
                throw new CertPathValidatorException();
            }
            if (result == TrustyCertValidationCode.OCSP_FAILED) {
                throw new NucCertificateRevokedException();
            }
            if (result == TrustyCertValidationCode.NOT_FOR_SIGNING) {
                throw new CertificateIsNotForSigningException();
            }
            if (result == TrustyCertValidationCode.CERT_EXPIRED) {
                throw new CertificateExpiredException("message_certificate_expired");
            }
            if (result == TrustyCertValidationCode.CERT_NOT_YET_VALID) {
                throw new CertificateNotYetValidException();
            }
            if (result == TrustyCertValidationCode.CERT_SIGNATURE_EXCEPTION) {
                throw new CertificateSignatureException();
            }
            if (!SignatureHelper.verifyWithCertificateAlgorithm(verifiedData.getSignedData()).isValid()) {
                throw new SignatureException("message_signature_not_valid");
            }
        }
    }

    public static VerifiedData verifyWithCertificateAlgorithm(SignedData sd) {
        VerifiedData vd = new VerifiedData(sd);
        try {
            Signature s = Signature.getInstance(sd.getCert().getSigAlgName(), "KALKAN");
            s.initVerify(sd.getCert().getPublicKey());
            s.update(sd.getData());
            if (!TrustyKeyUsageChecker.getKeyUsage(sd.getCert()).contains((Object)TrustyKeyUsage.SIGNING)) {
                vd.setCertStatus(TrustyCertValidationCode.NOT_FOR_SIGNING);
                throw new CertificateException();
            }
            if (!s.verify(sd.getSignature())) {
                Signature s2 = Signature.getInstance(sd.getCert().getPublicKey().getAlgorithm(), "KALKAN");
                s2.initVerify(sd.getCert().getPublicKey());
                s2.update(sd.getData());
                if (!s2.verify(SignatureHelper.inverseCopyByte(sd.getSignature(), 0, sd.getSignature().length))) {
                    throw new SignatureException();
                }
            }
        }
        catch (Exception e) {
            vd.setValid(false);
        }
        return vd;
    }

    public static void checkCertPath(X509Certificate cert) throws CertificateNotYetValidException, CertificateExpiredException, SignatureException, CertPathValidatorException {
        instance.checkCertPathInner(cert);
    }

    private void checkCertPathInner(X509Certificate cert) throws CertificateNotYetValidException, CertificateExpiredException, SignatureException, CertPathValidatorException {
        this.certPathValidator.validate(cert);
    }

    public static void checkCertificate(X509Certificate cert) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException, CertPathValidatorException, NucCertificateRevokedException, CertificateExpiredException, CertificateNotYetValidException, CertificateSignatureException {
        instance.checkCertificateInner(cert);
    }

    private void checkCertificateInner(X509Certificate cert) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException, CertPathValidatorException, NucCertificateRevokedException, CertificateExpiredException, CertificateNotYetValidException, CertificateSignatureException {
        TrustyCertValidationCode result = this.certificateValidator.validate(Collections.singleton(cert)).values().iterator().next();
        switch (result) {
            case OCSP_FAILED: {
                throw new NucCertificateRevokedException();
            }
            case CERT_PATH_FAILED: {
                throw new CertPathValidatorException();
            }
            case CERT_NOT_YET_VALID: {
                throw new CertificateNotYetValidException();
            }
            case CERT_EXPIRED: {
                throw new CertificateExpiredException();
            }
            case CERT_SIGNATURE_EXCEPTION: {
                throw new CertificateSignatureException();
            }
            case NOT_FOR_SIGNING: {
                break;
            }
        }
    }

    public static X509Certificate loadFromStringWithoutException(String certificate) {
        try {
            return TrustyUtils.loadFromString(certificate);
        }
        catch (CertificateParsingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getCertificateSerialNumber(String certificate) {
        if (certificate == null) {
            return null;
        }
        return SignatureHelper.loadFromStringWithoutException(certificate).getSerialNumber().toString();
    }

    public static CompletableFuture<Map<BigInteger, TrustyCertValidationCode>> validateCertsAsync(Set<X509Certificate> certs) {
        return instance.validateCertsAsyncInner(certs);
    }

    private CompletableFuture<Map<BigInteger, TrustyCertValidationCode>> validateCertsAsyncInner(Set<X509Certificate> certs) {
        return this.certificateValidator.validateAsync(certs, new Date());
    }

    public static void main(String[] args) throws TrustyOCSPNotAvailableException, CertificateIsNotForSigningException, CertPathValidatorException, TrustyOCSPUnknownProblemException, CertificateNotYetValidException, TrustyOCSPNonceException, TrustyOCSPCertificateException, CertificateExpiredException, NucCertificateRevokedException, SignatureException, CertificateSignatureException, IOException {
        instance = new SignatureHelper("/ca_test/kalkan_repository.jks", "195.12.113.38", "http://test.pki.gov.kz/ocsp/");
        X509Certificate x509Certificate = SignatureHelper.loadFromStringWithoutException("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");
        String signature = "4Ugm6h5sOg4u0n381P5tI+PrTBNbQy58rX3FpzeuBxOgrgjG+dnUW/U0cttVts5\nnvRa5/4Gx/Hsm2sIa2qqfMR8NUDHNjLJEwmnPp4zfGZ580jv/fRENsbLRZ4aN54t\n/vBgv1JCn68CqKBQ8iJ5qfECuLBqemvSdMKoKz00NOjEkEBdyOFXa/qShYmYzMuY\neTsZxjXriyJAUGcr1SxXEMo1ivzTUrI/f5PMNrqtkI8h8AZ0aRbO60pQ1pZo6dvI\nyDQRcf0vZj0IXhQ5dECIkBzdIeCFYGrJi5xcZutSuMgMx4UToPrlzvyP1+/7CIZu\nRA6GgJq6vrSJsu56PWXKgIw==";
        String data = "<v2:invoice xmlns:v2=\"v2.esf\"><date>08.11.2022</date><invoiceType>ORDINARY_INVOICE</invoiceType><num>221800011125</num><operatorFullname>Test</operatorFullname><turnoverDate>31.07.2022</turnoverDate><consignee><countryCode>KZ</countryCode></consignee><customers><customer><address>0, &#x433;.&#x421;&#x435;&#x43C;&#x435;&#x439;, &#x43F;&#x440;&#x441;. &#x428;&#x410;&#x41A;&#x415;&#x420;&#x418;&#x41C;&#x410;, &#x434;&#x43E;&#x43C; 20</address><countryCode>KZ</countryCode><name>&#x410;&#x421;&#x415;&#x41C;-&#x421;&#x410;&#x41B;&#x41E;&#x41D; &#x41A;&#x420;&#x410;&#x421;&#x41E;&#x422;&#x42B;</name><tin>001040012362</tin></customer></customers><deliveryTerm><contractDate>14.03.2002</contractDate><contractNum>3250/2022</contractNum><hasContract>true</hasContract><term>&#x431;&#x435;&#x437;&#x43D;&#x430;&#x43B;&#x438;&#x447;&#x43D;&#x44B;&#x439;</term><transportTypeCode>99</transportTypeCode></deliveryTerm><productSet><currencyCode>KZT</currencyCode><products><product><catalogTruId>1</catalogTruId><description>&#x410;&#x431;&#x43E;&#x43D;&#x43F;&#x43B;&#x430;&#x442;&#x430; &#x437;&#x430; &#x442;&#x435;&#x43B;&#x435;&#x444;&#x43E;&#x43D;</description><ndsAmount>114.05</ndsAmount><ndsRate>12</ndsRate><priceWithTax>1064.48</priceWithTax><priceWithoutTax>950.43</priceWithoutTax><truOriginCode>6</truOriginCode><turnoverSize>950.43</turnoverSize></product></products><totalExciseAmount>0</totalExciseAmount><totalNdsAmount>114.05</totalNdsAmount><totalPriceWithTax>1064.48</totalPriceWithTax><totalPriceWithoutTax>950.43</totalPriceWithoutTax><totalTurnoverSize>950.43</totalTurnoverSize></productSet><sellers><seller><address>&#x420;&#x435;&#x441;&#x43F;&#x443;&#x431;&#x43B;&#x438;&#x43A;&#x430; &#x41A;&#x430;&#x437;&#x430;&#x445;&#x441;&#x442;&#x430;&#x43D;, &#x410;&#x43A;&#x43C;&#x43E;&#x43B;&#x438;&#x43D;&#x441;&#x43A;&#x430;&#x44F; &#x43E;&#x431;&#x43B;., &#x433;. &#x41D;&#x443;&#x440;-&#x421;&#x443;&#x43B;&#x442;&#x430;&#x43D;,</address><bank>&#x410;&#x41E; &#x22;&#x41D;&#x430;&#x440;&#x43E;&#x434;&#x43D;&#x44B;&#x439; &#x431;&#x430;&#x43D;&#x43A; &#x41A;&#x430;&#x437;&#x430;&#x445;&#x441;&#x442;&#x430;&#x43D;&#x430;&#x22;</bank><bik>HSBKKZKX</bik><certificateNum>1450120</certificateNum><certificateSeries>97100</certificateSeries><iik>KZ446017131000000356</iik><kbe>16</kbe><name>&#x410;&#x43A;&#x446;&#x438;&#x43E;&#x43D;&#x435;&#x440;&#x43D;&#x43E;&#x435; &#x43E;&#x431;&#x449;&#x435;&#x441;&#x442;&#x432;&#x43E; &#x22;&#x41A;&#x430;&#x437;&#x430;&#x445;&#x442;&#x435;&#x43B;&#x435;&#x43A;&#x43E;&#x43C;&#x22;</name><tin>971001450120</tin></seller></sellers></v2:invoice>";
        VerifiedData verify = SignatureHelper.verify(new SignedData(data, "4Ugm6h5sOg4u0n381P5tI+PrTBNbQy58rX3FpzeuBxOgrgjG+dnUW/U0cttVts5\nnvRa5/4Gx/Hsm2sIa2qqfMR8NUDHNjLJEwmnPp4zfGZ580jv/fRENsbLRZ4aN54t\n/vBgv1JCn68CqKBQ8iJ5qfECuLBqemvSdMKoKz00NOjEkEBdyOFXa/qShYmYzMuY\neTsZxjXriyJAUGcr1SxXEMo1ivzTUrI/f5PMNrqtkI8h8AZ0aRbO60pQ1pZo6dvI\nyDQRcf0vZj0IXhQ5dECIkBzdIeCFYGrJi5xcZutSuMgMx4UToPrlzvyP1+/7CIZu\nRA6GgJq6vrSJsu56PWXKgIw==", x509Certificate), new Date());
        System.out.println("Valid: " + verify.isValid());
        System.out.println("Status: " + (Object)((Object)verify.getCertStatus()));
    }

    private static byte[] inverseCopyByte(byte[] paramArrayOfByte, int paramInt1, int paramInt2) {
        byte[] arrayOfByte = new byte[paramInt2];
        for (int i = 0; i < paramInt2; ++i) {
            arrayOfByte[paramInt2 - i - 1] = paramArrayOfByte[paramInt1 + i];
        }
        return arrayOfByte;
    }
}

