/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import java.util.Date;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.time.DateUtils;
import ru.uss.core.validation.common.AbstractFieldLevelValidator;
import ru.uss.core.validation.common.CurrentDate;

public class CurrentDateValidator
extends AbstractFieldLevelValidator<CurrentDate, Date> {
    private String fieldPath;

    @Override
    public void initialize(CurrentDate constraint) {
        this.fieldPath = constraint.fieldPath();
    }

    @Override
    public boolean isValid(Date value, ConstraintValidatorContext context) {
        if (value != null && !DateUtils.isSameDay(value, new Date())) {
            return this.setupContextWithValidationError(context, this.generateDateNotTodayFieldMessage(this.fieldPath));
        }
        return true;
    }

    private String generateDateNotTodayFieldMessage(String fieldPath) {
        return "\u041f\u043e\u043b\u0435 '{" + fieldPath + "}' {isNotToday}";
    }
}

