/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.NotAllowedValues;

public class NotAllowedValuesValidator
implements ConstraintValidator<NotAllowedValues, String> {
    private String[] disabledValues;

    @Override
    public void initialize(NotAllowedValues constraintAnnotation) {
        this.disabledValues = constraintAnnotation.values();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (this.disabledValues == null || this.disabledValues.length == 0) {
            return true;
        }
        if (value == null) {
            return true;
        }
        for (String disabledValue : this.disabledValues) {
            if (!disabledValue.equals(value)) continue;
            return false;
        }
        return true;
    }
}

