/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractFieldLevelValidator;
import ru.uss.core.validation.common.NumberCheck;

public class NumberCheckValidator
extends AbstractFieldLevelValidator<NumberCheck, Number> {
    private String fieldPath;
    private Boolean nullable;
    private Integer minDigitCount;
    private Integer maxDigitCount;

    @Override
    public void initialize(NumberCheck constraintAnnotation) {
        this.fieldPath = constraintAnnotation.fieldPath();
        this.nullable = constraintAnnotation.nullable();
        this.minDigitCount = constraintAnnotation.minDigitCount();
        this.maxDigitCount = constraintAnnotation.maxDigitCount();
    }

    @Override
    public boolean isValid(Number value, ConstraintValidatorContext context) {
        if (value == null) {
            if (!this.nullable.booleanValue()) {
                return this.setupContextWithValidationError(context, this.generateNotNullFieldMessage(this.fieldPath));
            }
        } else {
            int numberLength = value.toString().length();
            if (numberLength < this.minDigitCount || numberLength > this.maxDigitCount) {
                return this.setupContextWithValidationError(context, "\u041f\u043e\u043b\u0435 '{" + this.fieldPath + "}' {numberConstraint}");
            }
        }
        return true;
    }
}

