/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.validation.common.AbstractFieldLevelValidator;
import ru.uss.core.validation.common.PastDate;

public class PastDateValidator
extends AbstractFieldLevelValidator<PastDate, Date> {
    private static SimpleDateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private int calendarUnitType;
    private int calendarUnitAmount;
    private String fieldPath;

    @Override
    public void initialize(PastDate annotation) {
        this.calendarUnitType = annotation.calendarUnitType();
        this.calendarUnitAmount = annotation.calendarUnitAmount();
        this.fieldPath = annotation.fieldPath();
    }

    @Override
    public boolean isValid(Date value, ConstraintValidatorContext context) {
        Date endOfTodayDate = DateTimeUtils.endOfTheDay(new Date());
        if (this.calendarUnitType != -1 && this.calendarUnitAmount != -1) {
            Calendar minDateCalendar = GregorianCalendar.getInstance();
            minDateCalendar.add(this.calendarUnitType, -this.calendarUnitAmount);
            Date minDate = DateTimeUtils.startOfTheDay(minDateCalendar.getTime());
            if (value != null && (value.before(minDate) || value.after(endOfTodayDate))) {
                return this.setupContextWithValidationError(context, "{" + this.fieldPath + "} {dateIntervalStart} " + SHORT_DATE_FORMAT.format(minDate) + " {dateIntervalEnd} " + SHORT_DATE_FORMAT.format(endOfTodayDate));
            }
        } else if (value != null && value.after(endOfTodayDate)) {
            return this.setupContextWithValidationError(context, "{" + this.fieldPath + "} {dateIntervalOnlyPast}");
        }
        return true;
    }
}

