/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.api1;

import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500PrivateCredential;
import ru.uss.core.model.SignatureAware;
import ru.uss.esf.api1.exception.AccessDeniedException;
import ru.uss.esf.core.utils.InvoiceSignatureHelper;
import ru.uss.esf.model.SignableDataContainer;
import ru.ussgroup.security.trusty.TrustyUtils;

public interface SignedRequest<T>
extends SignatureAware,
SignableDataContainer<T> {
    public String getX509Certificate();

    public void setX509Certificate(String var1);

    default public void sign(X500PrivateCredential x500PrivateCredential) throws AccessDeniedException {
        try {
            X509Certificate certificate = x500PrivateCredential.getCertificate();
            this.setX509Certificate(TrustyUtils.toBase64(certificate));
            String data = InvoiceSignatureHelper.toXML(this.getSignableData());
            String signature = TrustyUtils.sign(data, x500PrivateCredential);
            this.setSignature(signature);
        }
        catch (Exception e) {
            throw new AccessDeniedException("Wrong certificate", e);
        }
    }
}

