/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.client.impl;

import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import ru.uss.core.api.session.CloseSessionRequest;
import ru.uss.core.api.session.CreateSessionRequest;
import ru.uss.core.api.session.CreateSessionResponse;
import ru.uss.core.api.session.CurrentSessionStatusRequest;
import ru.uss.core.api.session.CurrentSessionStatusResponse;
import ru.uss.core.api.session.CurrentUserProfilesRequest;
import ru.uss.core.api.session.CurrentUserProfilesResponse;
import ru.uss.core.api.session.CurrentUserRequest;
import ru.uss.core.api.session.CurrentUserResponse;
import ru.uss.core.model.SourceType;
import ru.uss.esf.api1.AbstractSessionAwareRequest;
import ru.uss.esf.api1.SignedRequest;
import ru.uss.esf.api1.exception.AccessDeniedException;
import ru.uss.esf.api1.exception.BusinessException;
import ru.uss.esf.api1.exception.SessionClosedException;
import ru.uss.esf.api1.invoice.DeleteInvoiceByIdRequest;
import ru.uss.esf.api1.invoice.EnterpriseKey;
import ru.uss.esf.api1.invoice.EnterpriseValidationRequest;
import ru.uss.esf.api1.invoice.EnterpriseValidationResponse;
import ru.uss.esf.api1.invoice.InvoiceByIdRequest;
import ru.uss.esf.api1.invoice.InvoiceByIdWithReasonRequest;
import ru.uss.esf.api1.invoice.InvoiceByKeyRequest;
import ru.uss.esf.api1.invoice.InvoiceErrorByIdRequest;
import ru.uss.esf.api1.invoice.InvoiceErrorByIdResponse;
import ru.uss.esf.api1.invoice.InvoiceIdWithReason;
import ru.uss.esf.api1.invoice.InvoiceServiceAPI1;
import ru.uss.esf.api1.invoice.QueryInvoiceRequest;
import ru.uss.esf.api1.invoice.QueryInvoiceResponse;
import ru.uss.esf.api1.invoice.QueryInvoiceUpdateRequest;
import ru.uss.esf.api1.invoice.QueryInvoiceUpdateResponse;
import ru.uss.esf.api1.session.SessionServiceAPI1;
import ru.uss.esf.api1.upload.SyncInvoiceRequest;
import ru.uss.esf.api1.upload.SyncInvoiceResponse;
import ru.uss.esf.api1.upload.UploadInvoiceServiceAPI1;
import ru.uss.esf.client.ClientAPI1;
import ru.uss.esf.core.utils.InvoiceSignatureHelper;
import ru.uss.esf.model.ChangeStatusResult;
import ru.uss.esf.model.DeleteResult;
import ru.uss.esf.model.dictionary.Taxpayer;
import ru.uss.esf.model.invoice.InvoiceDirection;
import ru.uss.esf.model.invoice.InvoiceInfo;
import ru.uss.esf.model.invoice.InvoiceKey;
import ru.uss.esf.model.invoice.InvoiceStatus;
import ru.uss.esf.model.invoice.InvoiceSummary;
import ru.uss.esf.model.invoice.InvoiceUploadInfo;
import ru.uss.esf.model.usermng.BusinessProfileType;
import ru.uss.esf.model.usermng.ProfileInfo;
import ru.uss.esf.model.usermng.SessionStatus;
import ru.uss.esf.model.usermng.User;
import ru.ussgroup.security.trusty.TrustyUtils;

public class SessionClientAPI1
implements ClientAPI1,
Serializable {
    private static final String ERROR_CERTIFICATE_NOT_SPECIFIED = "X509 certificate does not attached to request.";
    private static final String ERROR_SIGNATURE_NOT_SPECIFIED = "Signature does not specified for request.";
    private final Supplier<InvoiceServiceAPI1> invoiceService;
    private final Supplier<UploadInvoiceServiceAPI1> uploadService;
    private final Supplier<SessionServiceAPI1> sessionService;
    private final String authCertificateAsBase64String;
    private volatile String sessionId;
    private final SourceType sourceType;
    private boolean isAuthWithCert = true;
    private boolean isQrAuthSign = false;
    private boolean isTicketSigned = false;

    public SessionClientAPI1(Supplier<InvoiceServiceAPI1> invoiceService, Supplier<UploadInvoiceServiceAPI1> uploadService, Supplier<SessionServiceAPI1> sessionService, X509Certificate authCertificate, SourceType sourceType, String tin, BusinessProfileType profileType, Long projectCode, boolean isAuthWithCert, boolean isQrAuthSign) throws Exception {
        this(invoiceService, uploadService, sessionService, SessionClientAPI1.toBase64(authCertificate), sourceType, tin, profileType, projectCode, isAuthWithCert, isQrAuthSign);
    }

    public SessionClientAPI1(Supplier<InvoiceServiceAPI1> invoiceService, Supplier<UploadInvoiceServiceAPI1> uploadService, Supplier<SessionServiceAPI1> sessionService, X509Certificate authCertificate, SourceType sourceType, String tin, BusinessProfileType profileType, Long projectCode, boolean isAuthWithCert, boolean isQrAuthSign, boolean isTicketSigned) throws Exception {
        this(invoiceService, uploadService, sessionService, SessionClientAPI1.toBase64(authCertificate), sourceType, tin, profileType, projectCode, isAuthWithCert, isQrAuthSign, isTicketSigned);
    }

    public SessionClientAPI1(Supplier<InvoiceServiceAPI1> invoiceService, Supplier<UploadInvoiceServiceAPI1> uploadService, Supplier<SessionServiceAPI1> sessionService, String authCertificate, SourceType sourceType, String tin, BusinessProfileType profileType, Long projectCode, boolean isAuthWithCert, boolean isQrAuthSign) throws Exception {
        this(invoiceService, uploadService, sessionService, authCertificate, sourceType, tin, profileType, projectCode, isAuthWithCert, isQrAuthSign, false);
    }

    public SessionClientAPI1(Supplier<InvoiceServiceAPI1> invoiceService, Supplier<UploadInvoiceServiceAPI1> uploadService, Supplier<SessionServiceAPI1> sessionService, String authCertificate, SourceType sourceType, String tin, BusinessProfileType profileType, Long projectCode, boolean isAuthWithCert, boolean isQrAuthSign, boolean isTicketSigned) throws Exception {
        invoiceService.get();
        this.invoiceService = invoiceService;
        uploadService.get();
        this.uploadService = uploadService;
        this.sessionService = sessionService;
        this.authCertificateAsBase64String = authCertificate;
        this.sourceType = sourceType;
        this.isAuthWithCert = isAuthWithCert;
        this.isQrAuthSign = isQrAuthSign;
        this.isTicketSigned = isTicketSigned;
        this.createSession(tin, profileType, projectCode, sourceType, isAuthWithCert, isQrAuthSign, this.isTicketSigned);
    }

    public SessionClientAPI1(Supplier<InvoiceServiceAPI1> invoiceService, Supplier<UploadInvoiceServiceAPI1> uploadService, Supplier<SessionServiceAPI1> sessionService, String authCertificate, SourceType sourceType, String sessionId) {
        this.invoiceService = invoiceService;
        uploadService.get();
        this.uploadService = uploadService;
        this.sessionService = sessionService;
        this.authCertificateAsBase64String = authCertificate;
        this.sourceType = sourceType;
        this.sessionId = sessionId;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public SessionStatus currentSessionStatus() {
        CurrentSessionStatusRequest request = new CurrentSessionStatusRequest(this.sessionId);
        CurrentSessionStatusResponse response = this.getSessionService().currentSessionStatus(request);
        return response.getStatus();
    }

    @Override
    public User currentUser() throws SessionClosedException {
        CurrentUserRequest request = new CurrentUserRequest(this.sessionId);
        CurrentUserResponse response = this.getSessionService().currentUser(request);
        return response.getUser();
    }

    @Override
    public List<ProfileInfo> currentUserProfiles() throws SessionClosedException {
        CurrentUserProfilesRequest request = new CurrentUserProfilesRequest(this.sessionId);
        CurrentUserProfilesResponse response = this.getSessionService().currentUserProfiles(request);
        return response.getProfileInfoList();
    }

    @Override
    public void closeSession() {
        CloseSessionRequest request = new CloseSessionRequest(this.sessionId);
        this.getSessionService().closeSession(request);
    }

    public void changeSession(String tin, BusinessProfileType profileType, Long projectCode) throws Exception {
        this.closeSession();
        this.createSession(tin, profileType, projectCode, this.sourceType, this.isAuthWithCert, this.isQrAuthSign, this.isTicketSigned);
    }

    @Override
    public SyncInvoiceResponse create(X500PrivateCredential x500PrivateCredential, InvoiceInfo ... invoiceInfos) throws AccessDeniedException, BusinessException {
        SyncInvoiceRequest request;
        if (invoiceInfos == null) {
            throw new IllegalArgumentException("InvoiceInfos must not be null");
        }
        try {
            for (InvoiceInfo invoiceInfo : invoiceInfos) {
                Object invoice = invoiceInfo.getInvoice();
                invoiceInfo.setInvoiceBody(InvoiceSignatureHelper.extractSignatureData(invoice));
                invoiceInfo.setSignature(InvoiceSignatureHelper.sign(invoice, x500PrivateCredential));
            }
            request = new SyncInvoiceRequest(InvoiceUploadInfo.fromInvoiceInfoList(Arrays.asList(invoiceInfos)), SessionClientAPI1.toBase64(x500PrivateCredential.getCertificate()));
        }
        catch (Exception e) {
            throw new AccessDeniedException("Wrong certificate", e);
        }
        return this.upload(request);
    }

    @Override
    public SyncInvoiceResponse createSigned(SyncInvoiceRequest request) throws AccessDeniedException, BusinessException {
        if (request.getX509Certificate() != null) {
            for (InvoiceUploadInfo invoiceInfo : request.getInvoiceUploadInfoList()) {
                if (invoiceInfo.getSignature() != null && invoiceInfo.getSignature().length() != 0) continue;
                throw new IllegalArgumentException("Signature was not attached for the invoice with num=" + invoiceInfo.getInvoice().getNum());
            }
            return this.upload(request);
        }
        throw new IllegalArgumentException("X509 certificate does not specified for request.");
    }

    private SyncInvoiceResponse upload(SyncInvoiceRequest request) throws AccessDeniedException, BusinessException {
        return this.doWithSession(request, () -> this.getUploadService().syncInvoice(request));
    }

    @Override
    public List<ChangeStatusResult> decline(Map<Long, String> idsWithReasons, X500PrivateCredential x500PrivateCredential) throws AccessDeniedException, BusinessException {
        InvoiceByIdWithReasonRequest request = new InvoiceByIdWithReasonRequest();
        request.setIdWithReasonList(this.createIdsWithReasons(idsWithReasons));
        request.sign(x500PrivateCredential);
        return this.decline(request);
    }

    @Override
    public List<ChangeStatusResult> declineSigned(InvoiceByIdWithReasonRequest request) throws AccessDeniedException, BusinessException {
        this.checkSignatureAndCertificatePresence(request);
        return this.decline(request);
    }

    private List<ChangeStatusResult> decline(InvoiceByIdWithReasonRequest request) throws AccessDeniedException, BusinessException {
        return this.doWithSession(request, () -> this.getInvoiceService().declineInvoiceById(request).getResultList());
    }

    @Override
    public List<ChangeStatusResult> revoke(Map<Long, String> idsWithReasons, X500PrivateCredential x500PrivateCredential) throws AccessDeniedException, BusinessException {
        InvoiceByIdWithReasonRequest request = new InvoiceByIdWithReasonRequest();
        request.setIdWithReasonList(this.createIdsWithReasons(idsWithReasons));
        request.sign(x500PrivateCredential);
        return this.revoke(request);
    }

    @Override
    public List<ChangeStatusResult> revokeSigned(InvoiceByIdWithReasonRequest request) throws AccessDeniedException, BusinessException {
        this.checkSignatureAndCertificatePresence(request);
        return this.revoke(request);
    }

    private List<ChangeStatusResult> revoke(InvoiceByIdWithReasonRequest request) throws AccessDeniedException, BusinessException {
        return this.doWithSession(request, () -> this.getInvoiceService().revokeInvoiceById(request).getResultList());
    }

    @Override
    public List<ChangeStatusResult> unrevoke(Map<Long, String> idsWithReasons, X500PrivateCredential x500PrivateCredential) throws AccessDeniedException, BusinessException {
        InvoiceByIdWithReasonRequest request = new InvoiceByIdWithReasonRequest();
        request.setIdWithReasonList(this.createIdsWithReasons(idsWithReasons));
        request.sign(x500PrivateCredential);
        return this.unrevoke(request);
    }

    @Override
    public List<ChangeStatusResult> unrevokeSigned(InvoiceByIdWithReasonRequest request) throws AccessDeniedException, BusinessException {
        this.checkSignatureAndCertificatePresence(request);
        return this.unrevoke(request);
    }

    private List<ChangeStatusResult> unrevoke(InvoiceByIdWithReasonRequest request) throws AccessDeniedException, BusinessException {
        return this.doWithSession(request, () -> this.getInvoiceService().unrevokeInvoiceById(request).getResultList());
    }

    @Override
    public List<InvoiceSummary> confirm(List<Long> invoiceIds) throws AccessDeniedException, BusinessException {
        InvoiceByIdRequest request = new InvoiceByIdRequest();
        request.setIdList(invoiceIds);
        return this.confirm(request);
    }

    private List<InvoiceSummary> confirm(InvoiceByIdRequest request) throws AccessDeniedException, BusinessException {
        return this.doWithSession(request, () -> this.getInvoiceService().confirmInvoiceById(request).getInvoiceSummaryList());
    }

    @Override
    public List<DeleteResult> deleteFailed(List<Long> invoiceIds, X500PrivateCredential x500PrivateCredential) throws AccessDeniedException, BusinessException {
        DeleteInvoiceByIdRequest request = new DeleteInvoiceByIdRequest();
        request.setIdList(invoiceIds);
        request.sign(x500PrivateCredential);
        return this.deleteFailedSigned(request);
    }

    @Override
    public List<DeleteResult> deleteFailedSigned(DeleteInvoiceByIdRequest request) throws AccessDeniedException, BusinessException {
        this.checkSignatureAndCertificatePresence(request);
        return this.deleteFailed(request);
    }

    private List<DeleteResult> deleteFailed(DeleteInvoiceByIdRequest request) throws AccessDeniedException, BusinessException {
        return this.doWithSession(request, () -> this.getInvoiceService().deleteInvoiceById(request).getResultList());
    }

    @Override
    public QueryInvoiceResponse findInvoices(InvoiceDirection direction, String contragentTinPattern, Date dateFrom, Date dateTo, List<InvoiceStatus> statuses, int pageNum) throws AccessDeniedException, BusinessException {
        QueryInvoiceRequest request = new QueryInvoiceRequest();
        QueryInvoiceRequest.Criteria criteria = new QueryInvoiceRequest.Criteria();
        criteria.setDirection(direction);
        criteria.setContragentTin(contragentTinPattern);
        criteria.setDateFrom(dateFrom);
        criteria.setDateTo(dateTo);
        criteria.setInvoiceStatusList(statuses);
        criteria.setPageNum(pageNum);
        request.setCriteria(criteria);
        return this.doWithSession(request, () -> this.getInvoiceService().queryInvoice(request));
    }

    @Override
    public QueryInvoiceResponse findInvoices(List<Long> invoiceIds) throws AccessDeniedException, BusinessException {
        InvoiceByIdRequest request = new InvoiceByIdRequest();
        request.setIdList(invoiceIds);
        return this.doWithSession(request, () -> this.getInvoiceService().queryInvoiceById(request));
    }

    @Override
    public QueryInvoiceResponse findInvoicesByKeys(List<InvoiceKey> keys, InvoiceDirection direction) throws AccessDeniedException, BusinessException {
        InvoiceByKeyRequest request = new InvoiceByKeyRequest();
        request.setInvoiceKeyList(keys);
        request.setDirection(direction);
        return this.doWithSession(request, () -> this.getInvoiceService().queryInvoiceByKey(request));
    }

    @Override
    public InvoiceErrorByIdResponse findInvoiceErrors(List<Long> invoiceIds) throws AccessDeniedException, BusinessException {
        InvoiceErrorByIdRequest request = new InvoiceErrorByIdRequest();
        request.setIdList(invoiceIds);
        return this.doWithSession(request, () -> this.getInvoiceService().queryInvoiceErrorById(request));
    }

    @Override
    public List<InvoiceSummary> getInvoicesSummary(List<Long> invoiceIds) throws AccessDeniedException, BusinessException {
        InvoiceByIdRequest request = new InvoiceByIdRequest();
        request.setIdList(invoiceIds);
        return this.doWithSession(request, () -> this.getInvoiceService().queryInvoiceSummaryById(request).getInvoiceSummaryList());
    }

    @Override
    public QueryInvoiceUpdateResponse getUpdates(Date lastEventDate, InvoiceDirection direction, Integer limit, boolean fullInfoOnStatusChange) throws AccessDeniedException, BusinessException {
        return this.getUpdates(lastEventDate, 0L, direction, limit, fullInfoOnStatusChange);
    }

    @Override
    public QueryInvoiceUpdateResponse getUpdates(Date lastEventDate, long lastInvoiceId, InvoiceDirection direction, Integer limit, boolean fullInfoOnStatusChange) throws AccessDeniedException, BusinessException {
        QueryInvoiceUpdateRequest request = new QueryInvoiceUpdateRequest();
        request.setLastEventDate(lastEventDate);
        request.setLastInvoiceId(lastInvoiceId);
        request.setDirection(direction);
        request.setLimit(limit);
        request.setFullInfoOnStatusChange(fullInfoOnStatusChange);
        return this.doWithSession(request, () -> this.getInvoiceService().queryUpdates(request));
    }

    @Override
    public EnterpriseValidationResponse enterpriseValidation(List<Taxpayer> taxpayers) throws AccessDeniedException, BusinessException {
        EnterpriseValidationRequest request = new EnterpriseValidationRequest();
        ArrayList<EnterpriseKey> enterpriseKeys = new ArrayList<EnterpriseKey>();
        for (Taxpayer taxpayer : taxpayers) {
            enterpriseKeys.add(new EnterpriseKey(taxpayer.getTin(), taxpayer.getCertificateSeries(), taxpayer.getCertificateNum()));
        }
        request.setEnterpriseKeyList(enterpriseKeys);
        return this.doWithSession(request, () -> this.getInvoiceService().enterpriseValidation(request));
    }

    private InvoiceServiceAPI1 getInvoiceService() {
        return this.invoiceService.get();
    }

    private SessionServiceAPI1 getSessionService() {
        return this.sessionService.get();
    }

    private UploadInvoiceServiceAPI1 getUploadService() {
        return this.uploadService.get();
    }

    @Override
    public <T> T doWithSession(AbstractSessionAwareRequest request, Callable<T> callable) throws AccessDeniedException, BusinessException {
        try {
            Assert.notNull((Object)this.sessionId, "SessionID must not be null");
            request.setSessionId(this.sessionId);
            return callable.call();
        }
        catch (SessionClosedException e) {
            this.createSession(this.getTin(), this.getBusinessProfileType(), this.getProjectCode(), this.sourceType, this.isAuthWithCert, this.isQrAuthSign, this.isTicketSigned);
            return this.doWithSession(request, callable);
        }
        catch (AccessDeniedException | BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage(), e);
        }
    }

    private List<InvoiceIdWithReason> createIdsWithReasons(Map<Long, String> idsWithReasons) {
        ArrayList<InvoiceIdWithReason> result = new ArrayList<InvoiceIdWithReason>();
        if (idsWithReasons != null) {
            for (Map.Entry<Long, String> entry : idsWithReasons.entrySet()) {
                result.add(new InvoiceIdWithReason(entry.getKey(), entry.getValue()));
            }
        }
        return result;
    }

    private void createSession(String tin, BusinessProfileType profileType, Long projectCode, SourceType sourceType, boolean isAuthWithCert, boolean isQrAuthSign, boolean isTicketSigned) throws AccessDeniedException, BusinessException {
        CreateSessionRequest request = new CreateSessionRequest();
        request.setTin(tin);
        request.setBusinessProfileType(profileType);
        request.setProjectCode(projectCode);
        request.setX509Certificate(this.authCertificateAsBase64String);
        request.setSourceType(sourceType);
        request.setAuthWithCert(isAuthWithCert);
        request.setAuthByQr(isQrAuthSign);
        request.setTicketSigned(isTicketSigned);
        CreateSessionResponse response = this.getSessionService().createSession(request);
        this.sessionId = response.getSessionId();
    }

    private void checkSignatureAndCertificatePresence(SignedRequest<?> request) {
        if (StringUtils.isEmpty(request.getX509Certificate())) {
            throw new IllegalArgumentException(ERROR_CERTIFICATE_NOT_SPECIFIED);
        }
        if (StringUtils.isEmpty(request.getSignature())) {
            throw new IllegalArgumentException(ERROR_SIGNATURE_NOT_SPECIFIED);
        }
    }

    private static String toBase64(X509Certificate certificate) throws AccessDeniedException {
        try {
            return TrustyUtils.toBase64(certificate);
        }
        catch (CertificateEncodingException e) {
            throw new AccessDeniedException("Wrong certificate", e);
        }
    }
}

