/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;
import ru.uss.core.model.ErrorCode;

public class RelationKey
implements Comparable<RelationKey> {
    private Date date;
    private String num;
    private String tin;
    private Long projectCode;

    public RelationKey(Date date, String num, String tin) {
        this.date = date;
        this.num = num;
        this.tin = tin;
    }

    public RelationKey(Date date, String num, String tin, Long projectCode) {
        this.date = date;
        this.num = num;
        this.tin = tin;
        this.projectCode = projectCode;
    }

    public Date getDate() {
        return this.date;
    }

    public String getNum() {
        return this.num;
    }

    public String getTin() {
        return this.tin;
    }

    public Long getProjectCode() {
        return this.projectCode;
    }

    public boolean equalsWithRelation(RelationKey rk, Collection<String> accessTins) {
        return (Objects.equals(this.date, rk.date) || Objects.equals(rk.date, this.date)) && Objects.equals(this.num, rk.num) && accessTins != null && accessTins.contains(this.tin) && Objects.equals(this.projectCode, rk.projectCode);
    }

    public List<ErrorCode> checkWithRelation(RelationKey rk, Collection<String> accessTins) {
        if (rk == null) {
            return Collections.singletonList(ErrorCode.RELATED_INVOICE_NOT_FOUND);
        }
        ArrayList<ErrorCode> errorCodes = new ArrayList<ErrorCode>();
        if (!Objects.equals(rk.date, this.date) && !Objects.equals(this.date, rk.date)) {
            errorCodes.add(ErrorCode.RELATED_INVOICE_NOT_FOUND);
        }
        if (!Objects.equals(this.num, rk.num)) {
            errorCodes.add(ErrorCode.RELATED_INVOICE_NOT_FOUND);
        }
        if (accessTins == null || !accessTins.contains(this.tin)) {
            errorCodes.add(ErrorCode.RELATED_INVOICE_NOT_FOUND_TIN_FIELD_DIFFERS);
        }
        if (!Objects.equals(this.projectCode, rk.projectCode)) {
            errorCodes.add(ErrorCode.RELATED_INVOICE_NOT_FOUND);
        }
        return errorCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationKey that = (RelationKey)o;
        return (Objects.equals(that.date, this.date) || Objects.equals(this.date, that.date)) && Objects.equals(this.num, that.num) && Objects.equals(this.tin, that.tin) && Objects.equals(this.projectCode, that.projectCode);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.num, this.tin, this.projectCode);
    }

    @Override
    public int compareTo(RelationKey key) {
        return new CompareToBuilder().append(this.tin == null ? "" : this.tin, key.tin == null ? "" : key.tin).append(this.num, key.num).append(this.date, key.date).append(this.projectCode == null ? "" : this.projectCode, key.projectCode == null ? "" : key.projectCode).toComparison();
    }

    public String toString() {
        return "RelationKey{date=" + this.date + ", num='" + this.num + '\'' + ", tin='" + this.tin + '\'' + ", projectCode='" + this.projectCode + '\'' + '}';
    }
}

