/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.utils;

import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.esf.model.permissivedocument.PermissiveDocumentInfo;
import ru.uss.esf.model.permissivedocument.PermissiveDocumentUploadInfo;
import ru.uss.esf.model.permissivedocument.PermissiveDocumentVersion;
import ru.uss.esf.model.permissivedocument.abstractpermissivedocument.AbstractPermissiveDocument;

public class PermissiveDocumentXmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(PermissiveDocumentXmlUtils.class);

    public static AbstractPermissiveDocument xmlToPermissiveDocument(String xml, String version) {
        return PermissiveDocumentXmlUtils.xmlToPermissiveDocument(xml, PermissiveDocumentVersion.valueOf(version));
    }

    public static AbstractPermissiveDocument xmlToPermissiveDocument(String xml, PermissiveDocumentVersion version) {
        return JAXBUtils.toObject(xml, version.getClazz());
    }

    public static void unwrapPermissiveDocument(PermissiveDocumentUploadInfo permissiveDocumentInfo) {
        AbstractPermissiveDocument abstractPermissiveDocument = PermissiveDocumentXmlUtils.xmlToPermissiveDocument(permissiveDocumentInfo.getPermissiveDocumentBody(), permissiveDocumentInfo.getVersion());
        permissiveDocumentInfo.setPermissiveDocument(abstractPermissiveDocument);
    }

    public static void unwrapPermissiveDocument(PermissiveDocumentInfo permissiveDocumentInfo) {
        AbstractPermissiveDocument abstractPermissiveDocument = PermissiveDocumentXmlUtils.xmlToPermissiveDocument(permissiveDocumentInfo.getPermissiveDocumentBody(), permissiveDocumentInfo.getVersion());
        permissiveDocumentInfo.setPermissiveDocument(abstractPermissiveDocument);
    }

    public static void unwrapPermissiveDocumentList(List<PermissiveDocumentUploadInfo> permissiveDocumentInfoList) {
        ((Stream)permissiveDocumentInfoList.stream().parallel()).forEach(PermissiveDocumentXmlUtils::unwrapPermissiveDocument);
    }

    public static String permissiveDocumentToXml(AbstractPermissiveDocument abstractPermissiveDocument) {
        return JAXBUtils.toXml(abstractPermissiveDocument, null, true, true);
    }
}

