/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.utils;

import java.util.List;
import javax.xml.validation.Schema;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.esf.model.snt.SntActionInfo;
import ru.uss.esf.model.snt.SntActionVersionMapper;
import ru.uss.esf.model.snt.SntOgdMarksType;
import ru.uss.esf.model.snt.SntOgdMarksVersionMapper;
import ru.uss.esf.model.snt.SntVersion;
import ru.uss.esf.model.snt.abstractsnt.AbstractSntAction;
import ru.uss.esf.model.snt.abstractsnt.AbstractSntOgdMarks;
import ru.uss.esf.model.snt.version.v1.SntActionV1;

public class SntActionXmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(SntActionXmlUtils.class);
    private static Schema sntActionSchema;

    public static synchronized Schema getSntActionSchema() {
        if (sntActionSchema == null) {
            sntActionSchema = JAXBUtils.scheme(AbstractSntAction.class);
        }
        return sntActionSchema;
    }

    public static void unwrap(SntActionInfo sntActionInfo) {
        try {
            SntActionV1 sntAction1;
            AbstractSntAction sntAction = SntActionXmlUtils.xmlToSntAction(sntActionInfo.getSntActionBody(), sntActionInfo.getSntVersion());
            sntActionInfo.setSntAction(sntAction);
            sntActionInfo.setSntId(sntAction.getSntId());
            if (sntAction instanceof SntActionV1 && StringUtils.isNotEmpty((sntAction1 = (SntActionV1)sntAction).getOgdMarksBody())) {
                AbstractSntOgdMarks sntOgdMarks = SntActionXmlUtils.ogdMarksXmlToSntAction(sntAction1.getOgdMarksBody(), sntAction1.getOgdMarkType(), sntActionInfo.getSntVersion());
                sntAction1.setOgdMarks(sntOgdMarks);
            }
        }
        catch (Exception e) {
            logger.error("Can`t unwrap sntActionInfo", e);
        }
    }

    public static void unwrapList(List<SntActionInfo> sntActionInfoList) {
        for (SntActionInfo sntActionInfo : sntActionInfoList) {
            SntActionXmlUtils.unwrap(sntActionInfo);
        }
    }

    public static AbstractSntAction xmlToSntAction(String xml, SntVersion sntVersion) {
        return JAXBUtils.toObject(xml, SntActionVersionMapper.getClassByVersion(sntVersion));
    }

    public static AbstractSntOgdMarks ogdMarksXmlToSntAction(String xml, SntOgdMarksType ogdMarkType, SntVersion sntVersion) {
        return JAXBUtils.toObject(xml, SntOgdMarksVersionMapper.getClassByVersion(sntVersion, ogdMarkType));
    }

    public static String sntActionToXml(AbstractSntAction sntAction) {
        return JAXBUtils.toXml(sntAction, null, true, true);
    }
}

