/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.utils;

import java.util.List;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.core.xsd.UssSchemaOutputResolver;
import ru.uss.esf.core.utils.xsd.SntExpiredNotificationVersionObjectFactory;
import ru.uss.esf.model.snt.notification.SntExpiredNotificationUploadInfo;
import ru.uss.esf.model.snt.notification.SntExpiredNotificationVersion;
import ru.uss.esf.model.snt.notification.abstractnotification.AbstractSntExpiredNotification;
import ru.uss.esf.model.snt.notification.version.v1.SntExpiredNotificationV1;

public class SntExpiredNotificationXmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(SntExpiredNotificationXmlUtils.class);
    private static Schema sntNotificationContainerSchema;
    private static Schema sntNotificationV1Schema;

    public static synchronized Schema getSntNotificationV1Schema() {
        if (sntNotificationV1Schema == null) {
            sntNotificationV1Schema = JAXBUtils.scheme(SntExpiredNotificationV1.class);
        }
        return sntNotificationV1Schema;
    }

    public static void unwrapSntExpiredNotification(SntExpiredNotificationUploadInfo sntNotification) {
        try {
            AbstractSntExpiredNotification sntExpiredNotification = SntExpiredNotificationXmlUtils.xmlToSntExpiredNotification(sntNotification.getNotificationBody(), sntNotification.getVersion());
            sntNotification.setNotification(sntExpiredNotification);
        }
        catch (Exception e) {
            logger.error("Can`t unwrap sntNotification", e);
        }
    }

    public static void unwrapSntExpiredNotificationList(List<SntExpiredNotificationUploadInfo> sntExpiredNotificationUploadInfos) {
        for (SntExpiredNotificationUploadInfo sntExpiredNotificationUploadInfo : sntExpiredNotificationUploadInfos) {
            SntExpiredNotificationXmlUtils.unwrapSntExpiredNotification(sntExpiredNotificationUploadInfo);
        }
    }

    public static AbstractSntExpiredNotification xmlToSntExpiredNotification(String xml, String version) {
        return SntExpiredNotificationXmlUtils.xmlToSntExpiredNotification(xml, SntExpiredNotificationVersion.valueOf(version));
    }

    public static AbstractSntExpiredNotification xmlToSntExpiredNotification(String xml, SntExpiredNotificationVersion version) {
        return JAXBUtils.toObject(xml, version.getSntClass());
    }

    public static String sntExpiredNotificationToXml(AbstractSntExpiredNotification snt) {
        return JAXBUtils.toXml(snt, null, true, true);
    }

    public static UssSchemaOutputResolver createSntExpiredNotificationXsdResolver(Class<? extends AbstractSntExpiredNotification> clazz) {
        return JAXBUtils.resolver(clazz, SntExpiredNotificationXmlUtils.getSntObjectFactory(clazz));
    }

    public static Class<?> getSntObjectFactory(Class<? extends AbstractSntExpiredNotification> clazz) {
        if (clazz.equals(SntExpiredNotificationV1.class)) {
            return SntExpiredNotificationVersionObjectFactory.class;
        }
        throw new IllegalStateException();
    }
}

