/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.utils;

import java.security.SignatureException;
import javax.security.auth.x500.X500PrivateCredential;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.core.utils.SignatureHelper;
import ru.uss.esf.core.utils.SntXmlUtils;
import ru.uss.esf.model.snt.abstractsnt.AbstractSnt;

public class SntSignatureHelper
extends SignatureHelper {
    public static String sign(AbstractSnt snt, X500PrivateCredential certificate) throws SignatureException {
        return SignatureHelper.sign(SntSignatureHelper.extractSignatureData(snt), certificate);
    }

    public static String extractSignatureData(AbstractSnt snt) {
        try {
            return SntXmlUtils.sntToXml(snt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends AbstractSnt> T cloneSnt(T snt) {
        try {
            String xml = SntXmlUtils.sntToXml(snt);
            Class<? extends AbstractSnt> sntClass = snt.getVersion().getSntClass();
            AbstractSnt sntCopy = JAXBUtils.toObject(xml, sntClass);
            return (T)sntCopy;
        }
        catch (Exception e) {
            throw new RuntimeException("Snt signable copy creation failed", e);
        }
    }

    public static String toXML(Object object) {
        return JAXBUtils.toXml(object, null, true, false);
    }
}

