/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.awp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.springframework.beans.BeanUtils;
import ru.uss.core.model.SignatureType;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.core.validation.common.UTF83ByteCheck;
import ru.uss.esf.model.awp.AwpInfo;
import ru.uss.esf.model.awp.AwpVersion;
import ru.uss.esf.model.awp.abstractawp.AbstractAwp;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AwpUploadInfo")
@Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u043e\u043c \u0410\u0412\u0420")
@JsonIgnoreProperties(ignoreUnknown=true)
public class AwpUploadInfo
implements Serializable {
    @UTF83ByteCheck
    @XmlElement(required=true)
    @Documentation(value="\u0410\u0412\u0420 (XML)")
    private String awpBody;
    @XmlTransient
    @Documentation(value="\u0410\u0412\u0420")
    private AbstractAwp awp;
    @XmlElement(required=true)
    @Documentation(value="\u0412\u0435\u0440\u0441\u0438\u044f \u0410\u0412\u0420")
    private AwpVersion version;
    @NotNull(message="{awp.signature.notNull}")
    @Size(max=400, message="{awp.signature.limit}")
    @JsonInclude
    @XmlElement(required=true)
    @Documentation(value="\u042d\u0426\u041f XML-\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0410\u0412\u0420")
    private @NotNull(message="{awp.signature.notNull}") @Size(max=400, message="{awp.signature.limit}") String signature;
    @NotNull(message="{awp.signatureType.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0438\u043f \u042d\u0426\u041f, \u043a\u043e\u0442\u043e\u0440\u044b\u043c \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d \u0410\u0412\u0420")
    private @NotNull(message="{awp.signatureType.notNull}") SignatureType signatureType;
    @RequiredString(fieldPath="awp.senderSignerName", minLen=1, maxLen=400, required=false)
    @XmlElement(required=false)
    @Documentation(value="\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c \u0441\u0434\u0430\u0432\u0448\u0435\u0433\u043e (\u0432\u044b\u043f\u0438\u0441\u044b\u0432\u0430\u044e\u0449\u0435\u0433\u043e) \u0410\u0412\u0420")
    private String senderSignerName;
    @XmlElement(required=false)
    @Documentation(value="\u0424\u043b\u0430\u0433 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0441\u0443\u043c\u043c \u0432 \u0443\u0441\u043b\u0443\u0433\u0430\u0445")
    private Boolean autoCalculating = Boolean.TRUE;
    @XmlTransient
    @Documentation(value="\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u0430\u043a\u0436\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435 \u2014 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0438 \u0441\u043e\u0437\u0434\u0430\u043b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442")
    private String certificate;
    @XmlTransient
    @Documentation(value="ID \u0410\u0412\u0420, \u043d\u0430 \u0431\u0430\u0437\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0441\u043e\u0437\u0434\u0430\u0435\u0442\u0441\u044f \u043d\u043e\u0432\u044b\u0439")
    private Long draftId;

    public String getAwpBody() {
        return this.awpBody;
    }

    public void setAwpBody(String awpBody) {
        this.awpBody = awpBody;
    }

    public AbstractAwp getAwp() {
        return this.awp;
    }

    public void setAwp(AbstractAwp awp) {
        this.awp = awp;
    }

    public AwpVersion getVersion() {
        return this.version;
    }

    public void setVersion(AwpVersion version) {
        this.version = version;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public String getSenderSignerName() {
        return this.senderSignerName;
    }

    public void setSenderSignerName(String senderSignerName) {
        this.senderSignerName = senderSignerName;
    }

    public Boolean getAutoCalculating() {
        return this.autoCalculating;
    }

    public void setAutoCalculating(Boolean autoCalculating) {
        this.autoCalculating = autoCalculating;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public Long getDraftId() {
        return this.draftId;
    }

    public void setDraftId(Long draftId) {
        this.draftId = draftId;
    }

    public static AwpUploadInfo fromAwpInfo(AwpInfo invoiceInfo) {
        AwpUploadInfo result = new AwpUploadInfo();
        BeanUtils.copyProperties(invoiceInfo, result);
        return result;
    }

    public static List<AwpUploadInfo> fromAwpInfoList(List<AwpInfo> invoiceInfoList) {
        return invoiceInfoList.stream().map(AwpUploadInfo::fromAwpInfo).collect(Collectors.toList());
    }
}

