/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.awp.version.v1;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ru.uss.core.adapter.DateAdapter;
import ru.uss.core.validation.common.BigDecimalCheck;
import ru.uss.core.validation.common.EqualFields;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.core.validation.common.NumberCheck;
import ru.uss.core.validation.common.PastDate;
import ru.uss.core.validation.common.PositiveNumber;
import ru.uss.core.validation.common.PositiveOrZero;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.validation.awp.AwpCalculationTypes;
import ru.uss.esf.validation.awp.version.v1.SumWithoutTaxCheckV1;
import ru.uss.esf.validation.awp.version.v1.WorkNdsRateCheckV1;
import ru.uss.esf.validation.common.clazz.SumOf;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldExists;

@NotEmptyIfTargetFieldExists.List(value={@NotEmptyIfTargetFieldExists(field="ndsAmount", targetField="ndsRate", message="{awpField.ndsAmount.notNull}")})
@SumOf(multiplyFields={"turnoverSize", "ndsAmount"}, resultField="sumWithTax", message="{awpField.sumWithTax.incorrect}", groups={AwpCalculationTypes.Auto.class})
@EqualFields(fields={"sumWithoutTax", "turnoverSize"}, message="{worksPerformed.sumWithoutTax.notEqual.turnoverSize}", groups={AwpCalculationTypes.Auto.class})
@SumWithoutTaxCheckV1(groups={AwpCalculationTypes.Auto.class})
@WorkNdsRateCheckV1(groups={AwpCalculationTypes.Auto.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AwpWork")
@Documentation(value="\u0420\u0430\u0431\u043e\u0442\u0430, \u0443\u0441\u043b\u0443\u0433\u0430")
public class AwpWorkV1 {
    @RequiredString(required=true, fieldPath="awpWork.name", minLen=2, maxLen=400)
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0430\u0431\u043e\u0442 (\u0443\u0441\u043b\u0443\u0433) (\u0432 \u0440\u0430\u0437\u0440\u0435\u0437\u0435 \u0438\u0445 \u043f\u043e\u0434\u0432\u0438\u0434\u043e\u0432 \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0435\u0439, \u0437\u0430\u0434\u0430\u043d\u0438\u0435\u043c, \u0433\u0440\u0430\u0444\u0438\u043a\u043e\u043c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u0431\u043e\u0442 (\u0443\u0441\u043b\u0443\u0433) \u043f\u0440\u0438 \u0438\u0445 \u043d\u0430\u043b\u0438\u0447\u0438\u0438) (G2)")
    private String name;
    @RequiredString(required=false, fieldPath="awpWork.systemName", minLen=2, maxLen=400)
    @XmlElement(required=false)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0430\u0431\u043e\u0442 \u0438 \u0443\u0441\u043b\u0443\u0433 \u0441 \u0443\u0447\u0435\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b (G2.1)")
    private String systemName;
    @RequiredString(required=true, fieldPath="awpWork.gsvsCode", minLen=2, maxLen=64)
    @XmlElement(required=true)
    @Documentation(value="\u0421\u043e\u0441\u0442\u0430\u0432\u043d\u043e\u0439 \u043a\u043e\u0434 \u0413\u0421\u0412\u0421 (G2.2)")
    private String gsvsCode;
    @PastDate(calendarUnitType=1, calendarUnitAmount=5, fieldPath="awpWork.performedDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @XmlElement(required=false)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u0431\u043e\u0442 (\u043e\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0443\u0441\u043b\u0443\u0433) (G3)")
    private Date performedDate;
    @RequiredString(required=false, fieldPath="awpWork.measureUnitCode", minLen=0, maxLen=20)
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u0435\u0434\u0438\u043d\u0438\u0446\u044b \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f (G4)")
    private String measureUnitCode;
    @NumberCheck(fieldPath="awpWork.quantity", minDigitCount=1, maxDigitCount=12)
    @PositiveNumber(fieldPath="awpWork.quantity")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u043b-\u0432\u043e (\u041e\u0431\u044a\u0435\u043c) (G5)")
    private BigDecimal quantity;
    @PositiveOrZero(fieldPath="awpWork.unitPriceWithoutTax")
    @BigDecimalCheck(fieldPath="awpWork.unitPriceWithoutTax", nullable=false, maxLeftLen=12, maxRightLen=2)
    @XmlElement(required=true)
    @Documentation(value="\u0426\u0435\u043d\u0430 (\u0442\u0430\u0440\u0438\u0444) \u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443 \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0431\u0435\u0437 \u043a\u043e\u0441\u0432\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u043b\u043e\u0433\u043e\u0432 (G6)")
    private BigDecimal unitPriceWithoutTax;
    @IsNotNull(fieldPath="awpWork.sumWithoutTax")
    @PositiveOrZero(fieldPath="awpWork.sumWithoutTax")
    @BigDecimalCheck(fieldPath="awpWork.sumWithoutTax", nullable=false, maxLeftLen=12, maxRightLen=2)
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0431\u0435\u0437 \u043a\u043e\u0441\u0432\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u043b\u043e\u0433\u043e\u0432 (G7)")
    private BigDecimal sumWithoutTax;
    @IsNotNull(fieldPath="awpWork.turnoverSize")
    @PositiveOrZero(fieldPath="awpWork.turnoverSize")
    @BigDecimalCheck(fieldPath="awpWork.turnoverSize", nullable=false, maxLeftLen=12, maxRightLen=2)
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0430\u0437\u043c\u0435\u0440 \u043e\u0431\u043e\u0440\u043e\u0442\u0430 \u043f\u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 (\u043e\u0431\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0439/\u043d\u0435\u043e\u0431\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0439 \u043e\u0431\u043e\u0440\u043e\u0442) (G8)")
    private BigDecimal turnoverSize;
    @NumberCheck(fieldPath="awpWork.ndsRate", nullable=true, minDigitCount=1, maxDigitCount=7)
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0442\u0430\u0432\u043a\u0430 \u041d\u0414\u0421 (G9)")
    private Integer ndsRate;
    @BigDecimalCheck(fieldPath="awpWork.ndsAmount", nullable=true, maxLeftLen=12, maxRightLen=2)
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0443\u043c\u043c\u0430 \u041d\u0414\u0421 (G10)")
    private BigDecimal ndsAmount;
    @PositiveOrZero(fieldPath="awpWork.sumWithTax")
    @BigDecimalCheck(fieldPath="awpWork.sumWithTax", nullable=false, maxLeftLen=12, maxRightLen=2)
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u043a\u043e\u0441\u0432\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u043b\u043e\u0433\u043e\u0432 (G11)")
    private BigDecimal sumWithTax;
    @RequiredString(required=false, fieldPath="awpWork.additionalInfo", minLen=1, maxLen=256)
    @XmlElement(required=false)
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f (G12)")
    private String additionalInfo;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getGsvsCode() {
        return this.gsvsCode;
    }

    public void setGsvsCode(String gsvsCode) {
        this.gsvsCode = gsvsCode;
    }

    public Date getPerformedDate() {
        return this.performedDate;
    }

    public void setPerformedDate(Date performedDate) {
        this.performedDate = performedDate;
    }

    public String getMeasureUnitCode() {
        return this.measureUnitCode;
    }

    public void setMeasureUnitCode(String measureUnitCode) {
        this.measureUnitCode = measureUnitCode;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getUnitPriceWithoutTax() {
        return this.unitPriceWithoutTax;
    }

    public void setUnitPriceWithoutTax(BigDecimal unitPriceWithoutTax) {
        this.unitPriceWithoutTax = unitPriceWithoutTax;
    }

    public BigDecimal getSumWithoutTax() {
        return this.sumWithoutTax;
    }

    public void setSumWithoutTax(BigDecimal sumWithoutTax) {
        this.sumWithoutTax = sumWithoutTax;
    }

    public BigDecimal getTurnoverSize() {
        return this.turnoverSize;
    }

    public void setTurnoverSize(BigDecimal turnoverSize) {
        this.turnoverSize = turnoverSize;
    }

    public Integer getNdsRate() {
        return this.ndsRate;
    }

    public void setNdsRate(Integer ndsRate) {
        this.ndsRate = ndsRate;
    }

    public BigDecimal getNdsAmount() {
        return this.ndsAmount;
    }

    public void setNdsAmount(BigDecimal ndsAmount) {
        this.ndsAmount = ndsAmount;
    }

    public BigDecimal getSumWithTax() {
        return this.sumWithTax;
    }

    public void setSumWithTax(BigDecimal sumWithTax) {
        this.sumWithTax = sumWithTax;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }
}

