/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.blocking;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.esf.model.dictionary.EnterpriseType;

@XmlType(name="BlockingReason")
@Documentation(value="\u041f\u0440\u0438\u0447\u0438\u043d\u044b \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u041d\u041f \u0432 \u0418\u0421 \u042d\u0421\u0424")
public enum BlockingReason {
    OTHER(991, EnterpriseType.NOT_SET, EnterpriseType.INDIVIDUAL, EnterpriseType.INDIVIDUAL_ENTREPRENEUR, EnterpriseType.PRIVATE_ENTERPRISE),
    DB_EXCLUDE(251, EnterpriseType.INDIVIDUAL, EnterpriseType.INDIVIDUAL_ENTREPRENEUR, EnterpriseType.NOT_SET, EnterpriseType.PRIVATE_ENTERPRISE),
    DEATH(8, EnterpriseType.INDIVIDUAL, EnterpriseType.INDIVIDUAL_ENTREPRENEUR),
    LIQUIDATION(19, EnterpriseType.NOT_SET, EnterpriseType.PRIVATE_ENTERPRISE),
    ENTITY_LIQUIDATION(5, EnterpriseType.NOT_SET, EnterpriseType.PRIVATE_ENTERPRISE),
    REGISTRATION_CANCEL(256, EnterpriseType.NOT_SET, EnterpriseType.PRIVATE_ENTERPRISE),
    MOVING_OUT(7, EnterpriseType.INDIVIDUAL),
    BUSINESS_TERMINATION(13, EnterpriseType.INDIVIDUAL_ENTREPRENEUR),
    TERMINATION(18, EnterpriseType.INDIVIDUAL_ENTREPRENEUR),
    ENTITY_DISINTEGRATION(4, EnterpriseType.NOT_SET, EnterpriseType.PRIVATE_ENTERPRISE),
    ENTITY_REORGANIZATION(3, EnterpriseType.NOT_SET, EnterpriseType.PRIVATE_ENTERPRISE),
    AGREEMENT_TERMINATION(6, EnterpriseType.INDIVIDUAL, EnterpriseType.INDIVIDUAL_ENTREPRENEUR, EnterpriseType.NOT_SET),
    RISK_MANAGEMENT_SYSTEM(992, EnterpriseType.INDIVIDUAL, EnterpriseType.INDIVIDUAL_ENTREPRENEUR, EnterpriseType.NOT_SET, EnterpriseType.PRIVATE_ENTERPRISE, EnterpriseType.STATE_ENTERPRISE),
    FAKE(41, new EnterpriseType[]{EnterpriseType.INDIVIDUAL_ENTREPRENEUR, EnterpriseType.NOT_SET, EnterpriseType.PRIVATE_ENTERPRISE}){

        @Override
        public boolean extended() {
            return true;
        }
    }
    ,
    REGISTRATION_HAS_INVALID(22, new EnterpriseType[]{EnterpriseType.INDIVIDUAL_ENTREPRENEUR, EnterpriseType.NOT_SET, EnterpriseType.PRIVATE_ENTERPRISE}){

        @Override
        public boolean extended() {
            return true;
        }
    }
    ,
    MEDIATOR_TERMINATION(255, new EnterpriseType[0]),
    BAILIFF_TERMINATION(253, new EnterpriseType[0]),
    LAWYER_TERMINATION(15, new EnterpriseType[0]),
    NOTARY_TERMINATION(16, new EnterpriseType[0]);

    @XmlElement(required=true)
    private final int code;
    private final Set<EnterpriseType> acceptableEnterpriseTypes;

    private BlockingReason(int code, EnterpriseType ... acceptableEnterpriseTypes) {
        this.code = code;
        this.acceptableEnterpriseTypes = new HashSet<EnterpriseType>(Arrays.asList(acceptableEnterpriseTypes));
    }

    public boolean extended() {
        return false;
    }

    public int getCode() {
        return this.code;
    }

    public static final BlockingReason parseCode(int code) {
        for (BlockingReason reason : BlockingReason.values()) {
            if (reason.code != code) continue;
            return reason;
        }
        return null;
    }

    public static final BlockingReason parseName(String value) {
        if (value == null) {
            return null;
        }
        for (BlockingReason reason : BlockingReason.values()) {
            if (!reason.name().equals(value)) continue;
            return reason;
        }
        return null;
    }

    public Set<EnterpriseType> getAcceptableEnterpriseTypes() {
        return this.acceptableEnterpriseTypes;
    }
}

