/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.dictionary;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlType;
import ru.uss.esf.model.registration.RegistrationType;

@XmlType(name="EnterpriseType")
@Documentation(value="\u0422\u0438\u043f \u043d\u0430\u043b\u043e\u0433\u043e\u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430")
public enum EnterpriseType {
    NOT_SET(0),
    INDIVIDUAL(1),
    INDIVIDUAL_ENTREPRENEUR(2),
    PRIVATE_ENTERPRISE(3),
    STATE_ENTERPRISE(4);

    private byte typeId;

    private EnterpriseType(byte typeId) {
        this.typeId = typeId;
    }

    public static EnterpriseType getTypeById(byte typeId) {
        for (EnterpriseType type : EnterpriseType.values()) {
            if (type.getTypeId() != typeId) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown enterprise type identifier - " + typeId);
    }

    public static EnterpriseType getTypeByOrgformCode(String orgformCode) {
        switch (orgformCode = orgformCode.trim()) {
            case "\u0413\u0423": 
            case "\u0413\u0424": 
            case "\u041a\u0417\u041f": 
            case "\u0413\u041f": 
            case "\u0414\u0413\u041f": 
            case "\u0413\u041f\u0425\u0412": {
                return STATE_ENTERPRISE;
            }
        }
        return "\u0424\u041b".equals(orgformCode) || "\u0418\u041d\u0414".equals(orgformCode) ? INDIVIDUAL : PRIVATE_ENTERPRISE;
    }

    public byte getTypeId() {
        return this.typeId;
    }

    public static Set<EnterpriseType> resolve(RegistrationType type) {
        HashSet<EnterpriseType> result = new HashSet<EnterpriseType>();
        if (type == RegistrationType.INDIVIDUAL) {
            result.add(INDIVIDUAL);
        } else if (type == RegistrationType.ENTREPRENEUR) {
            result.add(INDIVIDUAL_ENTREPRENEUR);
        } else if (type == RegistrationType.ENTERPRISE) {
            result.add(PRIVATE_ENTERPRISE);
            result.add(NOT_SET);
            result.add(STATE_ENTERPRISE);
        }
        return result;
    }
}

