/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.econtract;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.esf.model.econtract.EcontractParticipantStatus;
import ru.uss.esf.model.econtract.EcontractStatus;
import ru.uss.esf.model.econtract.abstractecontract.EcontractType;
import ru.uss.esf.model.usermng.Permission;

@XmlType(name="EcontractActionType")
@Documentation(value="\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043d\u0430\u0434 \u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u043c\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c\u0438")
public enum EcontractActionType {
    CREATE(EnumSet.noneOf(EcontractStatus.class), EnumSet.noneOf(EcontractParticipantStatus.class), EcontractParticipantStatus.CREATED, Permission.ECONTRACT_CREATE, true, true, false, true, new EcontractType[0]),
    DELETE(EnumSet.of(EcontractStatus.FAILED, EcontractStatus.DRAFT, EcontractStatus.IMPORTED), EnumSet.of(EcontractParticipantStatus.DRAFT, EcontractParticipantStatus.FAILED, EcontractParticipantStatus.IMPORTED), EcontractParticipantStatus.NOT_AVAILABLE, Permission.ECONTRACT_CREATE, true, true, false, false, new EcontractType[0]),
    CONFIRM(EnumSet.of(EcontractStatus.WAITING_FOR_CONFIRMATION), EnumSet.of(EcontractParticipantStatus.WAITING_FOR_CONFIRMATION), EcontractParticipantStatus.CONFIRMED, Permission.ECONTRACT_CREATE, true, false, false, true, new EcontractType[0]),
    VIEW(EnumSet.of(EcontractStatus.NOT_VIEWED, EcontractStatus.PARTIALLY_VIEWED, EcontractStatus.PARTIALLY_APPROVED), EnumSet.of(EcontractParticipantStatus.NOT_VIEWED), EcontractParticipantStatus.VIEWED, Permission.ECONTRACT_VIEW, false, true, false, false, new EcontractType[0]),
    APPROVE(EnumSet.of(EcontractStatus.PARTIALLY_VIEWED, EcontractStatus.VIEWED, EcontractStatus.PARTIALLY_APPROVED), EnumSet.of(EcontractParticipantStatus.VIEWED), EcontractParticipantStatus.APPROVED, Permission.ECONTRACT_APPROVE, false, true, false, true, new EcontractType[0]),
    DECLINE(EnumSet.of(EcontractStatus.PARTIALLY_VIEWED, EcontractStatus.VIEWED, EcontractStatus.PARTIALLY_APPROVED), EnumSet.of(EcontractParticipantStatus.VIEWED), EcontractParticipantStatus.DECLINED, Permission.ECONTRACT_APPROVE, false, true, true, true, new EcontractType[0]),
    REVOKE(EnumSet.of(EcontractStatus.NOT_VIEWED, EcontractStatus.PARTIALLY_VIEWED, EcontractStatus.VIEWED, EcontractStatus.WAITING_FOR_CONFIRMATION), EnumSet.of(EcontractParticipantStatus.CREATED, EcontractParticipantStatus.CONFIRMED, EcontractParticipantStatus.WAITING_FOR_CONFIRMATION), EcontractParticipantStatus.REVOKED, Permission.ECONTRACT_REVOKE, true, false, true, true, new EcontractType[0]),
    TERMINATE(EnumSet.of(EcontractStatus.APPROVED), EnumSet.of(EcontractParticipantStatus.CREATED, EcontractParticipantStatus.CONFIRMED, EcontractParticipantStatus.APPROVED), EcontractParticipantStatus.INITIATED_TERMINATION, Permission.ECONTRACT_TERMINATE, true, true, true, true, EcontractType.SUPPLEMENTARY, EcontractType.CESSION_OF_RIGHTS),
    CONFIRM_TERMINATION(EnumSet.of(EcontractStatus.IN_PROCESS_OF_TERMINATION, EcontractStatus.PARTIALLY_TERMINATED), EnumSet.of(EcontractParticipantStatus.CREATED, EcontractParticipantStatus.CONFIRMED, EcontractParticipantStatus.APPROVED), EcontractParticipantStatus.CONFIRMED_TERMINATION, Permission.ECONTRACT_TERMINATE, true, true, false, true, EcontractType.SUPPLEMENTARY, EcontractType.CESSION_OF_RIGHTS),
    DECLINE_TERMINATION(EnumSet.of(EcontractStatus.IN_PROCESS_OF_TERMINATION, EcontractStatus.PARTIALLY_TERMINATED), EnumSet.of(EcontractParticipantStatus.CREATED, EcontractParticipantStatus.CONFIRMED, EcontractParticipantStatus.APPROVED), EcontractParticipantStatus.DECLINED_TERMINATION, Permission.ECONTRACT_TERMINATE, true, true, true, true, EcontractType.SUPPLEMENTARY, EcontractType.CESSION_OF_RIGHTS),
    TRANSFER(EnumSet.allOf(EcontractStatus.class), EnumSet.range(EcontractParticipantStatus.CREATED, EcontractParticipantStatus.DECLINED_TERMINATION), null, Permission.ECONTRACT_CREATE, true, true, true, false, new EcontractType[0]),
    CLOSE(EnumSet.of(EcontractStatus.APPROVED), EnumSet.allOf(EcontractParticipantStatus.class), EcontractParticipantStatus.CLOSED, Permission.ECONTRACT_TERMINATE, false, false, false, false, new EcontractType[0]);

    private EnumSet<EcontractStatus> allowablePreviousEcontractStatuses;
    private EnumSet<EcontractParticipantStatus> allowablePreviousParticipantStatuses;
    private EcontractParticipantStatus targetParticipantStatus;
    private Permission permission;
    private Set<EcontractType> exceptionalTypes;
    private boolean availableToInitiatingParty;
    private boolean availableToOtherParty;
    private boolean needReason;
    private boolean needSignature;

    private EcontractActionType(EnumSet<EcontractStatus> allowablePreviousEcontractStatuses, EnumSet<EcontractParticipantStatus> allowablePreviousParticipantStatuses, EcontractParticipantStatus targetParticipantStatus, Permission permission, boolean availableToInitiatingParty, boolean availableToOtherParty, boolean needReason, boolean needSignature, EcontractType ... types) {
        this.allowablePreviousEcontractStatuses = allowablePreviousEcontractStatuses;
        this.allowablePreviousParticipantStatuses = allowablePreviousParticipantStatuses;
        this.targetParticipantStatus = targetParticipantStatus;
        this.permission = permission;
        this.availableToInitiatingParty = availableToInitiatingParty;
        this.availableToOtherParty = availableToOtherParty;
        this.needReason = needReason;
        this.needSignature = needSignature;
        if (types != null && types.length > 0) {
            this.exceptionalTypes = Stream.of(types).collect(Collectors.toSet());
        }
    }

    public boolean isExecutableOnEcontractStatus(EcontractStatus status) {
        return this.allowablePreviousEcontractStatuses.contains((Object)status);
    }

    public boolean isExecutableOnParticipantStatus(EcontractParticipantStatus status) {
        return this.allowablePreviousParticipantStatuses.contains((Object)status);
    }

    public EcontractParticipantStatus getTargetParticipantStatus() {
        return this.targetParticipantStatus;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public boolean isAvailable(boolean forInitiatingParty) {
        return forInitiatingParty ? this.isAvailableToInitiatingParty() : this.isAvailableToOtherParty();
    }

    public boolean isAvailableToInitiatingParty() {
        return this.availableToInitiatingParty;
    }

    public boolean isAvailableToOtherParty() {
        return this.availableToOtherParty;
    }

    public boolean isNeedReason() {
        return this.needReason;
    }

    public boolean isNeedSignature() {
        return this.needSignature;
    }

    public boolean isEcontractTypeApplicable(EcontractType type) {
        if (!CollectionUtils.isEmpty(this.exceptionalTypes)) {
            return !this.exceptionalTypes.contains((Object)type);
        }
        return true;
    }
}

