/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.econtract.abstractecontract;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.groups.Default;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ru.uss.core.adapter.DateAdapter;
import ru.uss.core.model.ValidationGroupsAware;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.esf.model.econtract.EcontractVersion;
import ru.uss.esf.model.econtract.abstractecontract.AbstractEcontractParticipant;
import ru.uss.esf.model.econtract.abstractecontract.AbstractProduct;
import ru.uss.esf.model.econtract.abstractecontract.AbstractStage;
import ru.uss.esf.model.econtract.abstractecontract.EcontractType;
import ru.uss.esf.model.econtract.abstractecontract.RelatedEcontract;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.econtract.PresenceOfRelatedEcontract;

@PresenceOfRelatedEcontract
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractEcontract")
@Documentation(value="\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u043a\u043b\u0430\u0441\u0441 \u0434\u043b\u044f \u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432")
public abstract class AbstractEcontract
implements ValidationGroupsAware {
    @IsNotNull(fieldPath="econtract.type")
    @XmlElement(required=true)
    @Documentation(value="\u0412\u0438\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    private EcontractType type;
    @IsNotNull(fieldPath="econtract.number")
    @Text(min=1, max=255, message="{econtract.number.size}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0431\u0443\u043c\u0430\u0436\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    private String number;
    @IsNotNull(fieldPath="econtract.date")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @XmlElement(required=true)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    private Date date;
    @IsNotNull(fieldPath="econtract.startDate")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @XmlElement(required=true)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    private Date startDate;
    @IsNotNull(fieldPath="econtract.endDate")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @XmlElement(required=true)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    private Date endDate;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0439 \u042d\u0414")
    private RelatedEcontract relatedEcontract;
    @IsNotNull(fieldPath="econtract.totalSum")
    @XmlElement(required=true)
    @Documentation(value="\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430")
    private BigDecimal totalSum;
    @IsNotNull(fieldPath="econtract.totalImplementationDeadline")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @XmlElement(required=true)
    @Documentation(value="\u041e\u0431\u0449\u0438\u0439 \u0441\u0440\u043e\u043a \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438")
    private Date totalImplementationDeadline;
    @IsNotNull(fieldPath="econtract.totalPaymentDeadline")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @XmlElement(required=true)
    @Documentation(value="\u041e\u0431\u0449\u0438\u0439 \u0441\u0440\u043e\u043a \u043e\u043f\u043b\u0430\u0442\u044b")
    private Date totalPaymentDeadline;
    @XmlTransient
    private EcontractVersion version;

    public abstract List<? extends AbstractStage> getStages();

    public abstract List<? extends AbstractProduct> getSpecifications();

    public EcontractType getType() {
        return this.type;
    }

    public void setType(EcontractType type) {
        this.type = type;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public RelatedEcontract getRelatedEcontract() {
        return this.relatedEcontract;
    }

    public Long getRelatedEcontractId() {
        return this.relatedEcontract != null ? this.relatedEcontract.getEcontractId() : null;
    }

    public String getRelatedEcontractRegistrationNumber() {
        return this.relatedEcontract != null ? this.relatedEcontract.getRegistrationNumber() : null;
    }

    public void setRelatedEcontract(RelatedEcontract relatedEcontract) {
        this.relatedEcontract = relatedEcontract;
    }

    public BigDecimal getTotalSum() {
        return this.totalSum;
    }

    public void setTotalSum(BigDecimal totalSum) {
        this.totalSum = totalSum;
    }

    public Date getTotalImplementationDeadline() {
        return this.totalImplementationDeadline;
    }

    public void setTotalImplementationDeadline(Date totalImplementationDeadline) {
        this.totalImplementationDeadline = totalImplementationDeadline;
    }

    public Date getTotalPaymentDeadline() {
        return this.totalPaymentDeadline;
    }

    public EcontractVersion getVersion() {
        return this.version;
    }

    public void setVersion(EcontractVersion version) {
        this.version = version;
    }

    public void setTotalPaymentDeadline(Date totalPaymentDeadline) {
        this.totalPaymentDeadline = totalPaymentDeadline;
    }

    public abstract List<AbstractEcontractParticipant> getParticipants();

    public abstract List<String> getCustomerTinList();

    public abstract List<String> getSupplierTinList();

    public abstract Map<AbstractEcontractParticipant, AbstractEcontractParticipant> getSuccessorByPredecessor();

    public boolean isParticipant(String tin) {
        return this.getParticipants().stream().anyMatch(p -> p.getTin().equals(tin));
    }

    @Override
    public Class<?>[] groups() {
        return (Class[])Arrays.asList(this.getType().getGroup(), this.getRelatedEcontract() != null ? this.getRelatedEcontract().getType().getGroup() : null, Default.class).stream().filter(Objects::nonNull).toArray(Class[]::new);
    }

    public String toString() {
        return "AbstractEcontract{type=" + (Object)((Object)this.type) + ", number='" + this.number + '\'' + ", date=" + this.date + '}';
    }
}

