/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.egp.awp;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public enum EgpAwpStatus {
    APPROVED("\u0423\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d"),
    DECLINED("\u041e\u0442\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0438"),
    NOT_FOUND("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d"),
    PROJECT("\u041f\u0440\u043e\u0435\u043a\u0442"),
    SUPPLIER_SIGNING("\u041d\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430"),
    CUSTOMER_SIGNING("\u041d\u0430 \u0441\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u0438\u0438 \u0443 \u0437\u0430\u043a\u0430\u0437\u0447\u0438\u043a\u0430"),
    CUSTOMER_APPROVING("\u041d\u0430 \u0441\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u0438\u0438 \u0443 \u0437\u0430\u043a\u0430\u0437\u0447\u0438\u043a\u0430");

    private String egpName;
    public static final List<EgpAwpStatus> PROHIBITED_STATUSES;
    public static final List<EgpAwpStatus> VALID_STATUSES;

    private EgpAwpStatus(String name) {
        this.egpName = name;
    }

    public String getEgpName() {
        return this.egpName;
    }

    public void setEgpName(String egpName) {
        this.egpName = egpName;
    }

    public static EgpAwpStatus getByName(String egpName) {
        Optional<EgpAwpStatus> egpStatus = Stream.of(EgpAwpStatus.values()).filter(status -> status.name().equals(egpName)).findFirst();
        return egpStatus.orElse(NOT_FOUND);
    }

    public static EgpAwpStatus getByEgpName(String egpName) {
        Optional<EgpAwpStatus> egpStatus = Stream.of(EgpAwpStatus.values()).filter(status -> status.getEgpName().equals(egpName)).findFirst();
        return egpStatus.orElse(NOT_FOUND);
    }

    public static boolean prohibitedStatus(EgpAwpStatus status) {
        return PROHIBITED_STATUSES.contains((Object)status);
    }

    public static boolean validStatus(String status) {
        return VALID_STATUSES.contains((Object)EgpAwpStatus.valueOf(status));
    }

    static {
        PROHIBITED_STATUSES = Arrays.asList(DECLINED, NOT_FOUND, PROJECT, SUPPLIER_SIGNING, CUSTOMER_SIGNING, CUSTOMER_APPROVING);
        VALID_STATUSES = Arrays.asList(APPROVED, DECLINED);
    }
}

