/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.ibd;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.esf.model.ChangeStatusResult;
import ru.uss.esf.model.awp.AwpChangeStatusResult;
import ru.uss.esf.model.blocking.Blocking;
import ru.uss.esf.model.econtract.EcontractChangeStatusResult;
import ru.uss.esf.model.snt.SntChangeStatusResult;

@XmlRootElement(name="ToIbdCounterContainer")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ToIbdCounterContainer")
@Documentation(value="\u041a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0432 \u0418\u0411\u0414")
@XmlSeeAlso(value={EcontractChangeStatusResult.class, AwpChangeStatusResult.class, ChangeStatusResult.class, SntChangeStatusResult.class, Blocking.class})
public class ToIbdCounterContainer<T> {
    private static final Map<String, Integer> containerPerRequestCounterMap = new HashMap<String, Integer>();
    private int containerHistoryId;
    private String requestGuid;
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private List<T> dataList;
    @XmlTransient
    @Documentation(value="\u0421\u0447\u0435\u0442\u0447\u0438\u043a \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0418\u0411\u0414")
    private int counter = 0;
    @XmlElement(required=false)
    private long containerId;

    public ToIbdCounterContainer() {
        this.containerId = System.currentTimeMillis();
    }

    public ToIbdCounterContainer(List<T> dataList, int counter) {
        this.dataList = dataList;
        this.counter = counter;
    }

    protected ToIbdCounterContainer(List<T> dataList, long partitionKey, int counter) {
        this.containerId = partitionKey;
        this.dataList = dataList;
        this.counter = counter;
    }

    protected ToIbdCounterContainer(String requestGuid, List<T> data, long partitionKey) {
        this(data, partitionKey, 0);
        this.requestGuid = requestGuid;
        this.containerHistoryId = !containerPerRequestCounterMap.containsKey(requestGuid) ? 1 : containerPerRequestCounterMap.get(requestGuid) + 1;
        containerPerRequestCounterMap.put(requestGuid, this.containerHistoryId);
    }

    public static <T> ToIbdCounterContainer createNew(List<T> dataList) {
        return new ToIbdCounterContainer<T>(dataList, 0);
    }

    public static <T> ToIbdCounterContainer createNewSingle(T singleRow) {
        return new ToIbdCounterContainer<T>(Collections.singletonList(singleRow), 0);
    }

    public static <T> ToIbdCounterContainer createNew(List<T> invoiceIdList, Long partitionKey) {
        return new ToIbdCounterContainer<T>(invoiceIdList, partitionKey, 0);
    }

    public static <T> ToIbdCounterContainer createHistoryDataContainer(List<T> invoiceIdList, Long partitionKey, String requestGuid) {
        return new ToIbdCounterContainer<T>(requestGuid, invoiceIdList, partitionKey);
    }

    public static ToIbdCounterContainer incerementCounter(ToIbdCounterContainer container) {
        container.setCounter(container.getCounter() + 1);
        return container;
    }

    public long getContainerId() {
        return this.containerId;
    }

    public String containerInfo() {
        if (this.requestGuid == null) {
            return String.valueOf(this.containerId);
        }
        return "IbdHistContainer{requestGuid=" + this.requestGuid + ", containerHistoryId=" + this.containerHistoryId + ", dataArraySize: " + this.getDataList().size() + '}';
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }
}

