/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.springframework.beans.BeanUtils;
import ru.uss.core.model.Error;
import ru.uss.core.model.SignatureType;
import ru.uss.core.validation.common.UTF83ByteCheck;
import ru.uss.esf.model.invoice.InvoiceInfo;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractInvoice;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType
@Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u042d\u0421\u0424")
@JsonIgnoreProperties(ignoreUnknown=true)
public class InvoiceUploadInfo
implements Serializable {
    @UTF83ByteCheck
    @XmlElement(required=true)
    @Documentation(value="\u042d\u0421\u0424 (XML)")
    private String invoiceBody;
    @XmlTransient
    @Documentation(value="\u042d\u0421\u0424")
    private AbstractInvoice invoice;
    @XmlTransient
    @Documentation(value="\u041e\u0448\u0438\u0431\u043a\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0432 \u0438\u043d\u0432\u043e\u0439\u0441\u0435")
    private List<Error> errors = new ArrayList<Error>();
    @XmlTransient
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u044f \u042d\u0421\u0424 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0443")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    private Date inputDate;
    @XmlTransient
    @Documentation(value="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043f\u0440\u0438\u043d\u044f\u0442")
    private boolean accepted;
    @XmlElement(required=true)
    @Documentation(value="\u0412\u0435\u0440\u0441\u0438\u044f \u042d\u0421\u0424")
    private String version;
    @NotNull(message="{invoice.signature.notNull}")
    @Size(max=400, message="{invoice.signature.limit}")
    @JsonInclude
    @XmlElement(required=true)
    @Documentation(value="\u042d\u0426\u041f (J)")
    private @NotNull(message="{invoice.signature.notNull}") @Size(max=400, message="{invoice.signature.limit}") String signature;
    @NotNull(message="{invoice.signatureType.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0438\u043f \u042d\u0426\u041f (J)")
    private @NotNull(message="{invoice.signatureType.notNull}") SignatureType signatureType;
    @XmlTransient
    @Documentation(value="\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0438 \u0421\u0424, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u0430\u043a\u0436\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435 \u2014 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0438 \u0441\u043e\u0437\u0434\u0430\u043b \u042d\u0421\u0424")
    private String certificate;

    public String getInvoiceBody() {
        return this.invoiceBody;
    }

    public void setInvoiceBody(String invoiceBody) {
        this.invoiceBody = invoiceBody;
    }

    public AbstractInvoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(AbstractInvoice invoice) {
        this.invoice = invoice;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public Date getInputDate() {
        return this.inputDate;
    }

    public void setInputDate(Date inputDate) {
        this.inputDate = inputDate;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public boolean isDeclined() {
        return !this.accepted;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public static InvoiceUploadInfo fromInvoice(AbstractInvoice invoice) {
        InvoiceUploadInfo result = new InvoiceUploadInfo();
        result.setInvoice(invoice);
        result.setVersion(invoice.getVersion());
        return result;
    }

    public static List<InvoiceUploadInfo> fromInvoiceList(List<AbstractInvoice> invoiceList) {
        return invoiceList.stream().map(InvoiceUploadInfo::fromInvoice).collect(Collectors.toList());
    }

    public static InvoiceUploadInfo fromInvoiceInfo(InvoiceInfo invoiceInfo) {
        InvoiceUploadInfo result = new InvoiceUploadInfo();
        BeanUtils.copyProperties(invoiceInfo, result);
        return result;
    }

    public static List<InvoiceUploadInfo> fromInvoiceInfoList(List<InvoiceInfo> invoiceInfoList) {
        return invoiceInfoList.stream().map(InvoiceUploadInfo::fromInvoiceInfo).collect(Collectors.toList());
    }
}

