/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.abstractinvoice;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ru.uss.core.adapter.DateAdapter;
import ru.uss.core.model.ValidationGroupsAware;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractParticipant;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractProduct;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.abstractinvoice.RelatedInvoice;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.validation.common.field.CurrentDate;
import ru.uss.esf.validation.invoice.ImmutableForAdditional;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=InvoiceV1.class), @JsonSubTypes.Type(value=InvoiceV2.class)})
@XmlRootElement(name="invoice")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractInvoice")
@Documentation(value="\u0411\u0430\u0437\u043e\u0432\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u042d\u0421\u0424 \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u0432\u0435\u0440\u0441\u0438\u0439 \u042d\u0421\u0424 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435")
@JsonIgnoreProperties(value={"@class"})
public abstract class AbstractInvoice
implements Serializable,
ValidationGroupsAware {
    @NotNull(message="{invoice.num.notNull}")
    @Pattern(regexp="[0-9]{1,30}", message="{invoice.num.size}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043d\u043e\u043c\u0435\u0440 \u042d\u0421\u0424 \u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f (A 1)")
    private @NotNull(message="{invoice.num.notNull}") @Pattern(regexp="[0-9]{1,30}", message="{invoice.num.size}") String num;
    @NotNull(message="{invoice.date.notNull}")
    @CurrentDate(message="{invoice.date.current}")
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u042d\u0421\u0424 (A 2)")
    private @NotNull(message="{invoice.date.notNull}") Date date;
    @NotNull(message="{invoice.turnoverDate.notNull}")
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043e\u0431\u043e\u0440\u043e\u0442\u0430 (A 3)")
    private @NotNull(message="{invoice.turnoverDate.notNull}") Date turnoverDate;
    @NotNull(message="{invoice.invoiceType.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0438\u043f \u042d\u0421\u0424")
    private @NotNull(message="{invoice.invoiceType.notNull}") InvoiceType invoiceType;
    @NotNull(message="{invoice.operatorFullname.notNull}")
    @Size(max=200, message="{invoice.operatorFullname.limit}")
    @Documentation(value="\u0424\u0418\u041e \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0432\u0448\u0435\u0433\u043e \u042d\u0421\u0424 ")
    private @NotNull(message="{invoice.operatorFullname.notNull}") @Size(max=200, message="{invoice.operatorFullname.limit}") String operatorFullname;
    @Valid
    @Documentation(value="\u0421\u043b\u0443\u0436\u0438\u0442 \u0434\u043b\u044f \u0441\u0432\u044f\u0437\u043a\u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0433\u043e/\u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u042d\u0421\u0424 \u0441 \u043e\u0441\u043d\u043e\u0432\u043d\u044b\u043c")
    private RelatedInvoice relatedInvoice;
    @XmlTransient
    private Long draftId;
    @XmlTransient
    private Long importedId;
    @XmlTransient
    @ImmutableForAdditional
    private String version;

    public String getNum() {
        return this.num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getTurnoverDate() {
        return this.turnoverDate;
    }

    public void setTurnoverDate(Date turnoverDate) {
        this.turnoverDate = turnoverDate;
    }

    public InvoiceType getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(InvoiceType invoiceType) {
        this.invoiceType = invoiceType;
    }

    public RelatedInvoice getRelatedInvoice() {
        return this.relatedInvoice;
    }

    public void setRelatedInvoice(RelatedInvoice relatedInvoice) {
        this.relatedInvoice = relatedInvoice;
    }

    public String getVersion() {
        return this.getClass().getSimpleName();
    }

    public String getOperatorFullname() {
        return this.operatorFullname;
    }

    public void setOperatorFullname(String operatorFullname) {
        this.operatorFullname = operatorFullname;
    }

    public Long getDraftId() {
        return this.draftId;
    }

    public void setDraftId(Long draftId) {
        this.draftId = draftId;
    }

    public Long getImportedId() {
        return this.importedId;
    }

    public void setImportedId(Long importedId) {
        this.importedId = importedId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public abstract BigDecimal getTotalPriceWithTax();

    public abstract String getCreatorTin();

    public abstract Long getCreatorProjectCode();

    public abstract List<String> getSellerTinList();

    public abstract List<String> getSellerReorganizedTinList();

    public abstract String getSellerReorganizedTin(int var1);

    public abstract String getCustomerReorganizedTin(int var1);

    @XmlTransient
    @JsonIgnore
    public abstract List<String> getSellerBranchTinList();

    @XmlTransient
    @JsonIgnore
    public abstract List<String> getSellerPartyTins();

    public abstract List<String> getCustomerTinList();

    public abstract List<String> getNullableCustomerTinList();

    public abstract List<String> getCustomerReorganizedTinList();

    public abstract List<String> getNullableCustomerReorganizedTinList();

    public abstract Set<String> getTnvedCodes();

    @XmlTransient
    @JsonIgnore
    public abstract List<String> getCustomerBranchTinList();

    @XmlTransient
    @JsonIgnore
    public abstract String getStringNdsRateType();

    @XmlTransient
    @JsonIgnore
    public abstract DocumentParticipantType getCustomerType();

    @XmlTransient
    @JsonIgnore
    public abstract DocumentParticipantType getSellerType();

    @XmlTransient
    @JsonIgnore
    public List<? extends AbstractProduct> getProducts() {
        return Collections.emptyList();
    }

    public abstract List<? extends AbstractParticipant> getCustomers();

    public abstract List<? extends AbstractParticipant> getSellers();

    public abstract String getDeliveryDocNum();

    @Override
    public Class<?>[] groups() {
        return new Class[]{Default.class};
    }

    public void recalculateProductIndexes() {
        List<? extends AbstractProduct> products = this.getProducts();
        if (products != null) {
            for (int i = 0; i < products.size(); ++i) {
                if (products.get(i) == null) continue;
                products.get(i).setIdx(i);
            }
        }
    }

    public abstract boolean isSellerLessor();
}

