/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.model.VersionedDocument;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractInvoice;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractProduct;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v1.ConsigneeV1;
import ru.uss.esf.model.invoice.version.v1.ConsignorV1;
import ru.uss.esf.model.invoice.version.v1.CustomerTypeV1;
import ru.uss.esf.model.invoice.version.v1.CustomerV1;
import ru.uss.esf.model.invoice.version.v1.DeliveryTermV1;
import ru.uss.esf.model.invoice.version.v1.ParticipantV1;
import ru.uss.esf.model.invoice.version.v1.ProductSetV1;
import ru.uss.esf.model.invoice.version.v1.ProductShareV1;
import ru.uss.esf.model.invoice.version.v1.ProductV1;
import ru.uss.esf.model.invoice.version.v1.PublicOfficeV1;
import ru.uss.esf.model.invoice.version.v1.SellerTypeV1;
import ru.uss.esf.model.invoice.version.v1.SellerV1;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.common.relation.AllNotEmptyOrEmpty;
import ru.uss.esf.validation.common.relation.Lists;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldExists;
import ru.uss.esf.validation.invoice.version.v1.CustomerCountryCodeV1;
import ru.uss.esf.validation.invoice.version.v1.CustomersParticipantsV1;
import ru.uss.esf.validation.invoice.version.v1.ExportersV1;
import ru.uss.esf.validation.invoice.version.v1.NdsRateV1;
import ru.uss.esf.validation.invoice.version.v1.NonResidentCurrencyV1;
import ru.uss.esf.validation.invoice.version.v1.ProductDistributionV1;
import ru.uss.esf.validation.invoice.version.v1.RelatedDateV1;
import ru.uss.esf.validation.invoice.version.v1.RelatedNumV1;
import ru.uss.esf.validation.invoice.version.v1.SellersParticipantsV1;
import ru.uss.esf.validation.invoice.version.v1.TurnoverDateV1;

@Lists.List(value={@Lists(lists={"sellers", "sellerParticipants"}, field="tin", errorNodes={"sellers"}, constraint=Lists.Constraint.EQUALS_SETS, message="{invoiceV1.sellersAndParticipants.notEquals}"), @Lists(lists={"customers", "customerParticipants"}, field="tin", errorNodes={"customers"}, constraint=Lists.Constraint.EQUALS_SETS, message="{invoiceV1.customersAndParticipants.notEquals}"), @Lists(lists={"productIdxList", "sellerParticipantProductList"}, errorNodes={"productSet"}, constraint=Lists.Constraint.EQUALS_SETS, message="{invoiceV1.productsAndSellerParticipantProducts.notEquals}"), @Lists(lists={"productIdxList", "customerParticipantProductList"}, errorNodes={"productSet"}, constraint=Lists.Constraint.EQUALS_SETS, message="{invoiceV1.productsAndCustomerParticipantProducts.notEquals}"), @Lists(lists={"sellers", "customers"}, field="tin", errorNodes={"sellers", "customers"}, constraint=Lists.Constraint.DISJOINT_SETS, message="{invoiceV1.sellersAndCustomers.disjoint}")})
@AllNotEmptyOrEmpty.List(value={@AllNotEmptyOrEmpty(fields={"sellerParticipants", "sellerParticipantsIfExists"}, errorNodes={"sellerParticipants"}, message="{invoiceV1.sellerParticipants.notConsistent}"), @AllNotEmptyOrEmpty(fields={"customerParticipants", "customerParticipantsIfExists"}, errorNodes={"customerParticipants"}, message="{invoiceV1.customerParticipants.notConsistent}"), @AllNotEmptyOrEmpty(fields={"relatedInvoice", "relatedStatusesIfExists"}, errorNodes={"relatedInvoice"}, message="{invoiceV1.relatedInvoice.notConsistent}"), @AllNotEmptyOrEmpty(fields={"publicOffice", "customerPublicOfficeStatus"}, errorNodes={"publicOffice"}, message="{invoiceV1.publicOfficeFields.notConsistent}")})
@NotEmptyIfTargetFieldExists.List(value={@NotEmptyIfTargetFieldExists(field="sellers.kbe", targetField="customerPublicOfficeStatus", message="{invoiceV1.sellers.kbe.notNull}"), @NotEmptyIfTargetFieldExists(field="sellers.bik", targetField="customerPublicOfficeStatus", message="{invoiceV1.sellers.bik.notNull}"), @NotEmptyIfTargetFieldExists(field="sellers.iik", targetField="customerPublicOfficeStatus", message="{invoiceV1.sellers.iik.notNull}"), @NotEmptyIfTargetFieldExists(field="sellers.bank", targetField="customerPublicOfficeStatus", message="{invoiceV1.sellers.bank.notNull}")})
@ProductDistributionV1
@TurnoverDateV1
@RelatedDateV1
@RelatedNumV1
@ExportersV1
@NdsRateV1
@NonResidentCurrencyV1
@CustomerCountryCodeV1
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="invoice")
@XmlType(name="InvoiceV1")
@Documentation(value="\u042d\u0421\u0424")
public class InvoiceV1
extends AbstractInvoice
implements VersionedDocument {
    @Valid
    @SellersParticipantsV1
    @XmlElementWrapper(required=true)
    @XmlElement(name="seller", required=true)
    @Documentation(value="\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a (B)")
    private List<SellerV1> sellers;
    @Valid
    @CustomersParticipantsV1
    @XmlElementWrapper(required=true)
    @XmlElement(name="customer", required=true)
    @Documentation(value="\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c (C)")
    private List<CustomerV1> customers;
    @Valid
    @Documentation(value="\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438 (E)")
    private DeliveryTermV1 deliveryTerm;
    @Valid
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0433\u0440\u0443\u0437\u043e\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f (D 23)")
    private ConsignorV1 consignor;
    @Valid
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0433\u0440\u0443\u0437\u043e\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f (D 24)")
    private ConsigneeV1 consignee;
    @Valid
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f (F)")
    private PublicOfficeV1 publicOffice;
    @Valid
    @Size(min=1, message="{invoiceV1.sellerParticipants.emptyList}")
    @XmlElementWrapper
    @XmlElement(name="participant", required=true)
    @Documentation(value="\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a (\u0423\u0421\u0414) (H)")
    private @Valid @Size(min=1, message="{invoiceV1.sellerParticipants.emptyList}") List<ParticipantV1> sellerParticipants;
    @Valid
    @Size(min=1, message="{invoiceV1.customerParticipants.emptyList}")
    @XmlElementWrapper
    @XmlElement(name="participant", required=true)
    @Documentation(value="\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c (\u0423\u0421\u0414) (H)")
    private @Valid @Size(min=1, message="{invoiceV1.customerParticipants.emptyList}") List<ParticipantV1> customerParticipants;
    @Text(min=1, max=255, message="{invoiceV1.addInf.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f (I)")
    private String addInf;
    @Valid
    @NotNull(message="{invoiceV1.products.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0422\u043e\u0432\u0430\u0440\u044b (\u0440\u0430\u0431\u043e\u0442\u044b, \u0443\u0441\u043b\u0443\u0433\u0438) (G)")
    private @Valid @NotNull(message="{invoiceV1.products.notNull}") ProductSetV1 productSet;

    public List<SellerV1> getSellers() {
        return this.sellers;
    }

    public void setSellers(List<SellerV1> sellers) {
        this.sellers = sellers;
    }

    public List<CustomerV1> getCustomers() {
        return this.customers;
    }

    @Override
    public String getDeliveryDocNum() {
        return null;
    }

    @Override
    @XmlTransient
    public boolean isSellerLessor() {
        return this.sellers != null && this.sellers.stream().anyMatch(seller -> seller.isLessor());
    }

    public void setCustomers(List<CustomerV1> customers) {
        this.customers = customers;
    }

    public DeliveryTermV1 getDeliveryTerm() {
        return this.deliveryTerm;
    }

    public void setDeliveryTerm(DeliveryTermV1 deliveryTerm) {
        this.deliveryTerm = deliveryTerm;
    }

    public ConsignorV1 getConsignor() {
        return this.consignor;
    }

    public void setConsignor(ConsignorV1 consignor) {
        this.consignor = consignor;
    }

    public ConsigneeV1 getConsignee() {
        return this.consignee;
    }

    public void setConsignee(ConsigneeV1 consignee) {
        this.consignee = consignee;
    }

    public PublicOfficeV1 getPublicOffice() {
        return this.publicOffice;
    }

    public void setPublicOffice(PublicOfficeV1 publicOffice) {
        this.publicOffice = publicOffice;
    }

    public List<ParticipantV1> getSellerParticipants() {
        return this.sellerParticipants;
    }

    public void setSellerParticipants(List<ParticipantV1> sellerParticipants) {
        this.sellerParticipants = sellerParticipants;
    }

    public List<ParticipantV1> getCustomerParticipants() {
        return this.customerParticipants;
    }

    public void setCustomerParticipants(List<ParticipantV1> customerParticipants) {
        this.customerParticipants = customerParticipants;
    }

    public String getAddInf() {
        return this.addInf;
    }

    public void setAddInf(String addInf) {
        this.addInf = addInf;
    }

    public CustomerTypeV1 getCustomerPublicOfficeStatus() {
        List<CustomerV1> customers = this.getCustomers();
        if (customers != null && !customers.isEmpty() && customers.get(0).getStatuses() != null && !customers.get(0).getStatuses().isEmpty() && customers.get(0).getStatuses().contains(CustomerTypeV1.PUBLIC_OFFICE)) {
            return CustomerTypeV1.PUBLIC_OFFICE;
        }
        return null;
    }

    public InvoiceType getRelatedStatusesIfExists() {
        if (this.getInvoiceType() != null && (this.getInvoiceType() == InvoiceType.FIXED_INVOICE || this.getInvoiceType() == InvoiceType.ADDITIONAL_INVOICE)) {
            return this.getInvoiceType();
        }
        return null;
    }

    public List<Integer> getSellerParticipantProductList() {
        return this.getParticipantProductList(this.sellerParticipants);
    }

    public List<Integer> getCustomerParticipantProductList() {
        return this.getParticipantProductList(this.customerParticipants);
    }

    @AssertTrue(message="{invoice.participantTableCountExcited}")
    public @AssertTrue(message="{invoice.participantTableCountExcited}") boolean isParticipantTableCountExcited() {
        return this.getSellerParticipantProductList() == null || this.getCustomerParticipantProductList() == null || this.getSellerParticipantProductList().size() + this.getCustomerParticipantProductList().size() <= 200;
    }

    private List<Integer> getParticipantProductList(List<ParticipantV1> participants) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            for (ParticipantV1 p : participants) {
                if (p.getProductShares() == null) {
                    return null;
                }
                for (ProductShareV1 ps : p.getProductShares()) {
                    list.add(ps.getProductNumber());
                }
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return list;
    }

    public Integer getSellerParticipantsIfExists() {
        List<SellerV1> sellers = this.getSellers();
        if (sellers == null || sellers.size() < 2) {
            return null;
        }
        return sellers.size();
    }

    public Integer getCustomerParticipantsIfExists() {
        List<CustomerV1> customers = this.getCustomers();
        if (customers == null || customers.size() < 2) {
            return null;
        }
        return customers.size();
    }

    public String getFirstCustomerTin() {
        List<CustomerV1> customers = this.getCustomers();
        if (customers != null && !customers.isEmpty() && customers.get(0) != null && customers.get(0).getTin() != null) {
            return customers.get(0).getTin();
        }
        return null;
    }

    @Override
    public BigDecimal getTotalPriceWithTax() {
        if (this.getProductSet() != null) {
            return this.getProductSet().getTotalPriceWithTax();
        }
        return null;
    }

    @Override
    public String getCreatorTin() {
        List<SellerV1> sellers = this.getSellers();
        if (sellers != null && !sellers.isEmpty() && sellers.get(0) != null) {
            return sellers.get(0).getTin();
        }
        return null;
    }

    @Override
    public Long getCreatorProjectCode() {
        return null;
    }

    @Override
    public List<String> getSellerTinList() {
        ArrayList<String> list = new ArrayList<String>();
        List<SellerV1> sellers = this.getSellers();
        if (sellers != null) {
            for (SellerV1 seller : sellers) {
                if (seller == null || seller.getTin() == null) continue;
                list.add(seller.getTin());
            }
        }
        return list;
    }

    @Override
    public List<String> getSellerReorganizedTinList() {
        ArrayList<String> list = new ArrayList<String>();
        List<SellerV1> sellers = this.getSellers();
        if (sellers != null) {
            for (SellerV1 seller : sellers) {
                if (seller == null || seller.getTin() == null) continue;
                list.add(null);
            }
        }
        return list;
    }

    @Override
    public String getSellerReorganizedTin(int index) {
        return null;
    }

    @Override
    public String getCustomerReorganizedTin(int index) {
        return null;
    }

    @Override
    public List<String> getSellerBranchTinList() {
        return new ArrayList<String>(0);
    }

    @Override
    public List<String> getSellerPartyTins() {
        return this.getSellerTinList();
    }

    @Override
    public List<String> getCustomerTinList() {
        List<CustomerV1> customers = this.getCustomers();
        ArrayList<String> list = new ArrayList<String>();
        if (customers != null) {
            for (CustomerV1 customer : customers) {
                if (customer == null || customer.getTin() == null) continue;
                list.add(customer.getTin());
            }
        }
        return list;
    }

    @Override
    public List<String> getNullableCustomerTinList() {
        List<CustomerV1> customers = this.getCustomers();
        ArrayList<String> list = new ArrayList<String>();
        if (customers != null) {
            for (CustomerV1 customer : customers) {
                if (customer == null) continue;
                list.add(customer.getTin());
            }
        }
        list.sort(Comparator.comparing(String::hashCode));
        return list;
    }

    @Override
    public List<String> getCustomerReorganizedTinList() {
        List<CustomerV1> customers = this.getCustomers();
        ArrayList<String> list = new ArrayList<String>();
        if (customers != null) {
            for (CustomerV1 customer : customers) {
                if (customer == null || customer.getTin() == null) continue;
                list.add(null);
            }
        }
        return list;
    }

    @Override
    public List<String> getNullableCustomerReorganizedTinList() {
        List<CustomerV1> customers = this.getCustomers();
        ArrayList<String> list = new ArrayList<String>();
        if (customers != null) {
            for (CustomerV1 customer : customers) {
                if (customer == null) continue;
                list.add(null);
            }
        }
        return list;
    }

    @Override
    public List<String> getCustomerBranchTinList() {
        return new ArrayList<String>(0);
    }

    @Override
    public String getStringNdsRateType() {
        return null;
    }

    @Override
    public DocumentParticipantType getCustomerType() {
        if (!CollectionUtils.isEmpty(this.customers) && this.customers.get(0).containsStatus(CustomerTypeV1.INDIVIDUAL)) {
            return DocumentParticipantType.INDIVIDUAL;
        }
        return DocumentParticipantType.BUSINESS;
    }

    @Override
    public Set<String> getTnvedCodes() {
        if (this.getProductSet() != null && this.getProductSet().getProducts() != null) {
            return this.getProductSet().getProducts().stream().filter(p -> !StringUtils.isEmpty(p.getUnitCode())).map(p -> p.getUnitCode()).collect(Collectors.toSet());
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public DocumentParticipantType getSellerType() {
        return DocumentParticipantType.BUSINESS;
    }

    public boolean isForExport() {
        return this.getSellers() != null && this.getSellers().stream().filter(seller -> seller.getStatuses() != null && seller.getStatuses().contains(SellerTypeV1.EXPORTER)).count() > 0L;
    }

    public boolean isCustomerNonResident() {
        return this.getCustomers() != null && this.getCustomers().size() != 0 && this.getCustomers().get(0).getStatuses().contains(CustomerTypeV1.NONRESIDENT);
    }

    public ProductSetV1 getProductSet() {
        return this.productSet;
    }

    public void setProductSet(ProductSetV1 productSet) {
        this.productSet = productSet;
    }

    public List<ProductV1> getProductList() {
        if (this.productSet != null && this.productSet.getProducts() != null) {
            return this.productSet.getProducts();
        }
        return Collections.EMPTY_LIST;
    }

    public List<Integer> getProductIdxList() {
        if (this.productSet == null || this.productSet.getProducts() == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i <= this.productSet.getProducts().size(); ++i) {
            list.add(i);
        }
        return list;
    }

    @Override
    @XmlTransient
    @JsonIgnore
    public List<? extends AbstractProduct> getProducts() {
        if (this.productSet != null && this.productSet.getProducts() != null) {
            return this.productSet.getProducts();
        }
        return new ArrayList(0);
    }
}

