/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v1;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ru.uss.core.adapter.DateAdapter;
import ru.uss.esf.model.invoice.LegalEntity;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractParticipant;
import ru.uss.esf.model.invoice.version.v1.SellerTypeV1;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.common.field.Tin;
import ru.uss.esf.validation.common.relation.AllNotEmptyOrEmpty;
import ru.uss.esf.validation.invoice.version.v1.field.SellerTypesV1;

@AllNotEmptyOrEmpty.List(value={@AllNotEmptyOrEmpty(fields={"certificateSeries", "certificateNum"}, message="{sellerV1.certificate.notConsistent}"), @AllNotEmptyOrEmpty(fields={"deliveryDocNum", "deliveryDocDate"}, message="{sellerV1.deliveryFields.notConsistent}"), @AllNotEmptyOrEmpty(fields={"kbe", "bik", "iik", "bank"}, message="{sellerV1.bankFields.notConsistent}")})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Seller")
@Documentation(value="\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a (B)")
public class SellerV1
extends AbstractParticipant
implements Serializable,
LegalEntity {
    @NotNull(message="{sellerV1.tin.notNull}")
    @Tin(message="{sellerV1.tin.format}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d (B 6)")
    private @NotNull(message="{sellerV1.tin.notNull}") String tin;
    @ExactDigitsCount(count=12, message="{sellerV1.rnn.digits}")
    @Documentation(value="\u0420\u041d\u041d \u0440\u0435\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 (B 6.1)")
    private String rnn;
    @NotNull(message="{sellerV1.name.notNull}")
    @Text(min=3, max=450, message="{sellerV1.name.size}")
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 (B 7)")
    private @NotNull(message="{sellerV1.name.notNull}") String name;
    @Text(min=3, max=255, message="{sellerV1.address.size}")
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 (B 8)")
    private String address;
    @ExactDigitsCount(count=5, message="{sellerV1.certificateSeries.digits}")
    @Documentation(value="\u0421\u0435\u0440\u0438\u044f c\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u041d\u0414\u0421 (B 9.1)")
    private String certificateSeries;
    @ExactDigitsCount(count=7, message="{sellerV1.certificateNum.digits}")
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 c\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u041d\u0414\u0421 (B 9.2)")
    private String certificateNum;
    @SellerTypesV1
    @XmlElementWrapper
    @XmlElement(name="status", required=true)
    @Documentation(value="\u0422\u0438\u043f \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430")
    private List<SellerTypeV1> statuses;
    @Text(min=1, max=50, message="{sellerV1.deliveryDocNum.size}")
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0443 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 (\u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433) (B 11.1)")
    private String deliveryDocNum;
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0443 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 (\u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433) (B 11.2)")
    private Date deliveryDocDate;
    @ExactDigitsCount(count=2, message="{seller.kbe.digits}")
    @Documentation(value="\u041a\u0411\u0435 (B 13)")
    private String kbe;
    @Text(min=8, max=8, message="{sellerV1.bik.size}")
    @Documentation(value="\u0411\u0418\u041a (B 15)")
    private String bik;
    @Text(min=20, max=34, message="{sellerV1.iik.size}")
    @Documentation(value="\u0420\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u0441\u0447\u0435\u0442 (B 14)")
    private String iik;
    @Text(min=1, max=450, message="{sellerV1.bank.size}")
    @Documentation(value="\u0411\u0430\u043d\u043a (B 16)")
    private String bank;
    @Text(min=1, max=255, message="{sellerV1.trailer.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f (B 12)")
    private String trailer;

    public String getRnn() {
        return this.rnn;
    }

    public void setRnn(String rnn) {
        this.rnn = rnn;
    }

    public String getCertificateSeries() {
        return this.certificateSeries;
    }

    public void setCertificateSeries(String value) {
        this.certificateSeries = value;
    }

    public String getCertificateNum() {
        return this.certificateNum;
    }

    public void setCertificateNum(String value) {
        this.certificateNum = value;
    }

    public String getTrailer() {
        return this.trailer;
    }

    public void setTrailer(String value) {
        this.trailer = value;
    }

    public List<SellerTypeV1> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<SellerTypeV1> statuses) {
        this.statuses = statuses;
    }

    public String getKbe() {
        return this.kbe;
    }

    public void setKbe(String kbe) {
        this.kbe = kbe;
    }

    public String getBik() {
        return this.bik;
    }

    public void setBik(String bik) {
        this.bik = bik;
    }

    public String getIik() {
        return this.iik;
    }

    public void setIik(String iik) {
        this.iik = iik;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getDeliveryDocNum() {
        return this.deliveryDocNum;
    }

    public void setDeliveryDocNum(String value) {
        this.deliveryDocNum = value;
    }

    public Date getDeliveryDocDate() {
        return this.deliveryDocDate;
    }

    public void setDeliveryDocDate(Date value) {
        this.deliveryDocDate = value;
    }

    @Override
    public String getTin() {
        return this.tin;
    }

    @Override
    public boolean isLessor() {
        return this.statuses != null && this.statuses.contains(SellerTypeV1.LESSOR);
    }

    @Override
    public void setTin(String tin) {
        this.tin = tin;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    public boolean containsStatus(SellerTypeV1 status) {
        return this.statuses != null && this.statuses.contains(status);
    }

    @Override
    public boolean isNonResident() {
        return false;
    }

    @Override
    public boolean isIndividual() {
        return false;
    }

    @Override
    public boolean isRetail() {
        return false;
    }
}

