/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v2;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.esf.model.invoice.LegalEntity;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractParticipant;
import ru.uss.esf.model.invoice.version.v2.CustomerTypeV2;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.common.field.Tin;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldContains;
import ru.uss.esf.validation.invoice.ImmutableForAdditional;
import ru.uss.esf.validation.invoice.InvoiceImmutableFromSnt;
import ru.uss.esf.validation.invoice.version.v2.CustomerTinV2;
import ru.uss.esf.validation.invoice.version.v2.field.CustomerTypesV2;

@CustomerTinV2
@NotEmptyIfTargetFieldContains.List(value={@NotEmptyIfTargetFieldContains(checkedField="address", targetField="statuses", expectedValues={"NONRESIDENT"}, message="{customerV2.address.notNull}")})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Customer")
@Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0449\u0438\u0442\u044b \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f (C)")
public class CustomerV2
extends AbstractParticipant
implements Serializable,
LegalEntity {
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d (C 16)")
    @InvoiceImmutableFromSnt(nullAsEmptyString=true)
    private String tin;
    @ExactDigitsCount(count=12, message="{customerV2.reorganizedTin.digits}")
    @Documentation(value="\u0411\u0418\u041d \u0440\u0435\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 (B 16.1)")
    private String reorganizedTin;
    @NotNull(message="{customerV2.name.notNull}")
    @Text(min=1, max=450, message="{customerV2.name.size}")
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f (C 17)")
    private @NotNull(message="{customerV2.name.notNull}") String name;
    @Documentation(value="\u0414\u043e\u043b\u044f \u0443\u0447\u0430\u0441\u0442\u0438\u044f (\u0421 17.1)")
    @Digits(integer=12, fraction=6, message="{customerV2.shareParticipation.digits}")
    @ImmutableForAdditional
    private @Digits(integer=12, fraction=6, message="{customerV2.shareParticipation.digits}") BigDecimal shareParticipation;
    @Text(min=3, max=400, message="{customerV2.address.size}")
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 (C 18)")
    private String address;
    @NotNull(message="{customerV2.countryCode.notNull}")
    @Text(min=2, max=2, message="{customerV2.countryCode.size}")
    @Documentation(value="\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f. \u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0435\u0441\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441 CustomerType.NONRESIDENT \u0438 SellerType.EXPORTER (C 18.1)")
    @XmlElement(required=true)
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt(additional=false)
    private @NotNull(message="{customerV2.countryCode.notNull}") String countryCode;
    @Text(min=1, max=255, message="{customerV2.trailer.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f (C 19)")
    private String trailer;
    @CustomerTypesV2
    @XmlElementWrapper
    @XmlElement(name="status", required=true)
    @Documentation(value="\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f (\u0421 20)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private List<CustomerTypeV2> statuses;
    @Documentation(value="\u0411\u0418\u041d \u0444\u0438\u043b\u0438\u0430\u043b\u0430, \u0432\u044b\u043f\u0438\u0441\u0430\u0432\u0448\u0435\u0433\u043e \u042d\u0421\u0424 \u0437\u0430 \u0433\u043e\u043b\u043e\u0432\u0443")
    @ExactDigitsCount(count=12, message="{customerV2.branchTin.digits}")
    @Tin(message="{customerV2.branchTin.format}")
    @ImmutableForAdditional
    private String branchTin;
    @XmlTransient
    private Long branchTinSearch;

    @Override
    public String getTin() {
        return this.tin;
    }

    @Override
    public boolean isLessor() {
        return false;
    }

    @Override
    public void setTin(String tin) {
        this.tin = tin;
    }

    public String getReorganizedTin() {
        return this.reorganizedTin;
    }

    public void setReorganizedTin(String reorganizedTin) {
        this.reorganizedTin = reorganizedTin;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getShareParticipation() {
        return this.shareParticipation;
    }

    public void setShareParticipation(BigDecimal shareParticipation) {
        this.shareParticipation = shareParticipation;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    public String getTrailer() {
        return this.trailer;
    }

    public void setTrailer(String value) {
        this.trailer = value;
    }

    public List<CustomerTypeV2> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<CustomerTypeV2> statuses) {
        this.statuses = statuses;
    }

    public boolean containsStatus(CustomerTypeV2 status) {
        return this.statuses != null && this.statuses.contains(status);
    }

    public String getBranchTin() {
        return this.branchTin;
    }

    public void setBranchTin(String branchTin) {
        this.branchTin = branchTin;
    }

    public Long getBranchTinSearch() {
        return this.branchTinSearch;
    }

    public void setBranchTinSearch(Long branchTinSearch) {
        this.branchTinSearch = branchTinSearch;
    }

    @Override
    public boolean isNonResident() {
        return CollectionUtils.isNotEmpty(this.statuses) && this.statuses.contains(CustomerTypeV2.NONRESIDENT);
    }

    @Override
    public boolean isIndividual() {
        return CollectionUtils.isNotEmpty(this.statuses) && this.statuses.contains(CustomerTypeV2.INDIVIDUAL);
    }

    @Override
    public boolean isRetail() {
        return CollectionUtils.isNotEmpty(this.statuses) && this.statuses.contains(CustomerTypeV2.RETAIL);
    }
}

