/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.Date;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.utils.BigDecimalUtils;
import ru.uss.core.validation.common.IsNull;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractProduct;
import ru.uss.esf.validation.common.field.DecimalFormat;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldContains;
import ru.uss.esf.validation.common.relation.TextLengthIfTagretFieldContains;
import ru.uss.esf.validation.invoice.ImmutableForAdditional;
import ru.uss.esf.validation.invoice.InvoiceImmutableFromSnt;
import ru.uss.esf.validation.invoice.version.v2.ProductNumberInDeclarationV2;

@TextLengthIfTagretFieldContains.List(value={@TextLengthIfTagretFieldContains(checkedField="productDeclaration", targetField="truOriginCode", expectedValue="1", min=18, max=42, message="{productSetV2.products.truOriginCode_1}"), @TextLengthIfTagretFieldContains(checkedField="productDeclaration", targetField="truOriginCode", expectedValue="3", min=11, max=13, message="{productSetV2.products.truOriginCode_3}")})
@NotEmptyIfTargetFieldContains.List(value={@NotEmptyIfTargetFieldContains(checkedField="unitCode", targetField="truOriginCode", expectedValues={"1", "2", "3"}, message="{productV2.unitCode.notNull}")})
@ProductNumberInDeclarationV2
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Product")
@Documentation(value="\u0422\u043e\u0432\u0430\u0440 (\u0440\u0430\u0431\u043e\u0442\u0430, \u0443\u0441\u043b\u0443\u0433\u0430)")
public class ProductV2
extends AbstractProduct {
    @XmlElement(required=false)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 (\u0442\u043e\u0432\u0430\u0440\u0430, \u0443\u0441\u043b\u0443\u0433\u0438) \u0438\u0437 \u0421\u041d\u0422 (G 1)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private String productNumberInSnt;
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0422\u0420\u0423 (G 2)")
    @NotNull(message="{productV2.truOriginCode.notNull}")
    @Pattern(regexp="[1-6]", message="{productV2.truOriginCode.pattern}")
    @InvoiceImmutableFromSnt
    private @NotNull(message="{productV2.truOriginCode.notNull}") @Pattern(regexp="[1-6]", message="{productV2.truOriginCode.pattern}") String truOriginCode;
    @Text(min=2, max=2500, message="{productV2.description.size}")
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0422\u0420\u0423 (G 3)")
    @InvoiceImmutableFromSnt
    @ImmutableForAdditional
    private String description;
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u043f\u043e \u043a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0443 \u0422\u041d \u0412\u042d\u0414 \u0415\u0410\u042d\u0421 (G 3/1)")
    @Text(min=1, max=1024, message="{productV2.tnvedName.size}")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt(removeSymbolOnCompare="\n")
    private String tnvedName;
    @Pattern(regexp="[0-9]{1,10}", message="{productV2.unitCode.digits}")
    @Documentation(value="\u041a\u043e\u0434 \u0442\u043e\u0432\u0430\u0440\u0430 (\u0422\u041d\u0412\u0414 \u0415\u0410\u042d\u0421) (G 4)")
    @InvoiceImmutableFromSnt
    private @Pattern(regexp="[0-9]{1,10}", message="{productV2.unitCode.digits}") String unitCode;
    @Text(min=1, max=10, message="{productV2.unitNomenclature.size}")
    @Documentation(value="\u0415\u0434.\u0438\u0437\u043c (G 5)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private String unitNomenclature;
    @Text(min=1, max=10, message="{productV2.quantitativeUnitNomenclature.size}")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f (G 5/1)")
    private String quantitativeUnitNomenclature;
    @Digits(integer=12, fraction=6, message="{productV2.quantity.digits}")
    @DecimalFormat(message="{productV2.quantity.decimalFormat}")
    @Documentation(value="\u041a\u043e\u043b-\u0432\u043e (\u043e\u0431\u044a\u0435\u043c) (G 6)")
    @InvoiceImmutableFromSnt
    private @Digits(integer=12, fraction=6, message="{productV2.quantity.digits}") BigDecimal quantity;
    @Digits(integer=12, fraction=6, message="{productV2.quantitativeQuantity.digits}")
    @DecimalFormat(message="{productV2.quantitativeQuantity.decimalFormat}")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u043e\u0432\u0430\u0440\u0430 \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0435\u0434\u0438\u043d\u0438\u0446\u0435 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f (G 6/2)")
    private @Digits(integer=12, fraction=6, message="{productV2.quantitativeQuantity.digits}") BigDecimal quantitativeQuantity;
    @Digits(integer=12, fraction=6, message="{productV2.unitPrice.digits}")
    @DecimalFormat(message="{productV2.unitPrice.decimalFormat}")
    @Documentation(value="\u0426\u0435\u043d\u0430 (\u0442\u0430\u0440\u0438\u0444) \u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443 \u0422\u0420\u0423 \u0431\u0435\u0437 \u043a\u043e\u0441\u0432\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u043b\u043e\u0433\u043e\u0432 (G 7)")
    private @Digits(integer=12, fraction=6, message="{productV2.unitPrice.digits}") BigDecimal unitPrice;
    @NotNull(message="{productV2.priceWithoutTax.notNull}")
    @Digits(integer=15, fraction=2, message="{productV2.priceWithoutTax.digits}")
    @DecimalFormat(message="{productV2.priceWithoutTax.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0422\u0420\u0423 \u0431\u0435\u0437 \u043a\u043e\u0441\u0432\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u043b\u043e\u0433\u043e\u0432 (G 8)")
    private @NotNull(message="{productV2.priceWithoutTax.notNull}") @Digits(integer=15, fraction=2, message="{productV2.priceWithoutTax.digits}") BigDecimal priceWithoutTax;
    @Digits(integer=12, fraction=2, message="{productV2.exciseRate.digits}")
    @DecimalFormat(message="{productV2.exciseRate.decimalFormat}")
    @Min(value=0L, message="{productV2.exciseRate.min}")
    @Documentation(value="\u0410\u043a\u0446\u0438\u0437-\u0421\u0442\u0430\u0432\u043a\u0430 (G 9)")
    private @Digits(integer=12, fraction=2, message="{productV2.exciseRate.digits}") @Min(value=0L, message="{productV2.exciseRate.min}") BigDecimal exciseRate;
    @Digits(integer=15, fraction=2, message="{productV2.exciseAmount.digits}")
    @DecimalFormat(message="{productV2.exciseAmount.decimalFormat}")
    @Documentation(value="\u0410\u043a\u0446\u0438\u0437-\u0421\u0443\u043c\u043c\u0430 (G 10)")
    private @Digits(integer=15, fraction=2, message="{productV2.exciseAmount.digits}") BigDecimal exciseAmount;
    @NotNull(message="{productV2.turnoverSize.notNull}")
    @Digits(integer=15, fraction=2, message="{productV2.turnoverSize.digits}")
    @DecimalFormat(message="{productV2.turnoverSize.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0430\u0437\u043c\u0435\u0440 \u043e\u0431\u043e\u0440\u043e\u0442\u0430 \u043f\u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 (\u043e\u0431\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0439/\u043d\u0435\u043e\u0431\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0439 \u043e\u0431\u043e\u0440\u043e\u0442) (G 11)")
    private @NotNull(message="{productV2.turnoverSize.notNull}") @Digits(integer=15, fraction=2, message="{productV2.turnoverSize.digits}") BigDecimal turnoverSize;
    @IsNull(message="{productV2.turnoverAdjustment.mustBeNull}")
    @XmlElement(required=false)
    @Documentation(value="\u041e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0438 \u043e\u0431\u043e\u0440\u043e\u0442\u0430 (G 11/1)")
    private Integer turnoverAdjustment;
    @Max(value=100L, message="{productV2.ndsRate.max}")
    @Min(value=0L, message="{productV2.ndsRate.min}")
    @Documentation(value="\u041d\u0414\u0421-\u0421\u0442\u0430\u0432\u043a\u0430 (G 12)")
    private @Max(value=100L, message="{productV2.ndsRate.max}") @Min(value=0L, message="{productV2.ndsRate.min}") Integer ndsRate;
    @NotNull(message="{productV2.ndsAmount.notNull}")
    @Digits(integer=15, fraction=2, message="{productV2.ndsAmount.digits}")
    @DecimalFormat(message="{productV2.ndsAmount.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0414\u0421-\u0421\u0443\u043c\u043c\u0430 (G 13)")
    private @NotNull(message="{productV2.ndsAmount.notNull}") @Digits(integer=15, fraction=2, message="{productV2.ndsAmount.digits}") BigDecimal ndsAmount;
    @IsNull(message="{productV2.turnoverCode.mustBeNull}")
    @XmlElement(required=false)
    @Documentation(value="\u041e\u0431\u043e\u0440\u043e\u0442 \u043f\u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 (G 14)")
    private String turnoverCode;
    @NotNull(message="{productV2.priceWithTax.notNull}")
    @Digits(integer=15, fraction=2, message="{productV2.priceWithTax.digits}")
    @DecimalFormat(message="{productV2.priceWithTax.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0422\u0420\u0423 \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u041d\u0414\u0421 (G 15)")
    private @NotNull(message="{productV2.priceWithTax.notNull}") @Digits(integer=15, fraction=2, message="{productV2.priceWithTax.digits}") BigDecimal priceWithTax;
    @Documentation(value="\u0414\u0435\u043a\u043b\u0430\u0440\u0430\u0446\u0438\u0438 \u043d\u0430 \u0442\u043e\u0432\u0430\u0440\u044b, \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0422\u0421, \u0421\u0422-1 \u0438\u043b\u0438 \u0421\u0422-KZ (G 16)")
    @Text(min=11, max=42, message="{productV2.productDeclaration.size}")
    @InvoiceImmutableFromSnt
    private String productDeclaration;
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0438\u0437 \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0422\u0421 \u0438\u043b\u0438 \u0414\u0435\u043a\u043b\u0430\u0440\u0430\u0446\u0438\u0438 \u043d\u0430 \u0442\u043e\u0432\u0430\u0440\u044b (G 17)")
    @Text(min=1, max=11, message="{productV2.productNumberInDeclaration.size}")
    @InvoiceImmutableFromSnt
    private String productNumberInDeclaration;
    @NotNull(message="{productV2.catalogTruId.notNull}")
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u043e\u0432\u0430\u0440\u0430, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 (G 18)")
    @Text(min=1, max=255, message="{productV2.catalogTruId.size}")
    @XmlElement(required=true)
    @InvoiceImmutableFromSnt
    private @NotNull(message="{productV2.catalogTruId.notNull}") String catalogTruId;
    @Text(min=1, max=255, message="{productV2.additional.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 (G 19)")
    private String additional;
    @IsNull(message="{productV2.additionalUnitNomenclature.mustBeNull}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f (G 20)")
    @XmlElement(required=false)
    private String additionalUnitNomenclature;
    @ExactDigitsCount(count=8, message="{productV2.kpvedCode.digits}")
    @Documentation(value="\u041a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u0432\u0438\u0434\u0430\u043c \u044d\u043a\u043e\u043d\u043e\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438")
    @ImmutableForAdditional
    private String kpvedCode;
    @XmlTransient
    @JsonIgnore
    private boolean moveable = true;
    @XmlTransient
    @JsonIgnore
    private boolean moveableInPaperInvoice = false;
    @XmlTransient
    @JsonIgnore
    private Date gsvsActualityDate;

    @Override
    public String getProductNumberInSnt() {
        return this.productNumberInSnt;
    }

    public void setProductNumberInSnt(String productNumberInSnt) {
        this.productNumberInSnt = productNumberInSnt;
    }

    public Date getGsvsActualityDate() {
        return this.gsvsActualityDate;
    }

    public void setGsvsActualityDate(Date gsvsActualityDate) {
        this.gsvsActualityDate = gsvsActualityDate;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean moveable) {
        this.moveable = moveable;
    }

    public boolean isMoveableInPaperInvoice() {
        return this.moveableInPaperInvoice;
    }

    public void setMoveableInPaperInvoice(boolean moveableInPaperInvoice) {
        this.moveableInPaperInvoice = moveableInPaperInvoice;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTnvedName() {
        return this.tnvedName;
    }

    public void setTnvedName(String tnvedName) {
        this.tnvedName = tnvedName;
    }

    @Override
    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String value) {
        this.unitCode = value;
    }

    public String getKpvedCode() {
        return this.kpvedCode;
    }

    public void setKpvedCode(String kpvedCode) {
        this.kpvedCode = kpvedCode;
    }

    public String getTurnoverCode() {
        return this.turnoverCode;
    }

    public void setTurnoverCode(String turnoverCode) {
        this.turnoverCode = turnoverCode;
    }

    public String getUnitNomenclature() {
        return this.unitNomenclature;
    }

    public void setUnitNomenclature(String value) {
        this.unitNomenclature = value;
    }

    public String getQuantitativeUnitNomenclature() {
        return this.quantitativeUnitNomenclature;
    }

    public void setQuantitativeUnitNomenclature(String quantitativeUnitNomenclature) {
        this.quantitativeUnitNomenclature = quantitativeUnitNomenclature;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal value) {
        this.quantity = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getQuantitativeQuantity() {
        return this.quantitativeQuantity;
    }

    public void setQuantitativeQuantity(BigDecimal quantitativeQuantity) {
        this.quantitativeQuantity = quantitativeQuantity;
    }

    @Override
    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal value) {
        this.unitPrice = BigDecimalUtils.stripTrailingZeros(value);
    }

    @Override
    public BigDecimal getPriceWithoutTax() {
        return this.priceWithoutTax;
    }

    public void setPriceWithoutTax(BigDecimal value) {
        this.priceWithoutTax = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getExciseRate() {
        return this.exciseRate;
    }

    public void setExciseRate(BigDecimal value) {
        this.exciseRate = BigDecimalUtils.stripTrailingZeros(value);
    }

    @Override
    public BigDecimal getExciseAmount() {
        return this.exciseAmount;
    }

    public void setExciseAmount(BigDecimal value) {
        this.exciseAmount = BigDecimalUtils.stripTrailingZeros(value);
    }

    @Override
    public BigDecimal getTurnoverSize() {
        return this.turnoverSize;
    }

    public void setTurnoverSize(BigDecimal value) {
        this.turnoverSize = BigDecimalUtils.stripTrailingZeros(value);
    }

    public Integer getTurnoverAdjustment() {
        return this.turnoverAdjustment;
    }

    public void setTurnoverAdjustment(Integer turnoverAdjustment) {
        this.turnoverAdjustment = turnoverAdjustment;
    }

    @Override
    public Integer getNdsRate() {
        return this.ndsRate;
    }

    public void setNdsRate(Integer value) {
        this.ndsRate = value;
    }

    @Override
    public BigDecimal getNdsAmount() {
        return this.ndsAmount;
    }

    public void setNdsAmount(BigDecimal value) {
        this.ndsAmount = BigDecimalUtils.stripTrailingZeros(value);
    }

    @Override
    public BigDecimal getPriceWithTax() {
        return this.priceWithTax;
    }

    public void setPriceWithTax(BigDecimal value) {
        this.priceWithTax = BigDecimalUtils.stripTrailingZeros(value);
    }

    public String getAdditional() {
        return this.additional;
    }

    public void setAdditional(String value) {
        this.additional = value;
    }

    public String getAdditionalUnitNomenclature() {
        return this.additionalUnitNomenclature;
    }

    public void setAdditionalUnitNomenclature(String additionalUnitNomenclature) {
        this.additionalUnitNomenclature = additionalUnitNomenclature;
    }

    public String getTruOriginCode() {
        return this.truOriginCode;
    }

    public void setTruOriginCode(String truOriginCode) {
        this.truOriginCode = truOriginCode;
    }

    public String getProductDeclaration() {
        return this.productDeclaration;
    }

    public void setProductDeclaration(String productDeclaration) {
        this.productDeclaration = productDeclaration;
    }

    public String getProductNumberInDeclaration() {
        return this.productNumberInDeclaration;
    }

    public void setProductNumberInDeclaration(String productNumberInDeclaration) {
        this.productNumberInDeclaration = productNumberInDeclaration;
    }

    @Override
    public String getCatalogTruId() {
        return this.catalogTruId;
    }

    public void setCatalogTruId(String catalogTruId) {
        this.catalogTruId = catalogTruId;
    }

    @Override
    public boolean isService() {
        return "6".equalsIgnoreCase(this.truOriginCode);
    }

    public String toString() {
        return "ProductV2{truOriginCode='" + this.truOriginCode + '\'' + ", description='" + this.description + '\'' + ", tnvedName='" + this.tnvedName + '\'' + ", unitCode='" + this.unitCode + '\'' + ", unitNomenclature='" + this.unitNomenclature + '\'' + ", quantity=" + this.quantity + ", quantitativeUnitNomenclature=" + this.quantitativeUnitNomenclature + ", quantitativeQuantity=" + this.quantitativeQuantity + ", unitPrice=" + this.unitPrice + ", priceWithoutTax=" + this.priceWithoutTax + ", exciseRate=" + this.exciseRate + ", exciseAmount=" + this.exciseAmount + ", turnoverSize=" + this.turnoverSize + ", ndsRate=" + this.ndsRate + ", ndsAmount=" + this.ndsAmount + ", priceWithTax=" + this.priceWithTax + ", productDeclaration='" + this.productDeclaration + '\'' + ", productNumberInDeclaration='" + this.productNumberInDeclaration + '\'' + ", catalogTruId='" + this.catalogTruId + '\'' + ", additional='" + this.additional + '\'' + ", kpvedCode='" + this.kpvedCode + '\'' + ", moveable=" + this.moveable + ", gsvsActualityDate=" + this.gsvsActualityDate + '}';
    }
}

