/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.registration;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.Documentation;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.esf.model.JsonViews;
import ru.uss.esf.model.dictionary.Taxpayer;
import ru.uss.esf.model.registration.ProjectContract;
import ru.uss.esf.model.registration.ProjectParticipant;
import ru.uss.esf.model.registration.ProjectParticipantType;
import ru.uss.esf.model.registration.ProjectStatus;
import ru.uss.esf.model.registration.ProjectType;
import ru.uss.esf.model.registration.SignData;

public class Project
implements Serializable {
    @JsonView(value={JsonViews.Project.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @Documentation(value="\u041f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447")
    private Long id;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @Documentation(value="\u041a\u043e\u0434 \u043f\u0440\u043e\u0435\u043a\u0442\u0430, \u0445\u0440\u0430\u043d\u044f\u0442\u0441\u044f \u0440\u0430\u0437\u043b\u0438\u0447\u043d\u044b\u0435 \u0432\u0435\u0440\u0441\u0438\u0438 \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432, \u043f\u043e \u043a\u043e\u0434\u0443 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0435\u0441\u044c \u043d\u0430\u0431\u043e\u0440 \u044d\u0442\u0438\u0445 \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432")
    private Long code;
    @JsonView(value={JsonViews.Project.class})
    @Documentation(value="\u0412\u0435\u0440\u0441\u0438\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private int version = 1;
    @JsonView(value={JsonViews.Project.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private Date startDate;
    @JsonView(value={JsonViews.Project.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private Date endDate;
    @JsonView(value={JsonViews.Project.class})
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private String name;
    @JsonView(value={JsonViews.Project.class})
    @Documentation(value="\u0422\u0438\u043f \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private ProjectType type;
    @JsonView(value={JsonViews.Project.class})
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private ProjectStatus status;
    @JsonView(value={JsonViews.Project.class})
    @Documentation(value="\u0422\u0418\u041d \u0438\u043d\u0438\u0446\u0438\u0430\u0442\u043e\u0440\u0430 \u043f\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private String initiator;
    @JsonView(value={JsonViews.Project.class})
    @Documentation(value="\u0414\u0435\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0438, \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0435 \u0438\u0437 \u0415\u0425\u0414")
    private Taxpayer initiatorTaxpayer;
    @JsonView(value={JsonViews.Project.class})
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0435 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 JSON, \u0438\u0441\u043a\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432\u0441\u0435\u043c\u0438 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430\u043c\u0438 \u043f\u0440\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0438 (\u042d\u0426\u041f)")
    private String signData;
    @JsonView(value={JsonViews.Project.class})
    @Documentation(value="\u0418\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440 \u0447\u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u043e \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0443 \u0421\u0420\u041f")
    private boolean checkShareParticipant;
    @JsonView(value={JsonViews.Project.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy HH:mm:ss.SSS")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430")
    private Date inputDate = new Date();
    @JsonView(value={JsonViews.Project.class})
    @Documentation(value="\u0421\u043f\u0438\u0441\u043e\u043a \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u043e\u0432")
    private List<ProjectParticipant> participants = new ArrayList<ProjectParticipant>();
    @JsonView(value={JsonViews.Project.class})
    @Documentation(value="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432")
    private List<ProjectContract> contracts = new ArrayList<ProjectContract>();

    public Project() {
    }

    public Project(Long id, Long code, Date startDate, Date endDate, String name, ProjectType type, ProjectStatus status, String initiator, String signData, boolean checkShareParticipant) {
        this.id = id;
        this.code = code;
        this.startDate = startDate;
        this.endDate = endDate;
        this.name = name;
        this.type = type;
        this.status = status;
        this.initiator = initiator;
        this.signData = signData;
        this.checkShareParticipant = checkShareParticipant;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isNew() {
        return this.id == null;
    }

    @JsonView(value={JsonViews.Project.class})
    public String getDescription() {
        return this.name + " (v" + this.version + ")";
    }

    public Long getCode() {
        return this.code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isExpired() {
        Date today = DateTimeUtils.today();
        return this.endDate != null && (today.equals(this.endDate) || today.after(this.endDate));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProjectType getType() {
        return this.type;
    }

    public void setType(ProjectType type) {
        this.type = type;
    }

    public ProjectStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProjectStatus status) {
        this.status = status;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public Taxpayer getInitiatorTaxpayer() {
        return this.initiatorTaxpayer;
    }

    public void setInitiatorTaxpayer(Taxpayer initiatorTaxpayer) {
        this.initiatorTaxpayer = initiatorTaxpayer;
    }

    public String getSignData() {
        return this.signData;
    }

    public void setSignData(String signData) {
        this.signData = signData;
    }

    public boolean isCheckShareParticipant() {
        return this.checkShareParticipant;
    }

    public void setCheckShareParticipant(boolean checkShareParticipant) {
        this.checkShareParticipant = checkShareParticipant;
    }

    public Date getInputDate() {
        return this.inputDate;
    }

    public void setInputDate(Date inputDate) {
        this.inputDate = inputDate;
    }

    public List<ProjectParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<ProjectParticipant> participants) {
        this.participants = participants;
    }

    public void addParticipant(ProjectParticipant participant) {
        this.participants.add(participant);
    }

    public void changeParticipants(ProjectParticipant manager, List<ProjectParticipant> owners) {
        Assert.notEmpty(owners);
        this.participants.clear();
        this.addParticipant(manager != null ? manager : this.findManager());
        owners.forEach(p -> this.addParticipant(ProjectParticipant.newVersion(p)));
    }

    public List<ProjectContract> getContracts() {
        return this.contracts;
    }

    public void setContracts(List<ProjectContract> contracts) {
        this.contracts = contracts;
    }

    public void addContract(ProjectContract contract) {
        this.contracts.add(contract);
    }

    public void changeContracts(List<ProjectContract> contracts) {
        Assert.notEmpty(contracts);
        this.contracts.clear();
        contracts.forEach(\u0441 -> this.addContract(ProjectContract.newVersion(\u0441)));
        for (ProjectContract contract : contracts) {
            if (!contract.isMain()) continue;
            this.setName(contract.resolveName());
            return;
        }
    }

    public void clearActivationSings() {
        this.participants.forEach(participant -> participant.setActivationSign(new SignData()));
    }

    public void clearTerminationSings() {
        this.participants.forEach(participant -> participant.setTerminationSign(new SignData()));
    }

    @JsonIgnore
    public boolean isActivationAllSigned() {
        return this.participants.stream().allMatch(p -> p.getActivationSign().isValid());
    }

    @JsonIgnore
    public boolean isTerminationAllSigned() {
        return this.participants.stream().allMatch(p -> p.getTerminationSign().isValid());
    }

    @JsonIgnore
    public ProjectParticipant getAttorney() {
        return this.findAttorney(false);
    }

    private ProjectParticipant findAttorney(boolean required) {
        List<ProjectParticipant> participants = this.findParticipants(ProjectParticipant::isAttorney);
        if (required) {
            Assert.isTrue(participants.size() == 1);
        }
        return participants.size() == 1 ? participants.get(0) : null;
    }

    @JsonIgnore
    public ProjectParticipant getTruster() {
        return this.findTruster(false);
    }

    private ProjectParticipant findTruster(boolean required) {
        List<ProjectParticipant> participants = this.findParticipants(ProjectParticipant::isTruster);
        if (required) {
            Assert.isTrue(participants.size() == 1);
        }
        return participants.size() == 1 ? participants.get(0) : null;
    }

    @JsonIgnore
    public ProjectParticipant getOperator() {
        return this.findOperator(false);
    }

    private ProjectParticipant findOperator(boolean required) {
        List<ProjectParticipant> participants = this.findParticipants(ProjectParticipant::isOperator);
        if (required) {
            Assert.isTrue(participants.size() == 1);
        }
        return participants.size() == 1 ? participants.get(0) : null;
    }

    @JsonIgnore
    public List<ProjectParticipant> getContractors() {
        return this.findParticipants(ProjectParticipant::isContractor);
    }

    public List<ProjectParticipant> getOrderedParticipants() {
        ArrayList<ProjectParticipant> result = new ArrayList<ProjectParticipant>();
        if (this.type == ProjectType.ATTORNEY_TRUSTER) {
            result.add(this.findAttorney(true));
            result.add(this.findTruster(true));
        } else if (this.type == ProjectType.OPERATOR_CONTRACTOR) {
            result.add(this.findOperator(true));
            result.addAll(this.getContractors());
        }
        return result;
    }

    @JsonView(value={JsonViews.Project.class})
    public List<ProjectParticipant> getManagers() {
        return this.findParticipants(ProjectParticipant::isManager);
    }

    @JsonView(value={JsonViews.Project.class})
    public List<ProjectParticipant> getOwners() {
        return this.findParticipants(ProjectParticipant::isOwner);
    }

    public ProjectParticipant findParticipant(String tin) {
        if (tin != null) {
            for (ProjectParticipant participant : this.participants) {
                if (!tin.equals(participant.getTin())) continue;
                return participant;
            }
        }
        return null;
    }

    public ProjectParticipant findManager() {
        List<ProjectParticipant> managers = this.getManagers();
        return managers != null && !managers.isEmpty() ? managers.get(0) : null;
    }

    public ProjectParticipant findOwner(String tin) {
        if (tin != null) {
            for (ProjectParticipant participant : this.participants) {
                if (!tin.equals(participant.getTin()) || !participant.isOwner()) continue;
                return participant;
            }
        }
        return null;
    }

    private List<ProjectParticipant> findParticipants(Predicate<ProjectParticipant> predicate) {
        return this.participants.stream().filter(predicate).collect(Collectors.toList());
    }

    public boolean checkType(ProjectType type) {
        return this.getType() == type;
    }

    public boolean isActive() {
        return this.status == ProjectStatus.ACTIVE;
    }

    public boolean isNotActive() {
        return !this.isActive();
    }

    public boolean checkStatus(ProjectStatus ... statuses) {
        for (ProjectStatus status : statuses) {
            if (this.getStatus() != status) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public String getDeltaParticipantTin() {
        return this.participants.stream().filter(p -> BooleanUtils.isTrue(p.getHasDelta())).map(ProjectParticipant::getTin).findFirst().orElse(null);
    }

    public static Project newAttorneyTruster(Long id, Long code, Date endDate, String name, String attorneyTin, String trusterTin, String singData, boolean checkShareParticipant, List<ProjectContract> contracts) {
        Project project = new Project(id, code, null, endDate, name, ProjectType.ATTORNEY_TRUSTER, ProjectStatus.DRAFT, attorneyTin, singData, checkShareParticipant);
        project.addParticipant(ProjectParticipant.newAttorney(attorneyTin));
        project.addParticipant(ProjectParticipant.newTruster(trusterTin));
        if (contracts != null) {
            project.getContracts().addAll(contracts);
        }
        return project;
    }

    public static Project newOperatorContractor(Long id, Long code, Date endDate, String name, String operatorTin, String singData, boolean checkShareParticipant, List<ProjectParticipant> contractors, List<ProjectContract> contracts) {
        Project project = new Project(id, code, null, endDate, name, ProjectType.OPERATOR_CONTRACTOR, ProjectStatus.DRAFT, operatorTin, singData, checkShareParticipant);
        contractors.forEach(participant -> participant.setType(ProjectParticipantType.CONTRACTOR));
        project.changeParticipants(ProjectParticipant.newOperator(operatorTin), contractors);
        if (contracts != null) {
            project.getContracts().addAll(contracts);
        }
        return project;
    }

    public static Project newVersion(Project project, String initiatorTin) {
        Project result = new Project();
        BeanUtils.copyProperties((Object)project, (Object)result, "id", "participants", "contracts");
        for (ProjectParticipant participant : project.getParticipants()) {
            result.addParticipant(ProjectParticipant.newVersion(participant));
        }
        for (ProjectContract contract : project.getContracts()) {
            result.addContract(ProjectContract.newVersion(contract));
        }
        result.setInputDate(new Date());
        result.setVersion(result.getVersion() + 1);
        result.setInitiator(initiatorTin);
        return result;
    }

    public static String description(String enterpriseName, String projectName, String projectType) {
        return String.format("%s %s(%s)", enterpriseName, Project.description(projectName), projectType);
    }

    static String description(String projectName) {
        if (projectName == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(projectName);
        int index = projectName.lastIndexOf("(");
        if (index != -1) {
            builder.insert(index, ")");
            builder.insert(0, "(");
        }
        return builder.toString();
    }

    public String toString() {
        return "Project{id=" + this.id + ", code=" + this.code + ", version=" + this.version + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", status=" + (Object)((Object)this.status) + ", initiator='" + this.initiator + '\'' + ", initiatorTaxpayer=" + this.initiatorTaxpayer + ", signData='" + this.signData + '\'' + ", checkShareParticipant=" + this.checkShareParticipant + ", inputDate=" + this.inputDate + ", participants=" + this.participants + ", contracts=" + this.contracts + '}';
    }
}

