/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.registration;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import org.springframework.beans.BeanUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.esf.model.JsonViews;
import ru.uss.esf.model.registration.AgreementType;
import ru.uss.esf.model.registration.ProjectContractType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectContract
implements Serializable {
    @JsonIgnore
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private Long projectId;
    @JsonView(value={JsonViews.Contract.class})
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430/\u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f")
    @NotNull(message="{contract.num.notNull}")
    private @NotNull(message="{contract.num.notNull}") String num;
    @JsonView(value={JsonViews.Contract.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430/\u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f")
    @NotNull(message="{contract.startDate.notNull}")
    private @NotNull(message="{contract.startDate.notNull}") Date startDate;
    @JsonView(value={JsonViews.Contract.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0440\u0430\u0441\u0442\u043e\u0440\u0436\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430/\u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f")
    private Date endDate;
    @JsonView(value={JsonViews.Contract.class})
    @Documentation(value="\u0418\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440 \u0447\u0442\u043e \u044d\u0442\u043e \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440/\u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430, \u0434\u0430\u043d\u043d\u044b\u0435 \u044d\u0442\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0431\u0443\u0434\u0443\u0442 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u0441\u044f \u0432 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0435\u043a\u0442\u0435, \u0430 \u0442\u0430\u043a \u0436\u0435 \u043f\u0440\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u042d\u0421\u0424")
    private boolean main;
    @JsonView(value={JsonViews.Contract.class})
    @Documentation(value="\u0422\u0438\u043f \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f")
    @NotNull(message="{contract.agreementType.notNull}")
    private @NotNull(message="{contract.agreementType.notNull}") AgreementType agreementType;
    @JsonView(value={JsonViews.Contract.class})
    @Documentation(value="\u0422\u0438\u043f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    @NotNull(message="{contract.contractType.notNull}")
    private @NotNull(message="{contract.contractType.notNull}") ProjectContractType contractType;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy HH:mm:ss.SSS")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430")
    private Date inputDate = new Date();

    public ProjectContract() {
    }

    public ProjectContract(String num, Date startDate, Date endDate, boolean main, AgreementType agreementType, ProjectContractType contractType) {
        this.num = num;
        this.startDate = startDate;
        this.endDate = endDate;
        this.main = main;
        this.agreementType = agreementType;
        this.contractType = contractType;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getNum() {
        return this.num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isMain() {
        return this.main;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    public AgreementType getAgreementType() {
        return this.agreementType;
    }

    public void setAgreementType(AgreementType agreementType) {
        this.agreementType = agreementType;
    }

    public ProjectContractType getContractType() {
        return this.contractType;
    }

    public void setContractType(ProjectContractType contractType) {
        this.contractType = contractType;
    }

    public Date getInputDate() {
        return this.inputDate;
    }

    public void setInputDate(Date inputDate) {
        this.inputDate = inputDate;
    }

    public String resolveName() {
        StringBuilder builder = new StringBuilder();
        if (this.getNum() != null) {
            builder.append(this.getNum());
            if (this.getStartDate() != null) {
                builder.append("(").append(DateTimeUtils.getStringDate(this.getStartDate())).append(")");
            }
        } else {
            builder.append("\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e");
        }
        return builder.toString();
    }

    public static ProjectContract newVersion(ProjectContract contract) {
        ProjectContract result = new ProjectContract();
        BeanUtils.copyProperties((Object)contract, (Object)result, "projectId");
        return result;
    }
}

