/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.registration;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.Documentation;
import org.springframework.util.StringUtils;
import ru.uss.esf.model.JsonViews;

public class SignData
implements Serializable {
    public static final String FAKE_HASH = "Fake hash";
    public static final String FAKE_SIGNATURE = "Fake signature";
    public static final String FAKE_CERTIFICATE = "Fake certificate";
    @JsonView(value={JsonViews.SignedData.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy HH:mm:ss.SSS")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f")
    private Date date;
    @JsonView(value={JsonViews.SignedData.class})
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u044b\u043b\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u044b")
    private String data;
    @JsonView(value={JsonViews.SignedData.class})
    @Documentation(value="\u041f\u043e\u0434\u043f\u0438\u0441\u044c \u042d\u0426\u041f")
    private String signature;
    @JsonView(value={JsonViews.SignedData.class})
    @Documentation(value="\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442")
    private String certificate;

    public SignData() {
    }

    public SignData(Date date, String data, String signature, String certificate) {
        this.date = date;
        this.data = data;
        this.signature = signature;
        this.certificate = certificate;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    @JsonIgnore
    public boolean isValid() {
        return StringUtils.hasLength(this.data) && StringUtils.hasLength(this.signature) && StringUtils.hasLength(this.certificate);
    }

    public static SignData valueOf(String hash, String signature, String certificate) {
        return new SignData(new Date(), hash, signature, certificate);
    }

    public static SignData fake() {
        return SignData.valueOf(FAKE_HASH, FAKE_SIGNATURE, FAKE_CERTIFICATE);
    }
}

