/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="SntAttachedFileType")
@Documentation(value="\u0422\u0438\u043f \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u044f\u0435\u043c\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430")
public enum SntAttachedFileType {
    PDF("application/pdf"),
    PNG("image/png"),
    JPG("image/jpeg"),
    RAR("application/x-rar-compressed"),
    ZIP("application/zip");

    private String mimeType;

    private SntAttachedFileType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public List<String> getMimeTypes() {
        return Arrays.stream(SntAttachedFileType.values()).map(SntAttachedFileType::getMimeType).collect(Collectors.toList());
    }

    public static SntAttachedFileType getByMimeType(String aMimeType) {
        Optional<SntAttachedFileType> sntAttachedFileTypeOptional = Arrays.stream(SntAttachedFileType.values()).filter(p -> p.mimeType.equals(aMimeType)).findFirst();
        return sntAttachedFileTypeOptional.orElse(null);
    }
}

