/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.snt.SntValidationGroups;
import ru.uss.esf.model.snt.version.v1.SntAlcoholExceptBeerProductV1;
import ru.uss.esf.model.snt.version.v1.SntBaseProductSetV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SntAlcoholExceptBeerProductSet")
@Documentation(value="\u0410\u043b\u043a\u043e\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u044f (\u043a\u0440\u043e\u043c\u0435 \u043f\u0438\u0432\u0430 \u0438 \u043f\u0438\u0432\u043d\u043e\u0433\u043e \u043d\u0430\u043f\u0438\u0442\u043a\u0430) (G5)")
public class SntAlcoholExceptBeerProductSetV1
extends SntBaseProductSetV1 {
    @XmlTransient
    public static final String OPERATION_CODE_BAIKONUR_SHIPPING_EXCEPT_BEER = "15";
    @XmlTransient
    public static final String OPERATION_CODE_FINAL_END_USER = "48";
    @XmlTransient
    public static final String OPERATION_CODE_WHOLESALER_RETAIL_SHIPMENT = "7";
    @XmlTransient
    public static final String OPERATION_CODE_MANUFACTURER_RETAIL_SHIPMENT = "10";
    @Pattern(regexp="5|6|7|8|9|10|11|15|48", message="{sntAlcoholExceptBeerProductSetV1.operationCode.pattern}", groups={SntValidationGroups.PrimarySnt.class, SntValidationGroups.FixedSnt.class, SntValidationGroups.ReturnedSnt.class})
    @RequiredString(required=false, minLen=1, maxLen=2, fieldPath="sntAlcoholExceptBeerProductSetV1.operationCode", groups={SntValidationGroups.ReturnedSnt.class})
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 (G5 62)")
    private @Pattern(regexp="5|6|7|8|9|10|11|15|48", message="{sntAlcoholExceptBeerProductSetV1.operationCode.pattern}", groups={SntValidationGroups.PrimarySnt.class, SntValidationGroups.FixedSnt.class, SntValidationGroups.ReturnedSnt.class}) String operationCode;
    @Valid
    @XmlElementWrapper(name="products", required=true)
    @XmlElement(name="product", required=true)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0410\u043b\u043a\u043e\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u044f (\u043a\u0440\u043e\u043c\u0435 \u043f\u0438\u0432\u0430 \u0438 \u043f\u0438\u0432\u043d\u043e\u0433\u043e \u043d\u0430\u043f\u0438\u0442\u043a\u0430) (G5)")
    private List<SntAlcoholExceptBeerProductV1> products;

    @Override
    public String getOperationCode() {
        return this.operationCode;
    }

    public void setOperationCode(String operationCode) {
        this.operationCode = operationCode;
    }

    public List<SntAlcoholExceptBeerProductV1> getProducts() {
        return this.products;
    }

    public void setProducts(List<SntAlcoholExceptBeerProductV1> products) {
        this.products = products;
    }

    @Override
    public boolean isBaikonurShipping() {
        return OPERATION_CODE_BAIKONUR_SHIPPING_EXCEPT_BEER.equals(this.getOperationCode());
    }

    @Override
    public boolean isFinalUser() {
        return OPERATION_CODE_FINAL_END_USER.equals(this.getOperationCode());
    }

    @Override
    public boolean isExciseProducts() {
        return true;
    }

    @Override
    public SntProductTypeV1 getSntProductType() {
        return SntProductTypeV1.ALCOHOL_EXCEPT_BEER;
    }
}

