/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.math.BigDecimal;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.BigDecimalCheck;
import ru.uss.core.validation.common.Gtin;
import ru.uss.core.validation.common.PositiveNumber;
import ru.uss.core.validation.common.PositiveOrZero;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.validation.common.clazz.MultiplicationOf;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldExists;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;

@MultiplicationOf.List(value={@MultiplicationOf(multiplyFields={"containerCapacity", "containerCount"}, scale="6", resultField="quantityInLiters", message="{sntAlcoholExceptBeerProductV1.quantityInLiters.incorrect}")})
@NotEmptyIfTargetFieldExists.List(value={@NotEmptyIfTargetFieldExists(field="productionType", targetField="pinCode", message="{sntV1.productionType.notNull}"), @NotEmptyIfTargetFieldExists(field="containerCapacity", targetField="pinCode", message="{sntV1.containerCapacity.notNull}"), @NotEmptyIfTargetFieldExists(field="quantityInLiters", targetField="pinCode", message="{sntV1.quantityInLiters.notNull}")})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SntAlcoholExceptBeerProduct")
@Documentation(value="\u0410\u043b\u043a\u043e\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u044f (\u043a\u0440\u043e\u043c\u0435 \u043f\u0438\u0432\u0430 \u0438 \u043f\u0438\u0432\u043d\u043e\u0433\u043e \u043d\u0430\u043f\u0438\u0442\u043a\u0430) (G5)")
public class SntAlcoholExceptBeerProductV1
extends SntBaseProductV1 {
    @ExactDigitsCount(count=12, message="{sntAlcoholExceptBeerProductV1.pinCode.wrongFormat}")
    @RequiredString(required=false, minLen=12, maxLen=12, fieldPath="sntAlcoholExceptBeerProductV1.pinCode")
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u041f\u0418\u041d-\u043a\u043e\u0434 (G5 3)")
    private String pinCode;
    @RequiredString(required=true, minLen=1, maxLen=450, fieldPath="sntAlcoholExceptBeerProductV1.productName")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430 (G5 4)")
    private String productName;
    @RequiredString(required=false, minLen=1, maxLen=450, fieldPath="sntAlcoholExceptBeerProductV1.productionType")
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0412\u0438\u0434 \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u0438 (G5 6)")
    private String productionType;
    @PositiveNumber(fieldPath="sntAlcoholExceptBeerProductV1.containerCapacity")
    @BigDecimalCheck(nullable=true, maxLeftLen=12, maxRightLen=6, fieldPath="sntAlcoholExceptBeerProductV1.containerCapacity")
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0415\u043c\u043a\u043e\u0441\u0442\u044c \u0442\u0430\u0440\u044b (\u0432 \u043b\u0438\u0442\u0440\u0430\u0445) (G5 7)")
    private BigDecimal containerCapacity;
    @PositiveNumber(fieldPath="sntAlcoholExceptBeerProductV1.containerCount")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=0, fieldPath="sntAlcoholExceptBeerProductV1.containerCount")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e (\u0431\u0443\u0442\u044b\u043b\u043e\u043a, \u0431\u0430\u043d\u043e\u043a) (G5 8)")
    private BigDecimal containerCount;
    @PositiveNumber(fieldPath="sntAlcoholExceptBeerProductV1.quantityInLiters")
    @BigDecimalCheck(nullable=true, maxLeftLen=12, maxRightLen=6, fieldPath="sntAlcoholExceptBeerProductV1.quantityInLiters")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e (\u0432 \u043b\u0438\u0442\u0440\u0430\u0445) (G5 9)")
    private BigDecimal quantityInLiters;
    @PositiveOrZero(fieldPath="sntAlcoholExceptBeerProductV1.price")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=3, fieldPath="sntAlcoholExceptBeerProductV1.price")
    @XmlElement(required=true)
    @Documentation(value="\u0426\u0435\u043d\u0430 \u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443 \u0442\u043e\u0432\u0430\u0440\u0430 (G5 10)")
    private BigDecimal price;
    @Max(value=100L, message="{sntAlcoholExceptBeerProductV1.spiritPercent.max}")
    @Min(value=0L, message="{sntAlcoholExceptBeerProductV1.spiritPercent.min}")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=2, fieldPath="sntAlcoholExceptBeerProductV1.spiritPercent")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u0440\u0435\u043f\u043e\u0441\u0442\u044c (% \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u044f \u0441\u043f\u0438\u0440\u0442\u0430) (G5 13/1)")
    private @Max(value=100L, message="{sntAlcoholExceptBeerProductV1.spiritPercent.max}") @Min(value=0L, message="{sntAlcoholExceptBeerProductV1.spiritPercent.min}") BigDecimal spiritPercent;
    @Gtin
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u041a\u043e\u0434 \u0442\u043e\u0432\u0430\u0440\u0430 (GTIN) (G5 18)")
    private String gtinCode;

    @Override
    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    @Override
    public String getMeasureUnitCode() {
        return "868";
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getMatchingMeasureUnitCode() {
        return "868";
    }

    @Override
    public BigDecimal getMatchingQuantity() {
        return this.containerCount;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantityInLiters;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductionType() {
        return this.productionType;
    }

    public void setProductionType(String productionType) {
        this.productionType = productionType;
    }

    public BigDecimal getContainerCapacity() {
        return this.containerCapacity;
    }

    public void setContainerCapacity(BigDecimal containerCapacity) {
        this.containerCapacity = containerCapacity;
    }

    public BigDecimal getContainerCount() {
        return this.containerCount;
    }

    public void setContainerCount(BigDecimal containerCount) {
        this.containerCount = containerCount;
    }

    public BigDecimal getQuantityInLiters() {
        return this.quantityInLiters;
    }

    public void setQuantityInLiters(BigDecimal quantityInLiters) {
        this.quantityInLiters = quantityInLiters;
    }

    @Override
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Override
    public BigDecimal getSpiritPercent() {
        return this.spiritPercent;
    }

    public void setSpiritPercent(BigDecimal spiritPercent) {
        this.spiritPercent = spiritPercent;
    }

    @Override
    public String getMarkingCode() {
        return this.gtinCode;
    }

    public String getGtinCode() {
        return this.gtinCode;
    }

    public void setGtinCode(String gtinCode) {
        this.gtinCode = gtinCode;
    }

    @Override
    public SntProductTypeV1 getSntProductType() {
        return SntProductTypeV1.ALCOHOL_EXCEPT_BEER;
    }

    @Override
    public BigDecimal getQuantityToStore() {
        return this.getContainerCount();
    }

    @Override
    public BigDecimal getCertQuantity() {
        return this.containerCount;
    }
}

