/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.adapter.BooleanAdapter;
import ru.uss.core.validation.common.NotAllowedValues;
import ru.uss.core.validation.common.NumberCheck;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.esf.model.snt.SntValidationGroups;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractParticipant;
import ru.uss.esf.model.snt.version.v1.SntCustomerTypeV1;
import ru.uss.esf.validation.snt.ImmutableForFixedSnt;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;
import ru.uss.esf.validation.snt.version.v1.SntCustomerRegisterCountryCodeCheckV1;

@SntCustomerRegisterCountryCodeCheckV1
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SntCustomer")
@Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f (C)")
public class SntCustomerV1
extends SntAbstractParticipant {
    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    @XmlElement(required=false)
    @Documentation(value="\u041d\u0435\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442 (C 22.1)")
    @ImmutableForReturnedSnt
    @ImmutableForFixedSnt
    private Boolean nonResident = Boolean.FALSE;
    @RequiredString(required=false, minLen=12, maxLen=12, fieldPath="sntCustomerV1.tin")
    @XmlElement(required=false)
    @Documentation(value="\u0411\u0418\u041d \u0440\u0435\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 (C 25)")
    private String reorganizedTin;
    @XmlElementWrapper(name="statuses")
    @XmlElement(name="status", required=false)
    @Documentation(value="\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f (C 26)")
    @ImmutableForReturnedSnt
    @ImmutableForFixedSnt
    private List<SntCustomerTypeV1> statuses;
    @RequiredString(required=true, minLen=2, maxLen=2, fieldPath="sntCustomerV1.registerCountryCode")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f (C 27)")
    @ImmutableForReturnedSnt
    @NotAllowedValues(values={"00"}, groups={SntValidationGroups.PrimarySnt.class})
    private String registerCountryCode;
    @RequiredString(required=true, minLen=2, maxLen=2, fieldPath="sntCustomerV1.countryCode")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438/\u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438 (C 28)")
    @ImmutableForReturnedSnt
    @NotAllowedValues(values={"00"}, groups={SntValidationGroups.PrimarySnt.class})
    private String countryCode;
    @RequiredString(required=false, minLen=3, maxLen=450, fieldPath="sntCustomerV1.actualAddress")
    @XmlElement(required=false)
    @Documentation(value="\u0424\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438/\u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438 (C 29)")
    private String actualAddress;
    @NumberCheck(nullable=true, minDigitCount=1, maxDigitCount=10, fieldPath="sntCustomerV1.storeId")
    @XmlElement(required=false)
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043a\u043b\u0430\u0434\u0430 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438/\u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438 (C 30)")
    private Long storeId;
    @XmlTransient
    @Documentation(value="\u041a\u043e\u0434 \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f")
    private Long projectCode;
    @XmlTransient
    @Documentation(value="\u041a\u041e\u0413\u0414")
    private String kogd;
    @XmlTransient
    @Documentation(value="\u0421\u043f\u0438\u0441\u043e\u043a \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u043e\u0432 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private List<String> projectParticipantTinList;

    @Override
    @RequiredString(required=false, minLen=12, maxLen=12, fieldPath="sntCustomerV1.branchTin")
    public String getBranchTin() {
        return super.getBranchTin();
    }

    @Override
    @RequiredString(required=true, minLen=3, maxLen=450, fieldPath="sntCustomerV1.name")
    public String getName() {
        return super.getName();
    }

    public Boolean getNonResident() {
        return this.nonResident;
    }

    public void setNonResident(Boolean nonResident) {
        this.nonResident = nonResident;
    }

    public String getReorganizedTin() {
        return this.reorganizedTin;
    }

    public void setReorganizedTin(String reorganizedTin) {
        this.reorganizedTin = reorganizedTin;
    }

    public List<SntCustomerTypeV1> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<SntCustomerTypeV1> statuses) {
        this.statuses = statuses;
    }

    public String getRegisterCountryCode() {
        return this.registerCountryCode;
    }

    public void setRegisterCountryCode(String registerCountryCode) {
        this.registerCountryCode = registerCountryCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getActualAddress() {
        return this.actualAddress;
    }

    public void setActualAddress(String actualAddress) {
        this.actualAddress = actualAddress;
    }

    public Long getStoreId() {
        return this.storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public Long getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(Long projectCode) {
        this.projectCode = projectCode;
    }

    public String getKogd() {
        return this.kogd;
    }

    public void setKogd(String kogd) {
        this.kogd = kogd;
    }

    public List<String> getProjectParticipantTinList() {
        return this.projectParticipantTinList;
    }

    public void setProjectParticipantTinList(List<String> projectParticipantTinList) {
        this.projectParticipantTinList = projectParticipantTinList;
    }

    public boolean isRetail() {
        return this.containsCategory(SntCustomerTypeV1.RETAIL);
    }

    public boolean isRetailer() {
        return this.containsCategory(SntCustomerTypeV1.RETAILER);
    }

    public boolean isIndividual() {
        return this.containsCategory(SntCustomerTypeV1.INDIVIDUAL);
    }

    public boolean isPharmaceuticProducer() {
        return this.containsCategory(SntCustomerTypeV1.PHARMACEUTIC_PRODUCER);
    }

    public boolean isLessor() {
        return this.containsCategory(SntCustomerTypeV1.LESSOR);
    }

    public boolean isLessee() {
        return this.containsCategory(SntCustomerTypeV1.LESSEE);
    }

    public boolean isPrincipal() {
        return this.containsCategory(SntCustomerTypeV1.PRINCIPAL);
    }

    public boolean isBroker() {
        return this.containsCategory(SntCustomerTypeV1.BROKER);
    }

    public boolean isCommittent() {
        return this.containsCategory(SntCustomerTypeV1.COMMITTENT);
    }

    public boolean isSmallRetailOutlet() {
        return this.containsCategory(SntCustomerTypeV1.SMALL_RETAIL_OUTLET);
    }

    public boolean isProjectParticipant() {
        return this.isJointActivityParticipant() || this.isPrincipal() || this.isSharingAgreementParticipant();
    }

    public boolean containsCategory(SntCustomerTypeV1 type) {
        return this.statuses != null && this.statuses.stream().anyMatch(status -> Objects.equals(type, status));
    }

    public boolean isPawneeCustodian() {
        return this.containsCategory(SntCustomerTypeV1.PAWNEE_CUSTODIAN);
    }

    public DocumentParticipantType getParticipantType() {
        boolean useDefaultParticipantType = this.statuses == null || this.statuses.isEmpty() || !this.statuses.stream().filter(status -> status.hasPredefinedParticipantType()).findAny().isPresent();
        if (useDefaultParticipantType |= this.statuses != null && this.statuses.contains(SntCustomerTypeV1.RETAIL) && !this.statuses.contains(SntCustomerTypeV1.INDIVIDUAL) && StringUtils.isNotBlank(this.getTin())) {
            return DocumentParticipantType.BUSINESS;
        }
        DocumentParticipantType participantType = null;
        Optional<SntCustomerTypeV1> customerTypeWithPredefinedParticipantType = this.statuses.stream().filter(type -> type.hasPredefinedParticipantType()).findFirst();
        if (customerTypeWithPredefinedParticipantType.isPresent()) {
            participantType = customerTypeWithPredefinedParticipantType.get().getDocumentParticipantType();
        }
        return participantType;
    }

    public boolean isJointActivityParticipant() {
        return this.containsCategory(SntCustomerTypeV1.JOINT_ACTIVITY_PARTICIPANT);
    }

    public boolean isSharingAgreementParticipant() {
        return this.containsCategory(SntCustomerTypeV1.SHARING_AGREEMENT_PARTICIPANT);
    }
}

