/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.math.BigDecimal;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.BigDecimalCheck;
import ru.uss.core.validation.common.Gtin;
import ru.uss.core.validation.common.PositiveNumber;
import ru.uss.core.validation.common.PositiveOrZero;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SntEthanolProduct")
@Documentation(value="\u042d\u0442\u0438\u043b\u043e\u0432\u044b\u0439 \u0441\u043f\u0438\u0440\u0442 (G2)")
public class SntEthanolProductV1
extends SntBaseProductV1 {
    @ExactDigitsCount(count=12, message="{sntEthanolProductV1.pinCode.wrongFormat}")
    @RequiredString(required=false, minLen=12, maxLen=12, fieldPath="sntEthanolProductV1.pinCode")
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u041f\u0418\u041d-\u043a\u043e\u0434 (G2 3)")
    private String pinCode;
    @RequiredString(required=true, minLen=1, maxLen=450, fieldPath="sntEthanolProductV1.productName")
    @XmlElement(required=true)
    @Documentation(value="\u0412\u0438\u0434, \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u044d\u0442\u0438\u043b\u043e\u0432\u043e\u0433\u043e \u0441\u043f\u0438\u0440\u0442\u0430 (G2 4)")
    private String productName;
    @PositiveNumber(fieldPath="sntEthanolProductV1.quantityInLiters")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=6, fieldPath="sntEthanolProductV1.quantityInLiters")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e (\u0432 \u043b\u0438\u0442\u0440\u0430\u0445) (G2 6)")
    private BigDecimal quantityInLiters;
    @PositiveOrZero(fieldPath="sntEthanolProductV1.price")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=3, fieldPath="sntEthanolProductV1.price")
    @XmlElement(required=true)
    @Documentation(value="\u0426\u0435\u043d\u0430 \u0437\u0430 \u043b\u0438\u0442\u0440 (G2 7)")
    private BigDecimal price;
    @Max(value=100L, message="{sntEthanolProductV1.spiritPercent.max}")
    @Min(value=0L, message="{sntEthanolProductV1.spiritPercent.min}")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=2, fieldPath="sntEthanolProductV1.spiritPercent")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u0440\u0435\u043f\u043e\u0441\u0442\u044c (% \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u044f \u0441\u043f\u0438\u0440\u0442\u0430) (G2 9/1)")
    private @Max(value=100L, message="{sntEthanolProductV1.spiritPercent.max}") @Min(value=0L, message="{sntEthanolProductV1.spiritPercent.min}") BigDecimal spiritPercent;
    @Gtin
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u041a\u043e\u0434 \u0442\u043e\u0432\u0430\u0440\u0430 (GTIN) (G2 16)")
    private String gtinCode;

    @Override
    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    @Override
    public String getMeasureUnitCode() {
        return "112";
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantityInLiters;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BigDecimal getQuantityInLiters() {
        return this.quantityInLiters;
    }

    public void setQuantityInLiters(BigDecimal quantityInLiters) {
        this.quantityInLiters = quantityInLiters;
    }

    @Override
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Override
    public BigDecimal getSpiritPercent() {
        return this.spiritPercent;
    }

    public void setSpiritPercent(BigDecimal spiritPercent) {
        this.spiritPercent = spiritPercent;
    }

    @Override
    public String getMarkingCode() {
        return this.gtinCode;
    }

    public String getGtinCode() {
        return this.gtinCode;
    }

    public void setGtinCode(String gtinCode) {
        this.gtinCode = gtinCode;
    }

    @Override
    public SntProductTypeV1 getSntProductType() {
        return SntProductTypeV1.ETHANOL;
    }

    @Override
    public BigDecimal getCertQuantity() {
        return this.quantityInLiters;
    }
}

