/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.IsNull;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.snt.SntValidationGroups;
import ru.uss.esf.model.snt.version.v1.SntBaseProductSetV1;
import ru.uss.esf.model.snt.version.v1.SntOilProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SntOilSet")
@Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u043d\u0435\u0444\u0442\u0435\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430\u043c (G6)")
public class SntOilSetV1
extends SntBaseProductSetV1 {
    @XmlTransient
    public static final String PRODUCT_SELLER_TYPE_FINAL_USER_KZ_MOVEMENT = "6";
    @XmlTransient
    public static final String PRODUCT_SELLER_TYPE_FINAL_USER_KZ_CONSUMPTION_MOVEMENT = "9";
    @XmlTransient
    public static final String SELLER_TYPE_IMPORTER = "4";
    @XmlTransient
    public static final String PRODUCT_SELLER_TYPE_BROKER = "10";
    @XmlTransient
    public static final String OPERATION_CODE_WHOLESALER_CUSTOMER = "20";
    @XmlTransient
    public static final String OPERATION_CODE_RETAIL = "21";
    @XmlTransient
    public static final String OPERATION_CODE_FINAL_END_USER = "22";
    @XmlTransient
    public static final String OPERATION_CODE_BAIKONUR_SHIPPING = "26";
    @XmlTransient
    public static final String OPERATION_CODE_RETAIL_TO_BROKER = "29";
    @XmlTransient
    public static final String WHOLESALER_SELLER_TYPE = "2";
    @IsNull(fieldPath="sntOilSetV1.operationCode", groups={SntValidationGroups.ReturnedSnt.class})
    @Pattern(regexp="19|20|21|22|25|26|28|29", message="{sntOilSetV1.operationCode.pattern}", groups={SntValidationGroups.PrimarySnt.class, SntValidationGroups.FixedSnt.class})
    @RequiredString(required=false, minLen=2, maxLen=2, fieldPath="sntOilSetV1.operationCode", groups={SntValidationGroups.PrimarySnt.class, SntValidationGroups.FixedSnt.class})
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 (G6 64)")
    private @Pattern(regexp="19|20|21|22|25|26|28|29", message="{sntOilSetV1.operationCode.pattern}", groups={SntValidationGroups.PrimarySnt.class, SntValidationGroups.FixedSnt.class}) String operationCode;
    @Pattern.List(value={@Pattern(regexp="1|2|3|4|5|7|8|10", message="{sntOilSetV1.productSellerType.pattern}", groups={SntValidationGroups.ReturnedSnt.class}), @Pattern(regexp="1|2|3|4|5|6|9|10", message="{sntOilSetV1.productSellerType.pattern}", groups={SntValidationGroups.PrimarySnt.class, SntValidationGroups.FixedSnt.class})})
    @RequiredString(required=false, minLen=1, maxLen=2, fieldPath="sntOilSetV1.productSellerType")
    @XmlElement(required=false)
    @Documentation(value="\u0422\u0438\u043f \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 (G6 65)")
    private String productSellerType;
    @RequiredString(required=false, minLen=4, maxLen=4, fieldPath="sntOilSetV1.kogdOfSender")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u041e\u0413\u0414 \u0430\u0434\u0440\u0435\u0441\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438/\u043e\u0442\u0433\u0440\u0443\u0437\u043a\u0438 (G6 66)")
    private String kogdOfSender;
    @RequiredString(required=false, minLen=4, maxLen=4, fieldPath="sntOilSetV1.kogdOfRecipient")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u041e\u0413\u0414 \u0430\u0434\u0440\u0435\u0441\u0430 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438/\u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438 (G6 67)")
    private String kogdOfRecipient;
    @Valid
    @XmlElementWrapper(name="products", required=true)
    @XmlElement(name="product", required=true)
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u043d\u0435\u0444\u0442\u0435\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430\u043c (G6)")
    @ImmutableForReturnedSnt
    private List<SntOilProductV1> products;

    @Override
    public String getOperationCode() {
        return this.operationCode;
    }

    public void setOperationCode(String operationCode) {
        this.operationCode = operationCode;
    }

    public String getProductSellerType() {
        return this.productSellerType;
    }

    public void setProductSellerType(String productSellerType) {
        this.productSellerType = productSellerType;
    }

    public String getKogdOfSender() {
        return this.kogdOfSender;
    }

    public void setKogdOfSender(String kogdOfSender) {
        this.kogdOfSender = kogdOfSender;
    }

    public String getKogdOfRecipient() {
        return this.kogdOfRecipient;
    }

    public void setKogdOfRecipient(String kogdOfRecipient) {
        this.kogdOfRecipient = kogdOfRecipient;
    }

    public List<SntOilProductV1> getProducts() {
        return this.products;
    }

    @Override
    public Boolean getFinalUserFlag() {
        return OPERATION_CODE_FINAL_END_USER.equals(this.operationCode);
    }

    public void setProducts(List<SntOilProductV1> products) {
        this.products = products;
    }

    @Override
    public boolean isBaikonurShipping() {
        return OPERATION_CODE_BAIKONUR_SHIPPING.equals(this.getOperationCode());
    }

    @Override
    public boolean isRetail() {
        return OPERATION_CODE_RETAIL.equals(this.getOperationCode());
    }

    @Override
    public boolean isFinalUser() {
        return OPERATION_CODE_FINAL_END_USER.equals(this.getOperationCode());
    }

    @Override
    public boolean isExciseProducts() {
        return true;
    }

    @Override
    public SntProductTypeV1 getSntProductType() {
        return SntProductTypeV1.OIL;
    }

    @Override
    public boolean isFinalUserKzMovement() {
        return PRODUCT_SELLER_TYPE_FINAL_USER_KZ_MOVEMENT.equals(this.productSellerType);
    }

    @Override
    public boolean isFinalUserKzConsumptionMovement() {
        return PRODUCT_SELLER_TYPE_FINAL_USER_KZ_CONSUMPTION_MOVEMENT.equals(this.productSellerType);
    }
}

