/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.math.BigDecimal;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.BigDecimalCheck;
import ru.uss.core.validation.common.PositiveNumber;
import ru.uss.core.validation.common.PositiveOrZero;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldExists;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;

@NotEmptyIfTargetFieldExists.List(value={@NotEmptyIfTargetFieldExists(field="quantityInPack", targetField="pinCode", message="{sntTobaccoProductV1.quantityInPack.notNull}")})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SntTobaccoProduct")
@Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0442\u0430\u0431\u0430\u0447\u043d\u043e\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u0438 (\u0438\u0441\u043a\u043b\u044e\u0447\u0430\u044f \u0446\u0438\u0444\u0440\u043e\u0432\u0443\u044e \u043c\u0430\u0440\u043a\u0438\u0440\u043e\u0432\u043a\u0443) (G8)")
public class SntTobaccoProductV1
extends SntBaseProductV1 {
    @ExactDigitsCount(count=12, message="{sntTobaccoProductV1.pinCode.wrongFormat}")
    @RequiredString(required=false, minLen=12, maxLen=12, fieldPath="sntTobaccoProductV1.pinCode")
    @ImmutableForReturnedSnt
    @Documentation(value="\u041f\u0418\u041d-\u043a\u043e\u0434 (G8 3)")
    private String pinCode;
    @RequiredString(required=true, minLen=1, maxLen=450, fieldPath="sntTobaccoProductV1.productName")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0431\u0430\u0447\u043d\u043e\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u0438 (G8 4)")
    private String productName;
    @Pattern(regexp="8751|992|5111|796|166|111|944|945", message="{sntTobaccoProductV1.measureUnitCode.pattern}")
    @RequiredString(required=true, minLen=1, maxLen=12, fieldPath="sntCommonProductV1.measureUnitCode")
    @XmlElement(required=true)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f (\u043a\u043e\u0440\u043e\u0431\u0430, \u0431\u043b\u043e\u043a\u0438, \u043f\u0430\u0447\u043a\u0438, \u0448\u0442\u0443\u043a\u0438, \u043a\u0438\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u044b, \u043c\u0438\u043b\u043b\u0438\u043b\u0438\u0442\u0440\u044b, \u043a\u0430\u043f\u0441\u0443\u043b\u044b, \u043a\u0430\u0440\u0442\u0440\u0438\u0434\u0436\u0438) (G8 6)")
    private @Pattern(regexp="8751|992|5111|796|166|111|944|945", message="{sntTobaccoProductV1.measureUnitCode.pattern}") String measureUnitCode;
    @PositiveNumber(fieldPath="sntTobaccoProductV1.quantityInPack")
    @BigDecimalCheck(fieldPath="sntTobaccoProductV1.quantityInPack", nullable=true, maxLeftLen=20, maxRightLen=6)
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0430\u0431\u0430\u0447\u043d\u043e\u0433\u043e \u0438\u0437\u0434\u0435\u043b\u0438\u044f \u0432 \u043a\u043e\u0440\u043e\u0431\u0435, \u0431\u043b\u043e\u043a\u0435, \u043f\u0430\u0447\u043a\u0435 (G8 7)")
    private BigDecimal quantityInPack;
    @PositiveNumber(fieldPath="sntTobaccoProductV1.numberOfPacks")
    @BigDecimalCheck(fieldPath="sntTobaccoProductV1.numberOfPacks", nullable=false, maxLeftLen=12, maxRightLen=0)
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e (\u043a\u043e\u0440\u043e\u0431\u043e\u0432, \u0431\u043b\u043e\u043a\u043e\u0432, \u043f\u0430\u0447\u0435\u043a, \u0448\u0442\u0443\u043a, \u043a\u0438\u043b\u043e\u0433\u0440\u0430\u043c\u043c, \u043c\u0438\u043b\u043b\u0438\u043b\u0438\u0442\u0440\u043e\u0432, \u043a\u0430\u043f\u0441\u0443\u043b, \u043a\u0430\u0440\u0442\u0440\u0438\u0434\u0436\u0435\u0439) (G8 8)")
    private BigDecimal numberOfPacks;
    @PositiveNumber(fieldPath="sntTobaccoProductV1.quantity")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=2, fieldPath="sntTobaccoProductV1.quantity")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e (\u0432 \u0448\u0442\u0443\u043a\u0430\u0445, \u043a\u0438\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430\u0445, \u043c\u0438\u043b\u043b\u0438\u043b\u0438\u0442\u0440\u0430\u0445) (G8 9)")
    private BigDecimal quantity;
    @PositiveOrZero(fieldPath="sntTobaccoProductV1.price")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=3, fieldPath="sntTobaccoProductV1.price")
    @XmlElement(required=true)
    @Documentation(value="\u0426\u0435\u043d\u0430 \u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443 \u0442\u043e\u0432\u0430\u0440\u0430 (G8 10)")
    private BigDecimal price;
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u041a\u043e\u0434 \u0442\u043e\u0432\u0430\u0440\u0430 (GTIN) (G8 19)")
    private String gtinCode;

    @Override
    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @Override
    public String getMeasureUnitCode() {
        return this.measureUnitCode;
    }

    public void setMeasureUnitCode(String measureUnitCode) {
        this.measureUnitCode = measureUnitCode;
    }

    public BigDecimal getQuantityInPack() {
        return this.quantityInPack;
    }

    public void setQuantityInPack(BigDecimal quantityInPack) {
        this.quantityInPack = quantityInPack;
    }

    public BigDecimal getNumberOfPacks() {
        return this.numberOfPacks;
    }

    public void setNumberOfPacks(BigDecimal numberOfPacks) {
        this.numberOfPacks = numberOfPacks;
    }

    @Override
    public String getMatchingMeasureUnitCode() {
        return this.measureUnitCode;
    }

    @Override
    public BigDecimal getMatchingQuantity() {
        return this.numberOfPacks;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    @Override
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getGtinCode() {
        return this.gtinCode;
    }

    @Override
    public String getMarkingCode() {
        return this.gtinCode;
    }

    public void setGtinCode(String gtinCode) {
        this.gtinCode = gtinCode;
    }

    @Override
    public SntProductTypeV1 getSntProductType() {
        return SntProductTypeV1.TOBACCO;
    }

    @Override
    public BigDecimal getQuantityToStore() {
        return this.getNumberOfPacks();
    }

    @Override
    public String getVstoreQuantityPath() {
        return "numberOfPacks";
    }

    @Override
    public BigDecimal getCertQuantity() {
        return this.numberOfPacks;
    }
}

