/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import ru.uss.core.adapter.DateAdapter;
import ru.uss.core.utils.EsfModelCollectionUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.BigDecimalCheck;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.esf.model.snt.SntParticipantType;
import ru.uss.esf.model.snt.SntVersion;
import ru.uss.esf.model.snt.abstractsnt.AbstractSnt;
import ru.uss.esf.model.snt.version.v1.SntAlcoholSetV1;
import ru.uss.esf.model.snt.version.v1.SntBaseProductSetV1;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntBiofuelSetV1;
import ru.uss.esf.model.snt.version.v1.SntCarCargoInfoV1;
import ru.uss.esf.model.snt.version.v1.SntConsigneeV1;
import ru.uss.esf.model.snt.version.v1.SntConsignorV1;
import ru.uss.esf.model.snt.version.v1.SntContractV1;
import ru.uss.esf.model.snt.version.v1.SntCustomerTypeV1;
import ru.uss.esf.model.snt.version.v1.SntCustomerV1;
import ru.uss.esf.model.snt.version.v1.SntDirectoryInfoV1;
import ru.uss.esf.model.snt.version.v1.SntExportControlProductSetV1;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntExportV1;
import ru.uss.esf.model.snt.version.v1.SntFillingOfAircraftV1;
import ru.uss.esf.model.snt.version.v1.SntImportV1;
import ru.uss.esf.model.snt.version.v1.SntOilSetV1;
import ru.uss.esf.model.snt.version.v1.SntOtherProductWithDigitalMarkSetV1;
import ru.uss.esf.model.snt.version.v1.SntPaperReasonTypeV1;
import ru.uss.esf.model.snt.version.v1.SntProductSetV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntReleaseGoodsInfoV1;
import ru.uss.esf.model.snt.version.v1.SntSellerTypeV1;
import ru.uss.esf.model.snt.version.v1.SntSellerV1;
import ru.uss.esf.model.snt.version.v1.SntSharingParticipantContractV1;
import ru.uss.esf.model.snt.version.v1.SntShippingInfoV1;
import ru.uss.esf.model.snt.version.v1.SntTobaccoSetV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldExists;
import ru.uss.esf.validation.invoice.ImmutableForAdditional;
import ru.uss.esf.validation.snt.ImmutableForFixedSnt;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;
import ru.uss.esf.validation.snt.version.v1.SntAlcoholSetCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntBiofuelSetCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntConsigneeCountryCodeCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntConsigneeTinCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntConsignorTinCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntContractCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntCurrencyCodeCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntCurrencyRateCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntCustomerActualAddressCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntCustomerCountryCodeCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntCustomerNonResidentCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntCustomerStatusCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntCustomerTinCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntDeclarationRequirementV1;
import ru.uss.esf.validation.snt.version.v1.SntDigitalMarkingMptCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntDigitalMarkingNotificationNumberCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntExportCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntExportControlSetCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntFillingOfAircraftCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntGeneralProductCountCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntImportCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntOilSetCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntPaperFieldsCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntProductIdCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntProductMeasureUnitCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntProductNameCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntProductNumberCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntProductOriginCodeCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntProductPinCodeCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntProductPriceDigitsFormatV1;
import ru.uss.esf.validation.snt.version.v1.SntRelationRegNumberCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntSellerCountryCodeCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntSellerNonResidentCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntSellerStatusCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntSellerTinCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntShippingDateCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntShippingInfoTransportTypeCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntStoreCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntTobaccoSetCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntTransferTypeCheckV1;

@SntShippingDateCheckV1
@SntRelationRegNumberCheckV1
@SntDigitalMarkingMptCheckV1
@SntPaperFieldsCheckV1
@SntImportCheckV1
@SntExportCheckV1
@SntTransferTypeCheckV1
@SntDigitalMarkingNotificationNumberCheckV1
@SntStoreCheckV1
@SntSellerTinCheckV1
@SntSellerNonResidentCheckV1
@SntSellerCountryCodeCheckV1
@SntSellerStatusCheckV1
@SntCustomerActualAddressCheckV1
@SntCustomerStatusCheckV1
@SntCustomerNonResidentCheckV1
@SntCustomerTinCheckV1
@SntCustomerCountryCodeCheckV1
@SntConsigneeCountryCodeCheckV1
@SntConsigneeTinCheckV1
@SntConsignorTinCheckV1
@SntFillingOfAircraftCheckV1
@SntShippingInfoTransportTypeCheckV1
@SntCurrencyCodeCheckV1
@SntCurrencyRateCheckV1
@SntProductNumberCheckV1
@SntGeneralProductCountCheckV1
@SntProductPriceDigitsFormatV1
@SntProductIdCheckV1
@SntDeclarationRequirementV1
@SntProductNameCheckV1
@SntProductOriginCodeCheckV1
@SntProductMeasureUnitCheckV1
@SntOilSetCheckV1
@SntBiofuelSetCheckV1
@SntTobaccoSetCheckV1
@SntAlcoholSetCheckV1
@SntExportControlSetCheckV1
@SntProductPinCodeCheckV1
@SntContractCheckV1
@NotEmptyIfTargetFieldExists.List(value={@NotEmptyIfTargetFieldExists(field="digitalMarkingNotificationDate", targetField="digitalMarkingNotificationNumber", message="{sntV1.digitalMarkingNotificationDate.notNull}")})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="snt")
@XmlType(name="SntV1")
@Documentation(value="\u0421\u041d\u0422")
public class SntV1
extends AbstractSnt {
    @XmlTransient
    private static final List<SntProductTypeV1> EXCISE_PRODUCT_TYPES = Arrays.asList(SntProductTypeV1.ETHANOL, SntProductTypeV1.WINE_MATERIAL, SntProductTypeV1.BEER, SntProductTypeV1.ALCOHOL_EXCEPT_BEER, SntProductTypeV1.OIL, SntProductTypeV1.BIOFUEL, SntProductTypeV1.TOBACCO);
    @XmlTransient
    public static final List<SntExportTypeV1> SNT_NO_CONFIRM_EXPORT_TYPES = Arrays.asList(SntExportTypeV1.EXPORT, SntExportTypeV1.EXPORT_FOR_PROCESSING, SntExportTypeV1.TEMPORARY_EXPORT, SntExportTypeV1.EXPORT_OF_TEMPORARY_IMPORTED_PRODUCT, SntExportTypeV1.AIRCRAFT_REFUELING);
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @XmlElement(required=false)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u0421\u041d\u0422 \u043d\u0430 \u0431\u0443\u043c\u0430\u0436\u043d\u043e\u043c \u043d\u043e\u0441\u0438\u0442\u0435\u043b\u0435 (A 2.1)")
    private Date datePaper;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u0431\u0443\u043c\u0430\u0436\u043d\u043e\u043c \u043d\u043e\u0441\u0438\u0442\u0435\u043b\u0435 (A 2.1.1)")
    private SntPaperReasonTypeV1 reasonPaper;
    @RequiredString(required=false, minLen=1, maxLen=36, fieldPath="sntV1.digitalMarkingNotificationNumber")
    @XmlElement(required=false)
    @Documentation(value="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0410\u043a\u0442\u0430/\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u043e \u0446\u0438\u0444\u0440\u043e\u0432\u043e\u0439 \u043c\u0430\u0440\u043a\u0438\u0440\u043e\u0432\u043a\u0435 (A 4.2)")
    private String digitalMarkingNotificationNumber;
    @XmlElement(required=false)
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u041c\u041f\u0422")
    private Long mptId;
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @XmlElement(required=false)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0410\u043a\u0442\u0430/\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u043e \u0446\u0438\u0444\u0440\u043e\u0432\u043e\u0439 \u043c\u0430\u0440\u043a\u0438\u0440\u043e\u0432\u043a\u0435 (A 4.2.1)")
    private Date digitalMarkingNotificationDate;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0412\u0432\u043e\u0437 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u043d\u0430 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0420\u041a (A 7)")
    @ImmutableForReturnedSnt
    @ImmutableForFixedSnt
    private SntImportV1 sntImport;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0412\u044b\u0432\u043e\u0437 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0441 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438 \u0420\u041a (A 8)")
    @ImmutableForReturnedSnt
    @ImmutableForFixedSnt
    private SntExportV1 sntExport;
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430 (A 9)")
    @ImmutableForReturnedSnt
    @ImmutableForFixedSnt
    private SntTransferTypeV1 transferType;
    @Valid
    @IsNotNull(fieldPath="sntV1.seller")
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 (B)")
    @ImmutableForReturnedSnt
    @ImmutableForFixedSnt
    private SntSellerV1 seller;
    @Valid
    @IsNotNull(fieldPath="sntV1.customer")
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f (C)")
    @ImmutableForReturnedSnt
    @ImmutableForFixedSnt
    private SntCustomerV1 customer;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0413\u0440\u0443\u0437\u043e\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c (D)")
    private SntConsignorV1 consignor;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0413\u0440\u0443\u0437\u043e\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c (D)")
    private SntConsigneeV1 consignee;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043f\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0435 (E)")
    private SntShippingInfoV1 shippingInfo;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0417\u0430\u043f\u0440\u0430\u0432\u043a\u0430 \u0432\u043e\u0437\u0434\u0443\u0448\u043d\u043e\u0433\u043e \u0441\u0443\u0434\u043d\u0430 (E1)")
    private SntFillingOfAircraftV1 fillingOfAircraft;
    @Valid
    @IsNotNull(fieldPath="sntV1.contract")
    @XmlElement(required=false)
    @Documentation(value="\u0414\u043e\u0433\u043e\u0432\u043e\u0440 (\u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442) \u043d\u0430 \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0443 \u0442\u043e\u0432\u0430\u0440\u0430 (F)")
    @ImmutableForAdditional
    @ImmutableForReturnedSnt
    private SntContractV1 contract;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0414\u043e\u0433\u043e\u0432\u043e\u0440 (\u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442) \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0423\u0421\u0414/\u0421\u0420\u041f (F1)")
    @ImmutableForReturnedSnt
    @ImmutableForFixedSnt
    private SntSharingParticipantContractV1 sharingParticipantContract;
    @RequiredString(required=true, minLen=3, maxLen=3, fieldPath="sntV1.currencyCode")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0432\u0430\u043b\u044e\u0442\u044b (50)")
    @ImmutableForReturnedSnt
    private String currencyCode;
    @BigDecimalCheck(nullable=true, maxLeftLen=6, maxRightLen=2, fieldPath="sntV1.currencyRate")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u0443\u0440\u0441 \u0432\u0430\u043b\u044e\u0442\u044b (51)")
    private BigDecimal currencyRate;
    @Valid
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0442\u043e\u0432\u0430\u0440\u0430\u043c (G1)")
    private SntProductSetV1 productSet;
    @Valid
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0430\u043b\u043a\u043e\u0433\u043e\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u0438 (G2 - 5)")
    private SntAlcoholSetV1 alcoholSet;
    @Valid
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u043c \u0432\u0438\u0434\u0430\u043c \u043d\u0435\u0444\u0442\u0435\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 (G6)")
    private SntOilSetV1 oilSet;
    @Valid
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0431\u0438\u043e\u0442\u043e\u043f\u043b\u0438\u0432\u0443 (G7)")
    private SntBiofuelSetV1 biofuelSet;
    @Valid
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0442\u0430\u0431\u0430\u0447\u043d\u043e\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u0438 (\u0438\u0441\u043a\u043b\u044e\u0447\u0430\u044f \u0446\u0438\u0444\u0440\u043e\u0432\u0443\u044e \u043c\u0430\u0440\u043a\u0438\u0440\u043e\u0432\u043a\u0443) (G8)")
    private SntTobaccoSetV1 tobaccoSet;
    @Valid
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0442\u043e\u0432\u0430\u0440\u0430\u043c, \u043f\u043e\u0434\u043b\u0435\u0436\u0430\u0449\u0438\u043c \u043c\u0430\u0440\u043a\u0438\u0440\u043e\u0432\u043a\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430\u043c\u0438 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438(\u0446\u0438\u0444\u0440\u043e\u0432\u0430\u044f \u043c\u0430\u0440\u043a\u0438\u0440\u043e\u0432\u043a\u0430) (G9)")
    private SntOtherProductWithDigitalMarkSetV1 otherProductWithDigitalMarkSet;
    @Valid
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0442\u043e\u0432\u0430\u0440\u0430\u043c, \u043f\u043e\u0434\u043b\u0435\u0436\u0430\u0449\u0438\u043c \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u043d\u043e\u043c\u0443 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044e (\u0434\u0432\u043e\u0439\u043d\u043e\u0433\u043e \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f , \u0432\u043e\u0435\u043d\u043d\u043e\u0433\u043e \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f) (G10)")
    private SntExportControlProductSetV1 exportControlProductSet;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043e \u0433\u0440\u0443\u0437\u0435, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0438\u043c\u043e\u043c \u043d\u0430 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u043c \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0435 (K)")
    private SntCarCargoInfoV1 carCargoInfo;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043f\u043e \u043e\u0442\u043f\u0443\u0441\u043a\u0443 \u0442\u043e\u0432\u0430\u0440\u0430 (L)")
    @ImmutableForFixedSnt
    private SntReleaseGoodsInfoV1 releaseGoodsInfo;
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f (O)")
    private SntDirectoryInfoV1 directoryInfo;

    public Date getDatePaper() {
        return this.datePaper;
    }

    public void setDatePaper(Date datePaper) {
        this.datePaper = datePaper;
    }

    public SntPaperReasonTypeV1 getReasonPaper() {
        return this.reasonPaper;
    }

    public void setReasonPaper(SntPaperReasonTypeV1 reasonPaper) {
        this.reasonPaper = reasonPaper;
    }

    public String getDigitalMarkingNotificationNumber() {
        return this.digitalMarkingNotificationNumber;
    }

    public void setDigitalMarkingNotificationNumber(String digitalMarkingNotificationNumber) {
        this.digitalMarkingNotificationNumber = digitalMarkingNotificationNumber;
    }

    public Long getMptId() {
        return this.mptId;
    }

    public void setMptId(Long mptId) {
        this.mptId = mptId;
    }

    public Date getDigitalMarkingNotificationDate() {
        return this.digitalMarkingNotificationDate;
    }

    public void setDigitalMarkingNotificationDate(Date digitalMarkingNotificationDate) {
        this.digitalMarkingNotificationDate = digitalMarkingNotificationDate;
    }

    public SntImportV1 getSntImport() {
        return this.sntImport;
    }

    public void setSntImport(SntImportV1 sntImport) {
        this.sntImport = sntImport;
    }

    public SntExportV1 getSntExport() {
        return this.sntExport;
    }

    public void setSntExport(SntExportV1 sntExport) {
        this.sntExport = sntExport;
    }

    public SntTransferTypeV1 getTransferType() {
        return this.transferType;
    }

    public void setTransferType(SntTransferTypeV1 transferType) {
        this.transferType = transferType;
    }

    public SntSellerV1 getSeller() {
        return this.seller;
    }

    public void setSeller(SntSellerV1 seller) {
        this.seller = seller;
    }

    public SntCustomerV1 getCustomer() {
        return this.customer;
    }

    public void setCustomer(SntCustomerV1 customer) {
        this.customer = customer;
    }

    public SntConsignorV1 getConsignor() {
        return this.consignor;
    }

    public void setConsignor(SntConsignorV1 consignor) {
        this.consignor = consignor;
    }

    public SntConsigneeV1 getConsignee() {
        return this.consignee;
    }

    public void setConsignee(SntConsigneeV1 consignee) {
        this.consignee = consignee;
    }

    public SntContractV1 getContract() {
        return this.contract;
    }

    public void setContract(SntContractV1 contract) {
        this.contract = contract;
    }

    public SntSharingParticipantContractV1 getSharingParticipantContract() {
        return this.sharingParticipantContract;
    }

    public void setSharingParticipantContract(SntSharingParticipantContractV1 sharingParticipantContract) {
        this.sharingParticipantContract = sharingParticipantContract;
    }

    public SntShippingInfoV1 getShippingInfo() {
        return this.shippingInfo;
    }

    public void setShippingInfo(SntShippingInfoV1 shippingInfo) {
        this.shippingInfo = shippingInfo;
    }

    public SntFillingOfAircraftV1 getFillingOfAircraft() {
        return this.fillingOfAircraft;
    }

    public void setFillingOfAircraft(SntFillingOfAircraftV1 fillingOfAircraft) {
        this.fillingOfAircraft = fillingOfAircraft;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @Override
    public BigDecimal getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(BigDecimal currencyRate) {
        this.currencyRate = currencyRate;
    }

    public SntProductSetV1 getProductSet() {
        return this.productSet;
    }

    public void setProductSet(SntProductSetV1 productSet) {
        this.productSet = productSet;
    }

    public SntOilSetV1 getOilSet() {
        return this.oilSet;
    }

    public void setOilSet(SntOilSetV1 oilSet) {
        this.oilSet = oilSet;
    }

    public SntBiofuelSetV1 getBiofuelSet() {
        return this.biofuelSet;
    }

    public void setBiofuelSet(SntBiofuelSetV1 biofuelSet) {
        this.biofuelSet = biofuelSet;
    }

    public SntTobaccoSetV1 getTobaccoSet() {
        return this.tobaccoSet;
    }

    public void setTobaccoSet(SntTobaccoSetV1 tobaccoSet) {
        this.tobaccoSet = tobaccoSet;
    }

    public SntAlcoholSetV1 getAlcoholSet() {
        return this.alcoholSet;
    }

    public void setAlcoholSet(SntAlcoholSetV1 alcoholSet) {
        this.alcoholSet = alcoholSet;
    }

    public SntOtherProductWithDigitalMarkSetV1 getOtherProductWithDigitalMarkSet() {
        return this.otherProductWithDigitalMarkSet;
    }

    public void setOtherProductWithDigitalMarkSet(SntOtherProductWithDigitalMarkSetV1 otherProductWithDigitalMarkSet) {
        this.otherProductWithDigitalMarkSet = otherProductWithDigitalMarkSet;
    }

    public SntExportControlProductSetV1 getExportControlProductSet() {
        return this.exportControlProductSet;
    }

    public void setExportControlProductSet(SntExportControlProductSetV1 exportControlProductSet) {
        this.exportControlProductSet = exportControlProductSet;
    }

    public SntCarCargoInfoV1 getCarCargoInfo() {
        return this.carCargoInfo;
    }

    public void setCarCargoInfo(SntCarCargoInfoV1 carCargoInfo) {
        this.carCargoInfo = carCargoInfo;
    }

    public SntReleaseGoodsInfoV1 getReleaseGoodsInfo() {
        return this.releaseGoodsInfo;
    }

    public void setReleaseGoodsInfo(SntReleaseGoodsInfoV1 releaseGoodsInfo) {
        this.releaseGoodsInfo = releaseGoodsInfo;
    }

    public SntDirectoryInfoV1 getDirectoryInfo() {
        return this.directoryInfo;
    }

    public void setDirectoryInfo(SntDirectoryInfoV1 directoryInfo) {
        this.directoryInfo = directoryInfo;
    }

    @Override
    public SntVersion getVersion() {
        return SntVersion.SntV1;
    }

    @Override
    public String getCreatorTin() {
        return this.creatorTin;
    }

    @Override
    public String getCreatorKogd() {
        if (SntParticipantType.RECIPIENT == this.getCreatorType()) {
            return this.customer != null ? this.customer.getKogd() : null;
        }
        return this.seller != null ? this.seller.getKogd() : null;
    }

    @Override
    public String getCustomerTin() {
        return this.customer == null ? null : this.customer.getTin();
    }

    @Override
    public String getCustomerBranchTin() {
        return this.customer == null ? null : this.customer.getBranchTin();
    }

    @Override
    public Set<String> getCustomerParticipantTins() {
        HashSet<String> customerParticipantTins = new HashSet<String>();
        if (this.customer != null) {
            if (this.customer.getTin() != null) {
                customerParticipantTins.add(this.customer.getTin());
            }
            if (this.customer.getBranchTin() != null) {
                customerParticipantTins.add(this.customer.getBranchTin());
            }
        }
        return customerParticipantTins;
    }

    @Override
    public String getSellerTin() {
        return this.seller == null ? null : this.seller.getTin();
    }

    @Override
    public String getSellerBranchTin() {
        return this.seller == null ? null : this.seller.getBranchTin();
    }

    @Override
    public Set<String> getSellerParticipantTins() {
        HashSet<String> sellerParticipantTins = new HashSet<String>();
        sellerParticipantTins.add(this.getSellerTin());
        sellerParticipantTins.add(this.getSellerBranchTin());
        return sellerParticipantTins;
    }

    @Override
    public boolean isCustomerIndividual() {
        return this.getCustomer() != null && this.getCustomer().isIndividual();
    }

    @Override
    public boolean hasExportControlProducts() {
        return this.getExportControlProductSet() != null && !CollectionUtils.isEmpty(this.getExportControlProductSet().getProducts());
    }

    @Override
    public boolean isEsfRequired() {
        if (this.sntImport != null || this.transferType != null) {
            return false;
        }
        return this.sntExport == null || !SntExportTypeV1.TEMPORARY_EXPORT.equals(this.sntExport.getExportType()) && !SntExportTypeV1.EXPORT_OF_TEMPORARY_IMPORTED_PRODUCT.equals(this.sntExport.getExportType());
    }

    @Override
    public String confirmerTin() {
        if (this.getSntExport() != null) {
            return this.getCreatorTin();
        }
        return this.getCustomerTin();
    }

    @Override
    public boolean isCustomerRetail() {
        return this.getCustomer() != null && this.getCustomer().isRetail();
    }

    @Override
    public boolean isSellerRetail() {
        return this.getSeller() != null && this.getSeller().isRetail();
    }

    @Override
    public boolean isCustomerRetailer() {
        return this.getCustomer() != null && this.getCustomer().isRetailer();
    }

    @Override
    public boolean isSellerRetailer() {
        return this.getSeller() != null && this.getSeller().isRetailer();
    }

    @Override
    public boolean isCustomerSmallRetailOutlet() {
        return this.getCustomer() != null && this.getCustomer().isSmallRetailOutlet();
    }

    @Override
    public SntParticipantType getCreatorType() {
        if (this.getCreatorProjectCode() == null) {
            if (StringUtils.equals(this.getSellerTin(), this.creatorTin) || StringUtils.equals(this.getSellerBranchTin(), this.creatorTin)) {
                return SntParticipantType.SENDER;
            }
            if (StringUtils.equals(this.getCustomerTin(), this.creatorTin) || StringUtils.equals(this.getCustomerBranchTin(), this.creatorTin)) {
                return SntParticipantType.RECIPIENT;
            }
        } else {
            if (this.getCreatorProjectCode().equals(this.getSellerProjectCode())) {
                return SntParticipantType.SENDER;
            }
            if (this.getCreatorProjectCode().equals(this.getCustomerProjectCode())) {
                return SntParticipantType.RECIPIENT;
            }
        }
        return null;
    }

    @Override
    public List<String> getRecipientTinList() {
        if (this.customer != null && !StringUtils.isEmpty(this.customer.getTin())) {
            return Collections.singletonList(this.customer.getTin());
        }
        return null;
    }

    @Override
    public List<String> getRecipientBranchTinList() {
        if (this.customer != null && !StringUtils.isEmpty(this.customer.getBranchTin())) {
            return Collections.singletonList(this.customer.getBranchTin());
        }
        return null;
    }

    @Override
    public List<String> getSenderTinList() {
        if (this.seller != null && !StringUtils.isEmpty(this.seller.getTin())) {
            return Collections.singletonList(this.seller.getTin());
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getSenderBranchTinList() {
        if (this.seller != null && !StringUtils.isEmpty(this.seller.getBranchTin())) {
            return Collections.singletonList(this.seller.getBranchTin());
        }
        return null;
    }

    @Override
    public DocumentParticipantType getCustomerType() {
        DocumentParticipantType documentParticipantType = null;
        if (this.customer != null && this.customer.getStatuses() != null) {
            documentParticipantType = this.customer.getParticipantType();
        }
        if (documentParticipantType == null) {
            return DocumentParticipantType.BUSINESS;
        }
        return documentParticipantType;
    }

    @Override
    public boolean hasExciseSections() {
        return CollectionUtils.containsAny(EXCISE_PRODUCT_TYPES, this.getProductTypes());
    }

    @Override
    public Long getSellerStoreId() {
        return this.seller == null ? null : this.seller.getStoreId();
    }

    @Override
    public Long getCustomerStoreId() {
        return this.customer == null ? null : this.customer.getStoreId();
    }

    @Override
    public boolean isTransferOnePersonInKz() {
        return SntTransferTypeV1.ONE_PERSON_IN_KZ.equals(this.transferType);
    }

    @Override
    public Long getSellerProjectCode() {
        return LambdaUtils.nullSafeApplyFunction(this.seller, SntSellerV1::getProjectCode);
    }

    @Override
    public Long getCustomerProjectCode() {
        return LambdaUtils.nullSafeApplyFunction(this.customer, SntCustomerV1::getProjectCode);
    }

    @Override
    public List<String> getSellerProjectParticipantTinList() {
        return LambdaUtils.nullSafeApplyFunction(this.seller, SntSellerV1::getProjectParticipantTinList);
    }

    @Override
    public List<String> getCustomerProjectParticipantTinList() {
        return LambdaUtils.nullSafeApplyFunction(this.customer, SntCustomerV1::getProjectParticipantTinList);
    }

    @Override
    public boolean isLeasing() {
        boolean isLeasing = false;
        if (this.seller != null && this.customer != null) {
            isLeasing = !(!this.customer.containsCategory(SntCustomerTypeV1.LESSOR) && !this.customer.containsCategory(SntCustomerTypeV1.LESSEE) || !this.seller.containsCategory(SntSellerTypeV1.LESSOR) && !this.seller.containsCategory(SntSellerTypeV1.LESSEE));
        }
        return isLeasing;
    }

    @Override
    public boolean hasFinalUserMark() {
        boolean hasFinalUserMark = false;
        if (this.oilSet != null && BooleanUtils.isTrue(this.oilSet.getFinalUserFlag())) {
            hasFinalUserMark = true;
        }
        return hasFinalUserMark;
    }

    @Override
    public DocumentParticipantType getSellerType() {
        DocumentParticipantType documentParticipantType = null;
        if (this.seller != null && this.seller.getStatuses() != null) {
            documentParticipantType = this.seller.getParticipantType();
        }
        if (documentParticipantType == null) {
            return DocumentParticipantType.BUSINESS;
        }
        return documentParticipantType;
    }

    @Override
    public Set<String> getTnvedCodeSet() {
        Set<String> tnveds = this.getProductsByType().values().stream().flatMap(Collection::stream).map(SntBaseProductV1::getTnvedCode).collect(Collectors.toSet());
        return tnveds;
    }

    @Override
    public boolean hasTransferExportImport() {
        return this.sntExport != null || this.sntImport != null || this.transferType != null;
    }

    List<SntProductTypeV1> getProductTypes() {
        ArrayList<SntProductTypeV1> productTypes = new ArrayList<SntProductTypeV1>();
        Map<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType = this.getProductsByType();
        for (SntProductTypeV1 sntProductTypeV1 : productsByType.keySet()) {
            if (CollectionUtils.isEmpty((Collection)productsByType.get((Object)sntProductTypeV1))) continue;
            productTypes.add(sntProductTypeV1);
        }
        return productTypes;
    }

    public Map<SntProductTypeV1, List<? extends SntBaseProductV1>> getProductsByType() {
        HashMap<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType = new HashMap<SntProductTypeV1, List<? extends SntBaseProductV1>>();
        if (this.productSet != null && this.productSet.getProducts() != null) {
            productsByType.put(SntProductTypeV1.PRODUCT, this.productSet.getProducts());
        }
        if (this.alcoholSet != null) {
            if (this.alcoholSet.getEthanolProductSet() != null && this.alcoholSet.getEthanolProductSet().getProducts() != null) {
                productsByType.put(SntProductTypeV1.ETHANOL, this.alcoholSet.getEthanolProductSet().getProducts());
            }
            if (this.alcoholSet.getWineMaterialProductSet() != null && this.alcoholSet.getWineMaterialProductSet().getProducts() != null) {
                productsByType.put(SntProductTypeV1.WINE_MATERIAL, this.alcoholSet.getWineMaterialProductSet().getProducts());
            }
            if (this.alcoholSet.getAlcoholBeerProductSet() != null && this.alcoholSet.getAlcoholBeerProductSet().getProducts() != null) {
                productsByType.put(SntProductTypeV1.BEER, this.alcoholSet.getAlcoholBeerProductSet().getProducts());
            }
            if (this.alcoholSet.getAlcoholExceptBeerProductSet() != null && this.alcoholSet.getAlcoholExceptBeerProductSet().getProducts() != null) {
                productsByType.put(SntProductTypeV1.ALCOHOL_EXCEPT_BEER, this.alcoholSet.getAlcoholExceptBeerProductSet().getProducts());
            }
        }
        if (this.oilSet != null && this.oilSet.getProducts() != null) {
            productsByType.put(SntProductTypeV1.OIL, this.oilSet.getProducts());
        }
        if (this.biofuelSet != null && this.biofuelSet.getProducts() != null) {
            productsByType.put(SntProductTypeV1.BIOFUEL, this.biofuelSet.getProducts());
        }
        if (this.tobaccoSet != null && this.tobaccoSet.getProducts() != null) {
            productsByType.put(SntProductTypeV1.TOBACCO, this.tobaccoSet.getProducts());
        }
        if (this.otherProductWithDigitalMarkSet != null && this.otherProductWithDigitalMarkSet.getProducts() != null) {
            productsByType.put(SntProductTypeV1.OTHER_PRODUCT_WITH_DIGITAL_MARK, this.otherProductWithDigitalMarkSet.getProducts());
        }
        if (this.exportControlProductSet != null && this.exportControlProductSet.getProducts() != null) {
            productsByType.put(SntProductTypeV1.EXPORT_CONTROL_PRODUCT, this.exportControlProductSet.getProducts());
        }
        return productsByType;
    }

    public List<SntBaseProductV1> getProducts() {
        return this.getProductSets().stream().filter(ps -> ps.getProducts() != null).flatMap(ps -> ps.getProducts().stream()).collect(Collectors.toList());
    }

    public List<SntBaseProductSetV1> getProductSets() {
        ArrayList<SntBaseProductSetV1> productSetList = new ArrayList<SntBaseProductSetV1>();
        EsfModelCollectionUtils.nullSafeAddAll(productSetList, this.productSet, this.oilSet, this.tobaccoSet, this.biofuelSet, this.exportControlProductSet, this.otherProductWithDigitalMarkSet);
        if (this.getAlcoholSet() != null) {
            EsfModelCollectionUtils.nullSafeAddAll(productSetList, this.getAlcoholSet().getProductSets());
        }
        return productSetList;
    }

    public BigDecimal getTotalPriceWithTax() {
        return this.getProductSets().stream().map(SntBaseProductSetV1::getTotalPriceWithTax).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public boolean hasExportType() {
        return this.sntExport != null;
    }

    @Override
    public boolean isSellerLessor() {
        return this.getSeller() != null && this.getSeller().isLessor();
    }

    @Override
    public boolean isCustomerLessor() {
        return this.getCustomer() != null && this.getCustomer().isLessor();
    }

    @Override
    public BigDecimal getTotalSumWithoutTax() {
        return this.getProductSets().stream().map(SntBaseProductSetV1::getTotalPriceWithoutTax).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

