/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.usermng;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.esf.model.arm.AdminPermissionInfo;
import ru.uss.esf.model.arm.AdminPermissionStatus;
import ru.uss.esf.model.usermng.AdminPermission;
import ru.uss.esf.model.usermng.ArmUserBlockingType;
import ru.uss.esf.model.usermng.UserServiceRoleType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ArmUser")
@Documentation(value="\u041e\u0431\u044a\u0435\u043a\u0442 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u044e\u0449\u0438\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435 \u0410\u0420\u041c")
public class ArmUser
implements Comparable<ArmUser>,
Serializable {
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0418\u041d")
    private String iin;
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b")
    private String email;
    @Documentation(value="\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d")
    private String mobile;
    @Documentation(value="\u041a\u043e\u0434 \u041e\u0413\u0414 \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a \u0438\u043c\u0435\u0435\u0442 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u044f")
    private String ogdCode;
    @XmlTransient
    private UserServiceRoleType userServiceRoleType;
    @XmlTransient
    @JsonProperty(value="adminPermissions", access=JsonProperty.Access.READ_ONLY)
    private Set<AdminPermission> permissions = new HashSet<AdminPermission>();
    @XmlTransient
    @JsonProperty(value="adminPermissionInfos")
    private Set<AdminPermissionInfo> permissionInfos = new HashSet<AdminPermissionInfo>();
    @Documentation(value="\u0410\u043a\u0442\u0438\u0432\u0435\u043d")
    private boolean active;
    @Documentation(value="\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d")
    private boolean blocked;
    @Documentation(value="\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u041a\u0413\u0414")
    private boolean mobileUser;
    @Documentation(value="\u0422\u0438\u043f \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438")
    private ArmUserBlockingType blockingType;
    @Documentation(value="\u0421\u0447\u0435\u0442\u0447\u0438\u043a \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0445 \u0432\u0432\u043e\u0434\u043e\u0432 \u043f\u0430\u0440\u043e\u043b\u044f")
    private int incorrectPasswordCounter;
    @Documentation(value="IP-\u0430\u0434\u0440\u0435\u0441, \u0441 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u0439\u0442\u0438 \u0432 \u0410\u0420\u041c")
    private String ipAddress;
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0438\u0441\u0442\u0435\u0447\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u044f")
    private Date passwordExpirationDate;
    @XmlTransient
    @Documentation(value="\u0424\u0418\u041e \u041d\u041f")
    private String name;
    @XmlTransient
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u041e\u0413\u0414")
    private String ogdName;
    @Documentation(value="\u041f\u0443\u043d\u043a\u0442 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430, \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0439 \u043a \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0443")
    private String checkpointCode;
    @JsonIgnore
    @XmlTransient
    @Documentation(value="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438")
    private String blockingReason;

    public UserServiceRoleType getUserServiceRoleType() {
        return this.userServiceRoleType;
    }

    public void setUserServiceRoleType(UserServiceRoleType userServiceRoleType) {
        this.userServiceRoleType = userServiceRoleType;
    }

    public Set<AdminPermission> getPermissions() {
        return this.permissions;
    }

    public Set<AdminPermissionInfo> getPermissionInfos() {
        return this.permissionInfos;
    }

    public void setPermissionInfos(Set<AdminPermissionInfo> permissionInfos) {
        if (permissionInfos == null) {
            this.permissionInfos = new HashSet<AdminPermissionInfo>();
            this.permissions = new HashSet<AdminPermission>();
        } else {
            this.permissionInfos = permissionInfos;
            this.permissions = permissionInfos.stream().filter(perm -> perm.getStatus() == AdminPermissionStatus.CONFIRMED).map(AdminPermissionInfo::getPermission).collect(Collectors.toSet());
        }
    }

    public String getIin() {
        return this.iin;
    }

    public void setIin(String iin) {
        this.iin = iin;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getOgdCode() {
        return this.ogdCode;
    }

    public void setOgdCode(String ogdCode) {
        this.ogdCode = ogdCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isSuperAdmin() {
        return UserServiceRoleType.SUPER_ADMIN.equals((Object)this.userServiceRoleType);
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isMobileUser() {
        return this.mobileUser;
    }

    public void setMobileUser(boolean mobileUser) {
        this.mobileUser = mobileUser;
    }

    public ArmUserBlockingType getBlockingType() {
        return this.blockingType;
    }

    public void setBlockingType(ArmUserBlockingType blockingType) {
        this.blockingType = blockingType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIncorrectPasswordCounter() {
        return this.incorrectPasswordCounter;
    }

    public void setIncorrectPasswordCounter(int incorrectPasswordCounter) {
        this.incorrectPasswordCounter = incorrectPasswordCounter;
    }

    public String getOgdName() {
        return this.ogdName;
    }

    public void setOgdName(String ogdName) {
        this.ogdName = ogdName;
    }

    @Override
    public int compareTo(ArmUser o) {
        return this.iin.compareTo(o.iin);
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Date getPasswordExpirationDate() {
        return this.passwordExpirationDate;
    }

    public void setPasswordExpirationDate(Date passwordExpirationDate) {
        this.passwordExpirationDate = passwordExpirationDate;
    }

    public String getCheckpointCode() {
        return this.checkpointCode;
    }

    public void setCheckpointCode(String checkpointCode) {
        this.checkpointCode = checkpointCode;
    }

    public String getBlockingReason() {
        return this.blockingReason;
    }

    public void setBlockingReason(String blockingReason) {
        this.blockingReason = blockingReason;
    }
}

