/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.usermng;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.esf.model.dictionary.Taxpayer;
import ru.uss.esf.model.usermng.AdminPermission;
import ru.uss.esf.model.usermng.ArmUser;
import ru.uss.esf.model.usermng.BusinessProfileType;
import ru.uss.esf.model.usermng.BusinessUser;
import ru.uss.esf.model.usermng.SystemProfileType;
import ru.uss.esf.model.usermng.UserServiceRoleType;
import ru.uss.esf.model.usermng.UserStatusType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="User")
@Documentation(value="\u041e\u0431\u044a\u0435\u043a\u0442 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u044e\u0449\u0438\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435")
public class User
implements Comparable<User>,
Serializable {
    public static final String PASSWORD_REGEXP = "^.*(?=.{8,})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).*$";
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("^.*(?=.{8,})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).*$");
    @XmlTransient
    private SystemProfileType systemProfileType;
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0418\u041d")
    private String login;
    @XmlTransient
    private String password;
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b")
    private String email;
    @Documentation(value="\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d")
    private String mobile;
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u044f\u044e\u0449\u0435\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private String issueDate;
    @Documentation(value="\u041a\u0435\u043c \u0432\u044b\u0434\u0430\u043d \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u044f\u044e\u0449\u0438\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442")
    private String issuedBy;
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u044f\u044e\u0449\u0435\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private String passportNum;
    @XmlTransient
    private Boolean isShow;
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f")
    private UserStatusType status;
    @XmlElement
    @Documentation(value="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f")
    private String reason;
    @XmlTransient
    private String preferences;
    @XmlTransient
    private String messageHistory;
    @XmlTransient
    private BusinessUser permissionProfile;
    @XmlTransient
    @Documentation(value="\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u0440\u043e\u0444\u0438\u043b\u0435\u0439")
    private List<BusinessUser> profiles = new ArrayList<BusinessUser>();
    @XmlTransient
    @Documentation(value="\u041e\u0431\u044a\u0435\u043a\u0442-\u0441\u0432\u044f\u0437\u043a\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435\u043c \u043e\u0442 \u0438\u043c\u0435\u043d\u0438 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u043e\u043d \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442")
    private List<BusinessUser> enterpriseEntries = new ArrayList<BusinessUser>();
    @XmlElement(required=true)
    @Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u0430\u044f \u0438\u0437 \u0415\u0425\u0414")
    private Taxpayer taxpayer;
    @XmlTransient
    @Documentation(value="\u041e\u0431\u044a\u0435\u043a\u0442-\u0441\u0432\u044f\u0437\u043a\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u043c \u0432 \u0410\u0420\u041c")
    private ArmUser armUser;
    @XmlTransient
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0415\u0410\u042d\u0421")
    private boolean isEaecUser;
    @XmlTransient
    @JsonIgnore
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0447\u0442\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043f\u0440\u043e\u0445\u043e\u0434\u0438\u0442 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044e \u0447\u0435\u0440\u0435\u0437 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u043e QR")
    private boolean isQrAuthSign = false;

    public static boolean isPasswordValid(String password) {
        return PASSWORD_PATTERN.matcher(password).matches();
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(String issueDate) {
        this.issueDate = issueDate;
    }

    public String getIssuedBy() {
        return this.issuedBy;
    }

    public void setIssuedBy(String issuedBy) {
        this.issuedBy = issuedBy;
    }

    public UserStatusType getStatus() {
        return this.status;
    }

    public void setStatus(UserStatusType status) {
        this.status = status;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getPreferences() {
        return this.preferences;
    }

    public void setPreferences(String preferences) {
        this.preferences = preferences;
    }

    public String getMessageHistory() {
        return this.messageHistory;
    }

    public void setMessageHistory(String messageHistory) {
        this.messageHistory = messageHistory;
    }

    @Override
    public int compareTo(User other) {
        return this.login.compareTo(other.login);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof User && ((User)o).getLogin().equals(this.getLogin());
    }

    public int hashCode() {
        return !StringUtils.isEmpty(this.getLogin()) ? this.getLogin().hashCode() : 1;
    }

    public SystemProfileType getSystemProfileType() {
        return this.systemProfileType;
    }

    public void setSystemProfileType(SystemProfileType systemProfileType) {
        this.systemProfileType = systemProfileType;
    }

    public BusinessUser getPermissionProfile() {
        return this.permissionProfile;
    }

    public void setPermissionProfile(BusinessUser permissionProfile) {
        this.permissionProfile = permissionProfile;
    }

    public List<BusinessUser> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<BusinessUser> profiles) {
        this.profiles = profiles;
    }

    public List<BusinessUser> getEnterpriseEntries() {
        return this.enterpriseEntries;
    }

    public void setEnterpriseEntries(List<BusinessUser> enterpriseEntries) {
        this.enterpriseEntries = enterpriseEntries;
    }

    public String getPassportNum() {
        return this.passportNum;
    }

    public void setPassportNum(String passportNum) {
        this.passportNum = passportNum;
    }

    public Boolean getShow() {
        return this.isShow;
    }

    public void setShow(Boolean show) {
        this.isShow = show;
    }

    public Taxpayer getTaxpayer() {
        return this.taxpayer;
    }

    public void setTaxpayer(Taxpayer taxpayer) {
        this.taxpayer = taxpayer;
    }

    public boolean isEaecUser() {
        return this.isEaecUser;
    }

    public void setEaecUser(boolean eaecUser) {
        this.isEaecUser = eaecUser;
    }

    public UserServiceRoleType getUserServiceRoleType() {
        if (this.armUser == null || !this.armUser.isActive() || this.armUser.isBlocked() || this.armUser.getPasswordExpirationDate().before(DateTimeUtils.now())) {
            return null;
        }
        return this.armUser.getUserServiceRoleType();
    }

    public void setUserServiceRoleType(UserServiceRoleType userServiceRoleType) {
        throw new NotImplementedException("change armUser separately");
    }

    public Set<AdminPermission> getAdminPermissions() {
        if (this.armUser == null || !this.armUser.isActive() || this.armUser.isBlocked() || this.armUser.getPasswordExpirationDate().before(DateTimeUtils.now())) {
            return new HashSet<AdminPermission>();
        }
        return this.armUser.getPermissions();
    }

    public void setAdminPermissions(Set<AdminPermission> adminPermissions) {
        throw new NotImplementedException("change armUser separately");
    }

    public Set<AdminPermission> getPermissions() {
        if (this.armUser == null || !this.armUser.isActive() || this.armUser.isBlocked() || this.armUser.getPasswordExpirationDate().before(DateTimeUtils.now())) {
            return new HashSet<AdminPermission>();
        }
        return this.armUser.getPermissions();
    }

    public void setPermissions(Set<String> permissions) {
        throw new NotImplementedException("change armUser separately");
    }

    @Deprecated
    public BusinessUser getBusinessEntryForTin(String tin, BusinessProfileType profileType) {
        for (BusinessUser entry : this.enterpriseEntries) {
            if (!Objects.equals(tin, entry.getTin()) || !Objects.equals((Object)profileType, (Object)entry.getBusinessProfileType())) continue;
            return entry;
        }
        return null;
    }

    public List<BusinessUser> getBusinessEntriesForTin(String tin) {
        LinkedList<BusinessUser> result = new LinkedList<BusinessUser>();
        for (BusinessUser entry : this.enterpriseEntries) {
            if (!Objects.equals(tin, entry.getTin())) continue;
            result.add(entry);
        }
        return result;
    }

    @Deprecated
    public BusinessUser getAllBusinessEntryForTin(String tin) {
        for (BusinessUser entry : this.enterpriseEntries) {
            if (!Objects.equals(tin, entry.getTin())) continue;
            return entry;
        }
        for (BusinessUser entry : this.enterpriseEntries) {
            for (BusinessUser branch : entry.getBranches()) {
                if (!branch.getTin().equals(tin)) continue;
                return entry;
            }
        }
        return null;
    }

    public BusinessUser findProfile(String profileId) {
        for (BusinessUser profile2 : this.profiles) {
            if (!Objects.equals(profileId, profile2.getId())) continue;
            return profile2;
        }
        return null;
    }

    public BusinessUser findProfile(String tin, BusinessProfileType businessProfileType, Long projectCode) {
        BusinessUser individual;
        for (BusinessUser profile2 : this.profiles) {
            if (profile2.isIndividualProfile() || !Objects.equals(tin, profile2.getTin()) || businessProfileType != profile2.getBusinessProfileType() || !Objects.equals(projectCode, profile2.getProjectCode()) || profile2.isBranch()) continue;
            return profile2;
        }
        for (BusinessUser profile2 : this.profiles) {
            if (profile2.isIndividualProfile() || !Objects.equals(tin, profile2.getTin()) || businessProfileType != profile2.getBusinessProfileType() || !Objects.equals(projectCode, profile2.getProjectCode()) || !profile2.isBranch()) continue;
            return profile2;
        }
        if (!this.profiles.isEmpty() && this.profiles.get(0).isIndividualProfile() && Objects.equals(tin, (individual = this.profiles.get(0)).getTin())) {
            return individual;
        }
        return null;
    }

    public BusinessUser findProfile(String tin, Long projectCode) {
        BusinessUser individual;
        for (BusinessUser profile2 : this.profiles) {
            if (profile2.isIndividualProfile() || !Objects.equals(tin, profile2.getTin()) || !Objects.equals(projectCode, profile2.getProjectCode()) || profile2.isBranch()) continue;
            return profile2;
        }
        for (BusinessUser profile2 : this.profiles) {
            if (profile2.isIndividualProfile() || !Objects.equals(tin, profile2.getTin()) || !Objects.equals(projectCode, profile2.getProjectCode()) || !profile2.isBranch()) continue;
            return profile2;
        }
        if (!this.profiles.isEmpty() && this.profiles.get(0).isIndividualProfile() && Objects.equals(tin, (individual = this.profiles.get(0)).getTin())) {
            return individual;
        }
        return null;
    }

    public Set<String> getServicePermissionSet() {
        HashSet<String> permissions = new HashSet<String>();
        if (this.armUser != null && this.armUser.getUserServiceRoleType() != null) {
            for (AdminPermission permission : this.armUser.getPermissions()) {
                if (permission == null) continue;
                permissions.add(permission.getCode());
            }
        }
        return permissions;
    }

    public boolean isAdmin() {
        return this.armUser != null && this.armUser.isActive() && !this.armUser.isBlocked() && !this.armUser.getPasswordExpirationDate().before(DateTimeUtils.now());
    }

    public boolean isSuperAdmin() {
        if (this.armUser == null || !this.armUser.isActive() || this.armUser.isBlocked() || this.armUser.getPasswordExpirationDate().before(DateTimeUtils.now())) {
            return false;
        }
        return UserServiceRoleType.SUPER_ADMIN.equals((Object)this.armUser.getUserServiceRoleType());
    }

    public boolean isRegisteredAsEntrepreneur() {
        return this.getBusinessEntryForTin(this.getLogin(), BusinessProfileType.ENTREPRENEUR) != null;
    }

    public String toString() {
        return "User{login='" + this.login + "'}";
    }

    public static User user(String login) {
        User result = new User();
        result.setLogin(login);
        return result;
    }

    public ArmUser getArmUser() {
        return this.armUser;
    }

    public void setArmUser(ArmUser armUser) {
        this.armUser = armUser;
    }

    public boolean hasProfileOfType(BusinessProfileType profileType) {
        if (CollectionUtils.isEmpty(this.profiles)) {
            return false;
        }
        return this.profiles.stream().map(BusinessUser::getBusinessProfileType).collect(Collectors.toSet()).contains((Object)profileType);
    }

    public boolean isQrAuthSign() {
        return this.isQrAuthSign;
    }

    public void setQrAuthSign(boolean qrAuthSign) {
        this.isQrAuthSign = qrAuthSign;
    }
}

