/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.awp.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.awp.abstractawp.AwpType;
import ru.uss.esf.model.awp.abstractawp.RelatedAwp;
import ru.uss.esf.model.awp.version.v1.AwpV1;
import ru.uss.esf.validation.awp.version.v1.AwpTypeCheckV1;

public class AwpTypeValidatorV1
extends AbstractClassLevelValidator<AwpTypeCheckV1, AwpV1> {
    @Override
    public void initialize(AwpTypeCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(AwpV1 awpV1, ConstraintValidatorContext context) {
        boolean isValid = true;
        if (awpV1.getAwpType() == AwpType.PRIMARY && awpV1.getRelatedAwp() != null) {
            return this.setupContextWithValidationError(context, "relatedAwp", this.generateNullFieldMessage("relatedAwp"));
        }
        if (awpV1.getAwpType() == AwpType.FIXED) {
            if (awpV1.getRelatedAwp() == null) {
                return this.setupContextWithValidationError(context, "relatedAwp", this.generateNotNullFieldMessage("relatedAwp"));
            }
            RelatedAwp relatedAwp = awpV1.getRelatedAwp();
            if (relatedAwp.getDate() == null) {
                isValid = this.setupContextWithValidationError(context, "relatedAwp.date", this.generateNotNullFieldMessage("relatedAwp.date"));
            }
            if (StringUtils.isEmpty(relatedAwp.getNum())) {
                isValid = this.setupContextWithValidationError(context, "relatedAwp.num", this.generateNotNullFieldMessage("relatedAwp.num"));
            }
            if (StringUtils.isEmpty(relatedAwp.getRegistrationNumber())) {
                isValid = this.setupContextWithValidationError(context, "relatedAwp.registrationNumber", this.generateNotNullFieldMessage("relatedAwp.registrationNumber"));
            }
        }
        return isValid;
    }
}

