/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.awp.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.awp.version.v1.AwpContractV1;
import ru.uss.esf.validation.awp.version.v1.ContractCheckV1;

public class ContractCheckValidatorV1
extends AbstractClassLevelValidator<ContractCheckV1, AwpContractV1> {
    @Override
    public void initialize(ContractCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(AwpContractV1 value, ConstraintValidatorContext context) {
        boolean hasError = false;
        if (BooleanUtils.isTrue(value.getContract())) {
            if (value.getNumber() == null) {
                this.setupContextWithValidationError(context, "number", this.generateNotNullFieldMessage("contract.number"));
                hasError = true;
            }
            if (value.getDate() == null) {
                this.setupContextWithValidationError(context, "date", this.generateNotNullFieldMessage("contract.date"));
                hasError = true;
            }
        } else if (BooleanUtils.isFalse(value.getContract()) && (value.getNumber() != null || value.getDate() != null)) {
            this.setupContextWithValidationError(context, "isContract", "{contract.isContract.null}");
            hasError = true;
        }
        return !hasError;
    }
}

