/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.awp.version.v1;

import java.util.Objects;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.awp.abstractawp.AwpRegistrationType;
import ru.uss.esf.model.awp.version.v1.AwpSenderParticipantV1;
import ru.uss.esf.validation.awp.version.v1.SenderSharingParticipantCheckV1;

public class SenderSharingParticipantCheckValidatorV1
extends AbstractClassLevelValidator<SenderSharingParticipantCheckV1, AwpSenderParticipantV1> {
    @Override
    public void initialize(SenderSharingParticipantCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(AwpSenderParticipantV1 value, ConstraintValidatorContext context) {
        boolean isValid = true;
        if (value.getRegistrationType() == AwpRegistrationType.SHARING_AGREEMENT_PARTICIPANT || value.getRegistrationType() == AwpRegistrationType.JOINT_ACTIVITY_PARTICIPANT) {
            if (StringUtils.isEmpty(value.getSharingParticipantNumber())) {
                this.setupContextWithValidationError(context, "senders[0].sharingParticipantNumber", this.generateNotNullFieldMessage("awp.senders.sharingParticipantNumber"));
                isValid = false;
            }
            if (Objects.isNull(value.getSharingParticipantDate())) {
                this.setupContextWithValidationError(context, "senders[0].sharingParticipantDate", this.generateNotNullFieldMessage("awp.senders.sharingParticipantDate"));
                isValid = false;
            }
        }
        return isValid;
    }
}

