/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.awp.version.v1;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.awp.version.v1.AwpWorkV1;
import ru.uss.esf.validation.awp.version.v1.SumWithoutTaxCheckV1;

public class SumWithoutTaxValidatorV1
extends AbstractClassLevelValidator<SumWithoutTaxCheckV1, AwpWorkV1> {
    @Override
    public void initialize(SumWithoutTaxCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(AwpWorkV1 value, ConstraintValidatorContext context) {
        if (value.getQuantity() != null && value.getUnitPriceWithoutTax() != null) {
            BigDecimal calculatedQuantity = value.getUnitPriceWithoutTax().multiply(value.getQuantity()).setScale(2, RoundingMode.HALF_UP);
            if (value.getSumWithoutTax() == null || calculatedQuantity.compareTo(value.getSumWithoutTax()) != 0) {
                return this.setupContextWithValidationError(context, "{awpField.sumWithoutTax.incorrect}");
            }
        }
        return true;
    }
}

